/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.renderer.entity;

import com.bokmcdok.butterflies.client.model.ButterflyEggModel;
import com.bokmcdok.butterflies.client.renderer.entity.state.ButterflyEggRenderState;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyEggRenderer
extends MobRenderer<ButterflyEgg, ButterflyEggRenderState, ButterflyEggModel> {
    public ButterflyEggRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ButterflyEggModel(context.bakeLayer(ButterflyEggModel.LAYER_LOCATION)), 0.05f);
    }

    @NotNull
    public ButterflyEggRenderState createRenderState() {
        return new ButterflyEggRenderState();
    }

    public void extractRenderState(@NotNull ButterflyEgg entity, @NotNull ButterflyEggRenderState state, float partialTick) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, partialTick);
        state.surfaceDirection = entity.getSurfaceDirection();
        state.renderScale = entity.getRenderScale();
        state.texture = entity.getTexture();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ButterflyEggRenderState renderState) {
        return renderState.texture;
    }

    protected void scale(@NotNull ButterflyEggRenderState renderState, PoseStack poses) {
        float s = renderState.renderScale;
        poses.scale(s, s, s);
    }

    public void render(@NotNull ButterflyEggRenderState renderState, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int p_115460_) {
        Direction direction = renderState.surfaceDirection;
        if (direction == Direction.UP) {
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        } else if (direction == Direction.NORTH) {
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        } else if (direction == Direction.SOUTH) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        } else if (direction == Direction.WEST) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        } else if (direction == Direction.EAST) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
        super.render((LivingEntityRenderState)renderState, poseStack, multiBufferSource, p_115460_);
    }
}

