/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event;

import com.bokmcdok.butterflies.network.protocol.common.custom.ClientBoundButterflyDataPacket;
import com.bokmcdok.butterflies.network.protocol.common.custom.ClientPayloadHandler;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ModEventListener {
    private final ItemRegistry itemRegistry;

    public ModEventListener(IEventBus modEventBus, ItemRegistry itemRegistry) {
        modEventBus.register((Object)this);
        this.itemRegistry = itemRegistry;
    }

    @SubscribeEvent
    private void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept((ItemLike)this.itemRegistry.getButterflyFeeder().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyMicroscope().get());
        } else if (event.getTabKey() == CreativeModeTabs.COLORED_BLOCKS) {
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiBlack().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiBlue().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiBrown().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiCyan().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiGray().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiGreen().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiLightBlue().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiLightGray().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiLime().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiMagenta().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiOrange().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiPink().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiPurple().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiRed().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiWhite().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyOrigamiYellow().get());
        } else if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept((ItemLike)this.itemRegistry.getButterflyPotterySherd().get());
            event.accept((ItemLike)this.itemRegistry.getInfestedApple().get());
            event.accept((ItemLike)this.itemRegistry.getSilk().get());
            event.accept((ItemLike)this.itemRegistry.getButterflyBannerPattern().get());
        } else if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
            for (DeferredHolder<Item, Item> i : this.itemRegistry.getButterflyEggs()) {
                event.accept((ItemLike)i.get());
            }
            for (DeferredHolder<Item, Item> i : this.itemRegistry.getCaterpillars()) {
                event.accept((ItemLike)i.get());
            }
        } else if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            for (DeferredHolder<Item, Item> i : this.itemRegistry.getButterflySpawnEggs()) {
                event.accept((ItemLike)i.get());
            }
            for (DeferredHolder<Item, Item> i : this.itemRegistry.getCaterpillarSpawnEggs()) {
                event.accept((ItemLike)i.get());
            }
            event.accept((ItemLike)this.itemRegistry.getButterflyGolemSpawnEgg().get());
        } else if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept((ItemLike)this.itemRegistry.getEmptyButterflyNet().get());
            for (DeferredHolder<Item, Item> i : this.itemRegistry.getButterflyNets()) {
                event.accept((ItemLike)i.get());
            }
            event.accept((ItemLike)this.itemRegistry.getBurntButterflyNet().get());
            for (DeferredHolder<Item, Item> i : this.itemRegistry.getBottledButterflies()) {
                event.accept((ItemLike)i.get());
            }
            for (DeferredHolder<Item, Item> i : this.itemRegistry.getBottledCaterpillars()) {
                event.accept((ItemLike)i.get());
            }
            for (DeferredHolder<Item, Item> i : this.itemRegistry.getButterflyScrolls()) {
                event.accept((ItemLike)i.get());
            }
            event.accept((ItemLike)this.itemRegistry.getButterflyBook().get());
            event.accept((ItemLike)this.itemRegistry.getZhuangziBook().get());
        }
    }

    @SubscribeEvent
    private void onRegisterPayloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("butterflies");
        registrar.playToClient(ClientBoundButterflyDataPacket.TYPE_PAYLOAD, ClientBoundButterflyDataPacket.STREAM_CODEC, ClientPayloadHandler::handleButterflyData);
    }
}

