/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.world.inventory.ButterflyFeederMenu;
import com.bokmcdok.butterflies.world.inventory.ButterflyMicroscopeMenu;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class MenuTypeRegistry {
    private final DeferredRegister<MenuType<?>> deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"butterflies");
    private DeferredHolder<MenuType<?>, MenuType<ButterflyFeederMenu>> butterflyFeederMenu;
    private DeferredHolder<MenuType<?>, MenuType<ButterflyMicroscopeMenu>> butterflyMicroscopeMenu;

    public MenuTypeRegistry(IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise() {
        this.butterflyFeederMenu = this.deferredRegister.register("butterfly_feeder", () -> new MenuType(this::createButterflyFeederMenu, FeatureFlags.DEFAULT_FLAGS));
        this.butterflyMicroscopeMenu = this.deferredRegister.register("butterfly_microscope", () -> new MenuType(this::createButterflyMicroscopeMenu, FeatureFlags.DEFAULT_FLAGS));
    }

    public DeferredHolder<MenuType<?>, MenuType<ButterflyFeederMenu>> getButterflyFeederMenu() {
        return this.butterflyFeederMenu;
    }

    public DeferredHolder<MenuType<?>, MenuType<ButterflyMicroscopeMenu>> getButterflyMicroscopeMenu() {
        return this.butterflyMicroscopeMenu;
    }

    private ButterflyFeederMenu createButterflyFeederMenu(int containerId, Inventory playerInventory) {
        return new ButterflyFeederMenu((MenuType)this.butterflyFeederMenu.get(), containerId, playerInventory);
    }

    private ButterflyMicroscopeMenu createButterflyMicroscopeMenu(int containerId, Inventory playerInventory) {
        return new ButterflyMicroscopeMenu((MenuType)this.butterflyMicroscopeMenu.get(), containerId, playerInventory);
    }
}

