/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world;

import com.bokmcdok.butterflies.lang.EnumExtensions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.DataFormatException;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public record ButterflyData(int butterflyIndex, String entityId, Size size, Speed speed, Rarity rarity, Habitat habitat, int eggLifespan, int caterpillarLifespan, int chrysalisLifespan, int butterflyLifespan, ResourceLocation preferredFlower, ButterflyType type, Diurnality diurnality, ExtraLandingBlocks extraLandingBlocks, PlantEffect plantEffect, ResourceLocation breedTarget, EggMultiplier eggMultiplier, boolean caterpillarSounds, boolean butterflySounds) {
    public static int[] LIFESPAN = new int[]{48000, 96000, 168000, Integer.MAX_VALUE};
    private static final Map<String, Integer> ENTITY_ID_TO_INDEX_MAP = new HashMap<String, Integer>();
    private static final Map<Integer, ButterflyData> BUTTERFLY_ENTRIES = new HashMap<Integer, ButterflyData>();
    private static int NUM_BUTTERFLIES;
    private static int NUM_MOTHS;
    public static final StreamCodec<RegistryFriendlyByteBuf, ButterflyData> STREAM_CODEC;

    public ButterflyData(int butterflyIndex, String entityId, Size size, Speed speed, Rarity rarity, Habitat habitat, int eggLifespan, int caterpillarLifespan, int chrysalisLifespan, int butterflyLifespan, ResourceLocation preferredFlower, ButterflyType type, Diurnality diurnality, ExtraLandingBlocks extraLandingBlocks, PlantEffect plantEffect, ResourceLocation breedTarget, EggMultiplier eggMultiplier, boolean caterpillarSounds, boolean butterflySounds) {
        this.butterflyIndex = butterflyIndex;
        this.entityId = entityId;
        this.size = size;
        this.speed = speed;
        this.rarity = rarity;
        this.habitat = habitat;
        this.eggLifespan = eggLifespan;
        this.caterpillarLifespan = caterpillarLifespan * 2;
        this.chrysalisLifespan = chrysalisLifespan;
        this.butterflyLifespan = butterflyLifespan == Integer.MAX_VALUE ? Integer.MAX_VALUE : butterflyLifespan * 2;
        this.preferredFlower = preferredFlower;
        this.type = type;
        this.diurnality = diurnality;
        this.extraLandingBlocks = extraLandingBlocks;
        this.plantEffect = plantEffect;
        this.breedTarget = breedTarget;
        this.eggMultiplier = eggMultiplier;
        this.caterpillarSounds = caterpillarSounds;
        this.butterflySounds = butterflySounds;
    }

    public Lifespan getOverallLifeSpan() {
        if (this.butterflyLifespan == Integer.MAX_VALUE) {
            return Lifespan.IMMORTAL;
        }
        int days = (this.eggLifespan + this.caterpillarLifespan + this.chrysalisLifespan + this.butterflyLifespan) / 24000;
        if (days < 18) {
            return Lifespan.SHORT;
        }
        if (days < 30) {
            return Lifespan.MEDIUM;
        }
        return Lifespan.LONG;
    }

    private static int entityIdToIndex(String entityId) {
        String[] components;
        String species = entityId;
        if (species.contains(":")) {
            String[] splits = species.split(":");
            species = splits[1];
        }
        if (species.contains("domestic_silk")) {
            return ENTITY_ID_TO_INDEX_MAP.get("domestic_silk");
        }
        for (String component : components = species.split("_")) {
            if (!ENTITY_ID_TO_INDEX_MAP.containsKey(component)) continue;
            return ENTITY_ID_TO_INDEX_MAP.get(component);
        }
        return -1;
    }

    public static void addButterfly(ButterflyData entry) throws DataFormatException {
        if (ENTITY_ID_TO_INDEX_MAP.containsKey(entry.entityId)) {
            String message = String.format("Butterfly Data Entry for entity [%s] already exists.", entry.entityId);
            throw new DataFormatException(message);
        }
        if (BUTTERFLY_ENTRIES.containsKey(entry.butterflyIndex)) {
            String message = String.format("Butterfly Data Entry for index [%d] already exists.", entry.butterflyIndex);
            throw new DataFormatException(message);
        }
        ENTITY_ID_TO_INDEX_MAP.put(entry.entityId, entry.butterflyIndex);
        BUTTERFLY_ENTRIES.put(entry.butterflyIndex, entry);
        if (entry.type != ButterflyType.SPECIAL) {
            int total = 0;
            for (ButterflyData i : BUTTERFLY_ENTRIES.values()) {
                if (i.type != entry.type) continue;
                ++total;
            }
            if (entry.type == ButterflyType.BUTTERFLY) {
                NUM_BUTTERFLIES = total;
            } else if (entry.type == ButterflyType.MOTH) {
                NUM_MOTHS = total;
            }
        }
    }

    public static ButterflyData getButterflyDataForEntity(LivingEntity entity) {
        String species = ButterflyData.getSpeciesString(entity);
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)species);
        return ButterflyData.getEntry(location);
    }

    public static String getSpeciesString(LivingEntity entity) {
        String[] split;
        String species = "undiscovered";
        String encodeId = entity.getEncodeId();
        if (encodeId != null && (split = encodeId.split(":")).length >= 2) {
            species = split[1];
            if (species.contains("domestic_silk")) {
                return "domestic_silk";
            }
            split = species.split("_");
            if (split.length >= 2) {
                species = split[0];
            }
        }
        return species;
    }

    public static List<ButterflyData> getButterflyDataList() {
        return BUTTERFLY_ENTRIES.values().stream().toList();
    }

    public static int getButterflyIndex(ResourceLocation location) {
        return ButterflyData.entityIdToIndex(location.toString());
    }

    public static ButterflyData getEntry(int index) {
        if (BUTTERFLY_ENTRIES.containsKey(index)) {
            return BUTTERFLY_ENTRIES.get(index);
        }
        return null;
    }

    public static ButterflyData getEntry(ResourceLocation location) {
        int index = ButterflyData.getButterflyIndex(location);
        return ButterflyData.getEntry(index);
    }

    public static FormattedText getFormattedButterflyData(int butterflyIndex) {
        ButterflyData entry = ButterflyData.getEntry(butterflyIndex);
        if (entry != null) {
            MutableComponent component = Component.translatable((String)("entity.butterflies." + entry.entityId()));
            if (entry.type() == ButterflyType.SPECIAL) {
                component.withStyle(ChatFormatting.DARK_BLUE);
            }
            component.append("\n\n");
            component.append((Component)Component.translatable((String)"gui.butterflies.rarity"));
            switch (entry.rarity().ordinal()) {
                case 2: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.rarity.rare"));
                    break;
                }
                case 1: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.rarity.uncommon"));
                    break;
                }
                case 0: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.rarity.common"));
                    break;
                }
            }
            component.append("\n");
            component.append((Component)Component.translatable((String)"gui.butterflies.size"));
            switch (entry.size().ordinal()) {
                case 0: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.size.tiny"));
                    break;
                }
                case 1: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.size.small"));
                    break;
                }
                case 2: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.size.medium"));
                    break;
                }
                case 3: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.size.large"));
                    break;
                }
                case 4: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.size.huge"));
                    break;
                }
            }
            component.append("\n");
            component.append((Component)Component.translatable((String)"gui.butterflies.speed"));
            switch (entry.speed().ordinal()) {
                case 0: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.speed.moderate"));
                    break;
                }
                case 1: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.speed.fast"));
                    break;
                }
            }
            component.append("\n");
            component.append((Component)Component.translatable((String)"gui.butterflies.lifespan"));
            switch (entry.getOverallLifeSpan().ordinal()) {
                case 0: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.lifespan.short"));
                    break;
                }
                case 1: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.lifespan.average"));
                    break;
                }
                case 2: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.lifespan.long"));
                    break;
                }
                case 3: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.lifespan.immortal"));
                    break;
                }
            }
            component.append("\n");
            component.append((Component)Component.translatable((String)"gui.butterflies.habitat"));
            switch (entry.habitat().ordinal()) {
                case 1: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.habitat.forests"));
                    break;
                }
                case 2: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.habitat.forestsandplains"));
                    break;
                }
                case 4: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.habitat.jungles"));
                    break;
                }
                case 5: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.habitat.plains"));
                    break;
                }
                case 3: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.habitat.ice"));
                    break;
                }
                case 6: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.habitat.nether"));
                    break;
                }
                case 0: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.habitat.none"));
                    break;
                }
                case 7: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.habitat.forestsandwetlands"));
                    break;
                }
                case 8: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.habitat.plainsandsavannas"));
                    break;
                }
                case 9: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.habitat.plainsandwetlands"));
                    break;
                }
                case 10: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.habitat.hillsandplateaus"));
                    break;
                }
                case 11: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.habitat.forestsplainswetlands"));
                    break;
                }
                case 13: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.habitat.wetlands"));
                    break;
                }
                case 12: {
                    component.append((Component)Component.translatable((String)"gui.butterflies.habitat.villages"));
                    break;
                }
            }
            component.append("\n");
            component.append((Component)Component.translatable((String)"gui.butterflies.preferred_flower"));
            Optional preferredFlower = BuiltInRegistries.ITEM.get(entry.preferredFlower());
            if (preferredFlower.isPresent()) {
                Component description = ((Item)((Holder.Reference)preferredFlower.get()).value()).getName();
                component.append(description);
            }
            component.append("\n\n");
            component.append((Component)Component.translatable((String)("gui.butterflies.fact." + entry.entityId())));
            return component;
        }
        return null;
    }

    public static int getNumButterflySpecies() {
        return NUM_BUTTERFLIES;
    }

    public static int getNumMothSpecies() {
        return NUM_MOTHS;
    }

    public static void load(ResourceManager resourceManager) {
        Gson gson = new GsonBuilder().registerTypeAdapter(ButterflyData.class, (Object)new Serializer()).create();
        Map resourceMap = resourceManager.listResources("butterfly_data", x -> x.getPath().endsWith(".json"));
        for (ResourceLocation location : resourceMap.keySet()) {
            try {
                Resource resource = (Resource)resourceMap.get(location);
                BufferedReader reader = resource.openAsReader();
                ButterflyData butterflyData = (ButterflyData)gson.fromJson((Reader)reader, ButterflyData.class);
                ButterflyData.addButterfly(butterflyData);
            }
            catch (IOException | DataFormatException e) {
                LogUtils.getLogger().error("Failed to load butterfly data.", (Throwable)e);
            }
        }
    }

    public static void reset() {
        ENTITY_ID_TO_INDEX_MAP.clear();
        BUTTERFLY_ENTRIES.clear();
        NUM_BUTTERFLIES = 0;
        NUM_MOTHS = 0;
    }

    public ResourceLocation getCaterpillarItem() {
        if (this.entityId != null) {
            return ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)("caterpillar_" + this.entityId));
        }
        return null;
    }

    public ResourceLocation getButterflyEggItem() {
        if (this.entityId != null) {
            return ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)(this.entityId + "_egg"));
        }
        return null;
    }

    public ResourceLocation getButterflyEntity() {
        return ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)this.entityId);
    }

    public ResourceLocation getButterflyEggEntity() {
        return ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)(this.entityId + "_egg"));
    }

    public ResourceLocation getCaterpillarEntity() {
        return ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)(this.entityId + "_caterpillar"));
    }

    public ResourceLocation getChrysalisEntity() {
        return ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)(this.entityId + "_chrysalis"));
    }

    public int getMateButterflyIndex() {
        int mateIndex = ButterflyData.getButterflyIndex(this.breedTarget);
        if (mateIndex < 0) {
            mateIndex = this.butterflyIndex;
        }
        return mateIndex;
    }

    public ResourceLocation getMateButterflyEntity(RandomSource random) {
        ButterflyData entry;
        int mateIndex = this.getMateButterflyIndex();
        if (random.nextInt() % 2 == 0 && (entry = ButterflyData.getEntry(mateIndex)) != null) {
            return entry.getButterflyEntity();
        }
        return this.getButterflyEntity();
    }

    public ResourceLocation getScrollTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)("textures/gui/butterfly_scroll/" + this.entityId + ".png"));
    }

    public float getSizeMultiplier() {
        switch (this.size.ordinal()) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 0.7f;
            }
            case 3: {
                return 1.28f;
            }
            case 4: {
                return 1.5f;
            }
        }
        return 1.0f;
    }

    public boolean isValidLandingBlock(BlockState blockState) {
        if (blockState.is(BlockTags.LEAVES)) {
            return true;
        }
        return switch (this.extraLandingBlocks.ordinal()) {
            case 1 -> blockState.is(Blocks.HAY_BLOCK);
            case 2 -> blockState.is(BlockTags.LOGS);
            case 3 -> blockState.is(BlockTags.WOOL);
            case 4 -> {
                if (blockState.is(Blocks.PUMPKIN) || blockState.is(Blocks.MELON)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    static {
        STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ButterflyData>(){

            @NotNull
            public ButterflyData decode(RegistryFriendlyByteBuf buffer) {
                return new ButterflyData(buffer.readInt(), buffer.readUtf(), (Size)buffer.readEnum(Size.class), (Speed)buffer.readEnum(Speed.class), (Rarity)buffer.readEnum(Rarity.class), (Habitat)buffer.readEnum(Habitat.class), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readResourceLocation(), (ButterflyType)buffer.readEnum(ButterflyType.class), (Diurnality)buffer.readEnum(Diurnality.class), (ExtraLandingBlocks)buffer.readEnum(ExtraLandingBlocks.class), (PlantEffect)buffer.readEnum(PlantEffect.class), buffer.readResourceLocation(), (EggMultiplier)buffer.readEnum(EggMultiplier.class), buffer.readBoolean(), buffer.readBoolean());
            }

            public void encode(RegistryFriendlyByteBuf buffer, ButterflyData data) {
                buffer.writeInt(data.butterflyIndex());
                buffer.writeUtf(data.entityId());
                buffer.writeEnum((Enum)data.size());
                buffer.writeEnum((Enum)data.speed());
                buffer.writeEnum((Enum)data.rarity());
                buffer.writeEnum((Enum)data.habitat());
                buffer.writeInt(data.eggLifespan());
                buffer.writeInt(data.caterpillarLifespan());
                buffer.writeInt(data.chrysalisLifespan());
                buffer.writeInt(data.butterflyLifespan());
                buffer.writeResourceLocation(data.preferredFlower());
                buffer.writeEnum((Enum)data.type());
                buffer.writeEnum((Enum)data.diurnality());
                buffer.writeEnum((Enum)data.extraLandingBlocks());
                buffer.writeEnum((Enum)data.plantEffect());
                buffer.writeResourceLocation(data.breedTarget());
                buffer.writeEnum((Enum)data.eggMultiplier());
                buffer.writeBoolean(data.caterpillarSounds());
                buffer.writeBoolean(data.butterflySounds());
            }
        };
    }

    public static enum Lifespan {
        SHORT(0),
        MEDIUM(1),
        LONG(2),
        IMMORTAL(3);

        private final int value;

        private Lifespan(int value) {
            this.value = value;
        }

        public int getIndex() {
            return this.value;
        }
    }

    public static enum Size {
        TINY,
        SMALL,
        MEDIUM,
        LARGE,
        HUGE;

    }

    public static enum Speed {
        MODERATE,
        FAST;

    }

    public static enum Rarity {
        COMMON,
        UNCOMMON,
        RARE;

    }

    public static enum Habitat {
        NONE,
        FORESTS,
        FORESTS_AND_PLAINS,
        ICE,
        JUNGLES,
        PLAINS,
        NETHER,
        FORESTS_AND_WETLANDS,
        PLAINS_AND_SAVANNAS,
        PLAINS_AND_WETLANDS,
        HILLS_AND_PLATEAUS,
        FORESTS_PLAINS_WETLANDS,
        VILLAGES,
        WETLANDS;

    }

    public static enum ButterflyType {
        BUTTERFLY,
        MOTH,
        SPECIAL;

    }

    public static enum Diurnality {
        DIURNAL,
        NOCTURNAL,
        CREPUSCULAR,
        CATHEMERAL;

    }

    public static enum ExtraLandingBlocks {
        NONE,
        HAY_BALE,
        LOGS,
        WOOL,
        FRUIT;

    }

    public static enum PlantEffect {
        NONE,
        POLLINATE,
        CONSUME;

    }

    public static enum EggMultiplier {
        NONE,
        NORMAL,
        DOUBLE;

    }

    public static class Serializer
    implements JsonDeserializer<ButterflyData> {
        public ButterflyData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws IllegalArgumentException {
            ButterflyData entry = null;
            if (json instanceof JsonObject) {
                JsonObject object = (JsonObject)json;
                int index = object.get("index").getAsInt();
                String entityId = object.get("entityId").getAsString();
                Size size = Serializer.getEnumValue(object, Size.class, "size", Size.MEDIUM);
                Speed speed = Serializer.getEnumValue(object, Speed.class, "speed", Speed.MODERATE);
                Rarity rarity = Serializer.getEnumValue(object, Rarity.class, "rarity", Rarity.COMMON);
                Habitat habitat = Serializer.getEnumValue(object, Habitat.class, "habitat", Habitat.PLAINS);
                JsonObject lifespan = object.get("lifespan").getAsJsonObject();
                Lifespan eggLifespan = Serializer.getEnumValue(lifespan, Lifespan.class, "egg", Lifespan.MEDIUM);
                Lifespan caterpillarLifespan = Serializer.getEnumValue(lifespan, Lifespan.class, "caterpillar", Lifespan.MEDIUM);
                Lifespan chrysalisLifespan = Serializer.getEnumValue(lifespan, Lifespan.class, "chrysalis", Lifespan.MEDIUM);
                Lifespan butterflyLifespan = Serializer.getEnumValue(lifespan, Lifespan.class, "butterfly", Lifespan.MEDIUM);
                String preferredFlower = object.get("preferredFlower").getAsString();
                ButterflyType type = Serializer.getEnumValue(object, ButterflyType.class, "type", ButterflyType.BUTTERFLY);
                Diurnality diurnality = Serializer.getEnumValue(object, Diurnality.class, "diurnality", Diurnality.DIURNAL);
                ExtraLandingBlocks extraLandingBlocks = Serializer.getEnumValue(object, ExtraLandingBlocks.class, "extraLandingBlocks", ExtraLandingBlocks.NONE);
                PlantEffect plantEffect = Serializer.getEnumValue(object, PlantEffect.class, "plantEffect", PlantEffect.NONE);
                String breedTarget = object.get("breedTarget").getAsString();
                EggMultiplier eggMultiplier = Serializer.getEnumValue(object, EggMultiplier.class, "eggMultiplier", EggMultiplier.NORMAL);
                JsonObject sounds = object.get("sounds").getAsJsonObject();
                boolean caterpillarSounds = sounds.get("caterpillar").getAsBoolean();
                boolean butterflySounds = sounds.get("butterfly").getAsBoolean();
                entry = new ButterflyData(index, entityId, size, speed, rarity, habitat, LIFESPAN[eggLifespan.getIndex()], LIFESPAN[caterpillarLifespan.getIndex()], LIFESPAN[chrysalisLifespan.getIndex()], LIFESPAN[butterflyLifespan.getIndex()], ResourceLocation.withDefaultNamespace((String)preferredFlower), type, diurnality, extraLandingBlocks, plantEffect, ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)breedTarget), eggMultiplier, caterpillarSounds, butterflySounds);
            }
            return entry;
        }

        @NotNull
        private static <T extends Enum<?>> T getEnumValue(JsonObject object, Class<T> enumeration, String key, T fallback) {
            JsonElement element = object.get(key);
            if (element == null) {
                LogUtils.getLogger().error("Element [{}] missing from [{}]", (Object)key, (Object)(object.get("entityId") != null ? object.get("entityId").getAsString() : "unknown"));
                return fallback;
            }
            String value = element.getAsString();
            try {
                return EnumExtensions.searchEnum(enumeration, value);
            }
            catch (IllegalArgumentException e) {
                LogUtils.getLogger().error("Invalid type specified on [{}] for [{}] of type [{}]:[{}]", new Object[]{object.get("entityId") != null ? object.get("entityId").getAsString() : "unknown", key, enumeration, value});
                return fallback;
            }
        }
    }
}

