/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.block;

import com.bokmcdok.butterflies.registries.DataComponentRegistry;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.registries.MenuTypeRegistry;
import com.bokmcdok.butterflies.world.inventory.ButterflyMicroscopeMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ButterflyMicroscopeBlock
extends Block {
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.butterfly_microscope");
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)3.0, (double)2.0, (double)5.0, (double)9.0, (double)5.0), Block.box((double)8.0, (double)5.0, (double)8.0, (double)10.0, (double)16.0, (double)10.0), Block.box((double)3.0, (double)9.0, (double)3.0, (double)4.0, (double)10.0, (double)4.0), Block.box((double)4.0, (double)10.0, (double)4.0, (double)5.0, (double)11.0, (double)5.0), Block.box((double)5.0, (double)11.0, (double)5.0, (double)6.0, (double)12.0, (double)6.0), Block.box((double)6.0, (double)12.0, (double)6.0, (double)7.0, (double)13.0, (double)7.0), Block.box((double)7.0, (double)13.0, (double)7.0, (double)8.0, (double)14.0, (double)8.0)});
    private final DataComponentRegistry dataComponentRegistry;
    private final ItemRegistry itemRegistry;
    private final MenuTypeRegistry menuTypeRegistry;

    public ButterflyMicroscopeBlock(DataComponentRegistry dataComponentRegistry, ItemRegistry itemRegistry, MenuTypeRegistry menuTypeRegistry, BlockBehaviour.Properties properties) {
        super(properties);
        this.dataComponentRegistry = dataComponentRegistry;
        this.itemRegistry = itemRegistry;
        this.menuTypeRegistry = menuTypeRegistry;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        return SHAPE;
    }

    public void onRemove(BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, BlockState newBlockState, boolean unknown) {
        if (!blockState.is(newBlockState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof Container) {
                Containers.dropContents((Level)level, (BlockPos)blockPos, (Container)((Container)blockEntity));
                level.updateNeighbourForOutputSignal(blockPos, (Block)this);
            }
            super.onRemove(blockState, level, blockPos, newBlockState, unknown);
        }
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        return InteractionResult.CONSUME;
    }

    public MenuProvider getMenuProvider(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos) {
        return new SimpleMenuProvider((containerId, inventory, title) -> new ButterflyMicroscopeMenu(this.dataComponentRegistry, this.itemRegistry, (MenuType)this.menuTypeRegistry.getButterflyMicroscopeMenu().get(), containerId, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)blockPos)), CONTAINER_TITLE);
    }
}

