/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event.entity;

import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.entity.animal.Chrysalis;
import com.bokmcdok.butterflies.world.entity.animal.DirectionalCreature;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.RegistryObject;

public class EntityEventListener {
    private final EntityTypeRegistry entityTypeRegistry;

    public EntityEventListener(IEventBus forgeEventBus, IEventBus modEventBus, EntityTypeRegistry entityTypeRegistry) {
        forgeEventBus.register((Object)this);
        forgeEventBus.addListener(this::onEntityJoinLevel);
        modEventBus.register((Object)this);
        modEventBus.addListener(this::onEntityAttributeCreation);
        modEventBus.addListener(this::onSpawnPlacementRegister);
        this.entityTypeRegistry = entityTypeRegistry;
    }

    private static boolean isButterflyAttackableByCat(LivingEntity entity) {
        if (entity instanceof Butterfly) {
            Butterfly butterfly = (Butterfly)entity;
            return !Objects.equals(butterfly.getData().entityId(), "forester");
        }
        return false;
    }

    private void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        for (RegistryObject<EntityType<? extends Butterfly>> registryObject : this.entityTypeRegistry.getButterflies()) {
            event.put((EntityType)registryObject.get(), Butterfly.createAttributes().m_22265_());
        }
        for (RegistryObject registryObject : this.entityTypeRegistry.getCaterpillars()) {
            event.put((EntityType)registryObject.get(), Caterpillar.createAttributes().m_22265_());
        }
        for (RegistryObject registryObject : this.entityTypeRegistry.getChrysalises()) {
            event.put((EntityType)registryObject.get(), Chrysalis.createAttributes().m_22265_());
        }
        for (RegistryObject registryObject : this.entityTypeRegistry.getButterflyEggs()) {
            event.put((EntityType)registryObject.get(), ButterflyEgg.createAttributes().m_22265_());
        }
        event.put((EntityType)this.entityTypeRegistry.getButterflyGolem().get(), IronGolem.m_28883_().m_22265_());
    }

    private void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity = event.getEntity();
        if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            cat.f_21346_.m_25352_(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)cat, Butterfly.class, false, EntityEventListener::isButterflyAttackableByCat));
        }
        if ((entity = event.getEntity()) instanceof Fox) {
            Fox fox = (Fox)entity;
            fox.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)fox, Butterfly.class, false));
        }
        if (event.getEntity() instanceof Ocelot || event.getEntity() instanceof Parrot) {
            mob = (Mob)event.getEntity();
            mob.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal(mob, Butterfly.class, false));
        }
        if (event.getEntity() instanceof Spider || event.getEntity() instanceof Witch || event.getEntity() instanceof Zombie) {
            mob = (Mob)event.getEntity();
            mob.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal(mob, Butterfly.class, false));
        }
        if ((entity = event.getEntity()) instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            wolf.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)wolf, Butterfly.class, false, null));
        }
    }

    private void onSpawnPlacementRegister(SpawnPlacementRegisterEvent event) {
        for (RegistryObject<EntityType<? extends Butterfly>> registryObject : this.entityTypeRegistry.getButterflies()) {
            event.register((EntityType)registryObject.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, Butterfly::checkButterflySpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        }
        for (RegistryObject registryObject : this.entityTypeRegistry.getCaterpillars()) {
            event.register((EntityType)registryObject.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, DirectionalCreature::checkDirectionalSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        }
        for (RegistryObject registryObject : this.entityTypeRegistry.getChrysalises()) {
            event.register((EntityType)registryObject.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, DirectionalCreature::checkDirectionalSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        }
        for (RegistryObject registryObject : this.entityTypeRegistry.getButterflyEggs()) {
            event.register((EntityType)registryObject.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, DirectionalCreature::checkDirectionalSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        }
    }
}

