/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritech.block.custom;

import com.blocklogic.agritech.block.entity.AgritechPlanterBlockEntity;
import com.blocklogic.agritech.block.entity.ModBlockEntities;
import com.blocklogic.agritech.config.AgritechCropConfig;
import com.blocklogic.agritech.screen.custom.AgritechPlanterMenu;
import com.blocklogic.agritech.util.RegistryHelper;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class AgritechPlanterBlock
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.1, (double)15.0, (double)9.0, (double)15.0);
    public static final MapCodec<AgritechPlanterBlock> CODEC = AgritechPlanterBlock.simpleCodec(AgritechPlanterBlock::new);

    public AgritechPlanterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new AgritechPlanterBlockEntity(blockPos, blockState);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof AgritechPlanterBlockEntity) {
            AgritechPlanterBlockEntity agritechPlanterBlock = (AgritechPlanterBlockEntity)blockEntity;
            agritechPlanterBlock.drops();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AgritechPlanterBlockEntity) {
            AgritechPlanterBlockEntity planterBlockEntity = (AgritechPlanterBlockEntity)blockEntity;
            if (player.isCrouching()) {
                if (!level.isClientSide()) {
                    SimpleMenuProvider menuProvider = new SimpleMenuProvider((containerId, playerInventory, playerEntity) -> new AgritechPlanterMenu(containerId, playerInventory, planterBlockEntity), (Component)Component.translatable((String)"container.agritech.planter"));
                    player.openMenu((MenuProvider)menuProvider, pos);
                }
                return ItemInteractionResult.SUCCESS;
            }
            ItemStack heldItem = player.getItemInHand(hand);
            String heldItemId = RegistryHelper.getItemId(heldItem);
            if (AgritechCropConfig.isValidSeed(heldItemId)) {
                if (level.isClientSide()) {
                    return ItemInteractionResult.SUCCESS;
                }
                if (planterBlockEntity.inventory.getStackInSlot(0).isEmpty()) {
                    String soilId;
                    ItemStack soilStack = planterBlockEntity.inventory.getStackInSlot(1);
                    if (!soilStack.isEmpty() && !AgritechCropConfig.isSoilValidForSeed(soilId = RegistryHelper.getItemId(soilStack), heldItemId)) {
                        player.displayClientMessage((Component)Component.translatable((String)"message.agritech.invalid_seed_soil_combination"), true);
                        return ItemInteractionResult.SUCCESS;
                    }
                    ItemStack seedStack = heldItem.copyWithCount(1);
                    planterBlockEntity.inventory.setStackInSlot(0, seedStack);
                    heldItem.shrink(1);
                    level.playSound(null, pos, SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.sendBlockUpdated(pos, state, state, 2);
                    planterBlockEntity.setChanged();
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (AgritechCropConfig.isValidSoil(heldItemId)) {
                if (level.isClientSide()) {
                    return ItemInteractionResult.SUCCESS;
                }
                if (planterBlockEntity.inventory.getStackInSlot(1).isEmpty()) {
                    String seedId;
                    ItemStack seedStack = planterBlockEntity.inventory.getStackInSlot(0);
                    if (!seedStack.isEmpty() && !AgritechCropConfig.isSoilValidForSeed(heldItemId, seedId = RegistryHelper.getItemId(seedStack))) {
                        player.displayClientMessage((Component)Component.translatable((String)"message.agritech.invalid_seed_soil_combination"), true);
                        return ItemInteractionResult.SUCCESS;
                    }
                    ItemStack soilStack = heldItem.copyWithCount(1);
                    planterBlockEntity.inventory.setStackInSlot(1, soilStack);
                    heldItem.shrink(1);
                    level.playSound(null, pos, SoundEvents.GRAVEL_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
                    level.sendBlockUpdated(pos, state, state, 2);
                    planterBlockEntity.setChanged();
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (heldItem.getItem() instanceof BlockItem) {
                ItemStack seedStack = planterBlockEntity.inventory.getStackInSlot(0);
                if (!seedStack.isEmpty() && planterBlockEntity.inventory.getStackInSlot(1).isEmpty()) {
                    String seedId = RegistryHelper.getItemId(seedStack);
                    if (AgritechCropConfig.isValidSoil(heldItemId) && !AgritechCropConfig.isSoilValidForSeed(heldItemId, seedId)) {
                        if (!level.isClientSide()) {
                            player.displayClientMessage((Component)Component.translatable((String)"message.agritech.invalid_seed_soil_combination"), true);
                        }
                        return ItemInteractionResult.SUCCESS;
                    }
                }
            } else if (heldItem.getItem() instanceof HoeItem) {
                Item item;
                ItemStack soilStack = planterBlockEntity.inventory.getStackInSlot(1);
                if (!soilStack.isEmpty() && (item = soilStack.getItem()) instanceof BlockItem) {
                    Block resultBlock;
                    BlockItem blockItem = (BlockItem)item;
                    Block soilBlock = blockItem.getBlock();
                    String soilId2 = RegistryHelper.getBlockId(soilBlock);
                    HashMap<String, String> tillableBlocks = new HashMap<String, String>();
                    tillableBlocks.put("minecraft:dirt", "minecraft:farmland");
                    tillableBlocks.put("minecraft:grass_block", "minecraft:farmland");
                    tillableBlocks.put("minecraft:mycelium", "minecraft:farmland");
                    tillableBlocks.put("minecraft:podzol", "minecraft:farmland");
                    tillableBlocks.put("minecraft:coarse_dirt", "minecraft:farmland");
                    tillableBlocks.put("minecraft:rooted_dirt", "minecraft:farmland");
                    if (ModList.get().isLoaded("farmersdelight")) {
                        tillableBlocks.put("farmersdelight:rich_soil", "farmersdelight:rich_soil_farmland");
                    }
                    if (tillableBlocks.containsKey(soilId2) && (resultBlock = RegistryHelper.getBlock((String)tillableBlocks.get(soilId2))) != null) {
                        ItemStack farmlandStack = new ItemStack((ItemLike)resultBlock);
                        planterBlockEntity.inventory.setStackInSlot(1, farmlandStack);
                        level.playSound(player, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                        if (!player.getAbilities().instabuild) {
                            heldItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                        }
                        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
                    }
                }
            } else {
                String farmlandId;
                Block resultBlock;
                BlockItem blockItem;
                Block soilBlock;
                String soilId;
                Item soilId2;
                ItemStack soilStack;
                HashMap<String, String> essenceToFarmland = new HashMap<String, String>();
                essenceToFarmland.put("mysticalagriculture:inferium_essence", "mysticalagriculture:inferium_farmland");
                essenceToFarmland.put("mysticalagriculture:prudentium_essence", "mysticalagriculture:prudentium_farmland");
                essenceToFarmland.put("mysticalagriculture:tertium_essence", "mysticalagriculture:tertium_farmland");
                essenceToFarmland.put("mysticalagriculture:imperium_essence", "mysticalagriculture:imperium_farmland");
                essenceToFarmland.put("mysticalagriculture:supremium_essence", "mysticalagriculture:supremium_farmland");
                essenceToFarmland.put("mysticalagradditions:insanium_essence", "mysticalagradditions:insanium_farmland");
                if (essenceToFarmland.containsKey(heldItemId) && !(soilStack = planterBlockEntity.inventory.getStackInSlot(1)).isEmpty() && (soilId2 = soilStack.getItem()) instanceof BlockItem && ((soilId = RegistryHelper.getBlockId(soilBlock = (blockItem = (BlockItem)soilId2).getBlock())).equals("minecraft:farmland") || soilId.startsWith("mysticalagriculture:") && soilId.endsWith("_farmland") || soilId.startsWith("mysticalagradditions:") && soilId.endsWith("_farmland")) && (resultBlock = RegistryHelper.getBlock(farmlandId = (String)essenceToFarmland.get(heldItemId))) != null) {
                    if (soilId.equals(farmlandId)) {
                        if (!level.isClientSide()) {
                            player.displayClientMessage((Component)Component.translatable((String)"message.agritech.same_farmland"), true);
                        }
                        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
                    }
                    ItemStack maFarmlandStack = new ItemStack((ItemLike)resultBlock);
                    planterBlockEntity.inventory.setStackInSlot(1, maFarmlandStack);
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    level.playSound(player, pos, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
                }
            }
            if (!level.isClientSide()) {
                SimpleMenuProvider menuProvider = new SimpleMenuProvider((containerId, playerInventory, playerEntity) -> new AgritechPlanterMenu(containerId, playerInventory, planterBlockEntity), (Component)Component.translatable((String)"container.agritech.planter"));
                player.openMenu((MenuProvider)menuProvider, pos);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModBlockEntities.AGRITECH_PLANTER_BLOCK_ENTITY.get() ? (lvl, pos, blockState, blockEntity) -> AgritechPlanterBlockEntity.tick(lvl, pos, blockState, (AgritechPlanterBlockEntity)blockEntity) : null;
    }
}

