/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritech.config;

import com.blocklogic.agritech.config.AgritechCropConfig;
import com.blocklogic.agritech.util.RegistryHelper;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;

public class AgritechOverrideConfig {
    private static final Logger MAIN_LOGGER = LogUtils.getLogger();
    private static org.apache.logging.log4j.Logger ERROR_LOGGER = null;
    private static boolean HAS_LOGGED_ERRORS = false;
    private static Path ERROR_LOG_PATH = null;
    private static final String OVERRIDE_FILE_NAME = "agritech_config_overrides.toml";
    private static final Pattern TABLE_PATTERN = Pattern.compile("\\[(\\w+)\\.([\\w]+)\\]");
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("(\\w+)\\s*=\\s*(.+)");
    private static final Pattern ARRAY_PATTERN = Pattern.compile("\\[\\s*(.*)\\s*\\]");
    private static final Pattern STRING_PATTERN = Pattern.compile("\"([^\"]*)\"");
    private static final Map<String, Integer> cropLineNumbers = new HashMap<String, Integer>();
    private static final Map<String, Integer> soilLineNumbers = new HashMap<String, Integer>();

    private static void setupErrorLogger() {
        ERROR_LOGGER = LogManager.getLogger(AgritechOverrideConfig.class);
    }

    private static synchronized void createLogFileIfNeeded() {
        if (HAS_LOGGED_ERRORS) {
            return;
        }
        try {
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss"));
            String logFileName = "agritech_config_overrides_errors_" + timestamp + ".log";
            ERROR_LOG_PATH = FMLPaths.CONFIGDIR.get().resolve("agritech").resolve("config_logs").resolve(logFileName);
            Files.createDirectories(ERROR_LOG_PATH.getParent(), new FileAttribute[0]);
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = context.getConfiguration();
            LoggerConfig existingLogger = config.getLoggerConfig("AgritechOverrideErrorLogger");
            if (existingLogger != null) {
                existingLogger.getAppenders().forEach((name, appender) -> {
                    existingLogger.removeAppender(name);
                    appender.stop();
                });
                config.removeLogger("AgritechOverrideErrorLogger");
            }
            PatternLayout layout = PatternLayout.newBuilder().withPattern("%d{yyyy-MM-dd HH:mm:ss} [%p] %m%n").build();
            FileAppender appender2 = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName("AgritechOverrideErrorAppender")).withFileName(ERROR_LOG_PATH.toString()).setLayout((Layout)layout)).setConfiguration(config)).build();
            appender2.start();
            config.addAppender((Appender)appender2);
            LoggerConfig loggerConfig = new LoggerConfig("AgritechOverrideErrorLogger", Level.INFO, false);
            loggerConfig.addAppender((Appender)appender2, Level.INFO, null);
            config.addLogger("AgritechOverrideErrorLogger", loggerConfig);
            context.updateLoggers();
            ERROR_LOGGER = LogManager.getLogger((String)"AgritechOverrideErrorLogger");
            MAIN_LOGGER.info("Created override config error log file: {}", (Object)ERROR_LOG_PATH);
            HAS_LOGGED_ERRORS = true;
        }
        catch (Exception e) {
            MAIN_LOGGER.error("Failed to set up dedicated error logger: {}", (Object)e.getMessage());
        }
    }

    private static void logError(String message, Object ... params) {
        AgritechOverrideConfig.createLogFileIfNeeded();
        ERROR_LOGGER.error(message, params);
    }

    private static void logWarning(String message, Object ... params) {
        AgritechOverrideConfig.createLogFileIfNeeded();
        ERROR_LOGGER.warn(message, params);
    }

    public static void loadOverrides(Map<String, AgritechCropConfig.CropInfo> crops, Map<String, AgritechCropConfig.SoilInfo> soils) {
        Path configDir = FMLPaths.CONFIGDIR.get().resolve("agritech");
        Path overridePath = configDir.resolve(OVERRIDE_FILE_NAME);
        AgritechOverrideConfig.setupErrorLogger();
        if (!Files.exists(overridePath, new LinkOption[0])) {
            AgritechOverrideConfig.createDefaultOverrideFile(configDir, overridePath);
        }
        try {
            MAIN_LOGGER.info("Loading crop and soil overrides from {}", (Object)overridePath);
            cropLineNumbers.clear();
            soilLineNumbers.clear();
            Map<String, Map<String, Map<String, Object>>> tables = AgritechOverrideConfig.parseTomlFile(overridePath);
            int cropCount = AgritechOverrideConfig.processCropEntries(tables.getOrDefault("crops", Collections.emptyMap()), crops);
            int soilCount = AgritechOverrideConfig.processSoilEntries(tables.getOrDefault("soils", Collections.emptyMap()), soils);
            MAIN_LOGGER.info("Successfully loaded {} crop overrides and {} soil overrides", (Object)cropCount, (Object)soilCount);
        }
        catch (Exception e) {
            MAIN_LOGGER.error("Failed to load override.toml file: {}", (Object)e.getMessage());
            AgritechOverrideConfig.logError("Failed to load override.toml file: {}", e.getMessage());
            AgritechOverrideConfig.logError("The override file will be ignored, but the mod will continue to function", new Object[0]);
        }
    }

    private static Map<String, Map<String, Map<String, Object>>> parseTomlFile(Path filePath) throws IOException {
        HashMap<String, Map<String, Map<String, Object>>> result = new HashMap<String, Map<String, Map<String, Object>>>();
        String currentSection = null;
        String currentTable = null;
        Map currentSectionMap = null;
        Map currentTableMap = null;
        try (BufferedReader reader = Files.newBufferedReader(filePath);){
            String line;
            StringBuilder multilineValue = null;
            String pendingKey = null;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                Matcher keyValueMatcher;
                ++lineNumber;
                int commentPos = AgritechOverrideConfig.findUnquotedChar(line, '#');
                if (commentPos >= 0) {
                    line = line.substring(0, commentPos);
                }
                if ((line = line.trim()).isEmpty()) continue;
                if (multilineValue != null) {
                    multilineValue.append(line);
                    if (AgritechOverrideConfig.countOccurrences(multilineValue.toString(), '[') != AgritechOverrideConfig.countOccurrences(multilineValue.toString(), ']') || AgritechOverrideConfig.countOccurrences(multilineValue.toString(), '{') != AgritechOverrideConfig.countOccurrences(multilineValue.toString(), '}')) continue;
                    currentTableMap.put(pendingKey, AgritechOverrideConfig.parseValue(multilineValue.toString()));
                    multilineValue = null;
                    pendingKey = null;
                    continue;
                }
                Matcher tableMatcher = TABLE_PATTERN.matcher(line);
                if (tableMatcher.matches()) {
                    currentSection = tableMatcher.group(1);
                    currentTable = tableMatcher.group(2);
                    if ("crops".equals(currentSection)) {
                        cropLineNumbers.put(currentTable, lineNumber);
                    } else if ("soils".equals(currentSection)) {
                        soilLineNumbers.put(currentTable, lineNumber);
                    }
                    currentSectionMap = result.computeIfAbsent(currentSection, k -> new HashMap());
                    currentTableMap = currentSectionMap.computeIfAbsent(currentTable, k -> new HashMap());
                    continue;
                }
                if (currentTableMap == null || !(keyValueMatcher = KEY_VALUE_PATTERN.matcher(line)).matches()) continue;
                String key = keyValueMatcher.group(1);
                String valueStr = keyValueMatcher.group(2).trim();
                if (valueStr.startsWith("[") && !valueStr.endsWith("]") || AgritechOverrideConfig.countOccurrences(valueStr, '[') != AgritechOverrideConfig.countOccurrences(valueStr, ']') || AgritechOverrideConfig.countOccurrences(valueStr, '{') != AgritechOverrideConfig.countOccurrences(valueStr, '}')) {
                    multilineValue = new StringBuilder(valueStr);
                    pendingKey = key;
                    continue;
                }
                Object value = AgritechOverrideConfig.parseValue(valueStr);
                currentTableMap.put(key, value);
            }
        }
        return result;
    }

    private static int findUnquotedChar(String str, char target) {
        boolean inQuotes = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (c != target || inQuotes) continue;
            return i;
        }
        return -1;
    }

    private static int countOccurrences(String str, char target) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != target) continue;
            ++count;
        }
        return count;
    }

    private static Object parseValue(String valueStr) {
        Matcher arrayMatcher;
        if (valueStr.startsWith("[") && valueStr.endsWith("]") && valueStr.contains("{")) {
            int closeBrace;
            int openBrace;
            ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
            String content = valueStr.substring(1, valueStr.length() - 1).trim();
            int startIdx = 0;
            while (startIdx < content.length() && (openBrace = content.indexOf(123, startIdx)) != -1 && (closeBrace = AgritechOverrideConfig.findMatchingCloseBrace(content, openBrace)) != -1) {
                String objectStr = content.substring(openBrace + 1, closeBrace).trim();
                Map<String, Object> objectMap = AgritechOverrideConfig.parseObject(objectStr);
                items.add(objectMap);
                startIdx = closeBrace + 1;
            }
            return items;
        }
        if (valueStr.startsWith("[") && valueStr.endsWith("]") && (arrayMatcher = ARRAY_PATTERN.matcher(valueStr)).matches()) {
            String arrayContent = arrayMatcher.group(1);
            ArrayList<String> items = new ArrayList<String>();
            Matcher stringMatcher = STRING_PATTERN.matcher(arrayContent);
            while (stringMatcher.find()) {
                items.add(stringMatcher.group(1));
            }
            return items;
        }
        if (valueStr.startsWith("\"") && valueStr.endsWith("\"")) {
            return valueStr.substring(1, valueStr.length() - 1);
        }
        try {
            if (valueStr.contains(".")) {
                return Double.parseDouble(valueStr);
            }
            return Integer.parseInt(valueStr);
        }
        catch (NumberFormatException numberFormatException) {
            if (valueStr.equalsIgnoreCase("true")) {
                return true;
            }
            if (valueStr.equalsIgnoreCase("false")) {
                return false;
            }
            return valueStr;
        }
    }

    private static int findMatchingCloseBrace(String content, int openBracePos) {
        int depth = 0;
        for (int i = openBracePos; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '{') {
                ++depth;
                continue;
            }
            if (c != '}' || --depth != 0) continue;
            return i;
        }
        return -1;
    }

    private static Map<String, Object> parseObject(String objectStr) {
        String[] parts;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String part : parts = objectStr.split(",")) {
            Object value;
            String[] keyValue;
            if ((part = part.trim()).isEmpty() || (keyValue = part.split("=", 2)).length != 2) continue;
            String key = keyValue[0].trim();
            String valueStr = keyValue[1].trim();
            if (valueStr.startsWith("\"") && valueStr.endsWith("\"")) {
                value = valueStr.substring(1, valueStr.length() - 1);
            } else if (valueStr.equals("true")) {
                value = true;
            } else if (valueStr.equals("false")) {
                value = false;
            } else {
                try {
                    value = valueStr.contains(".") ? (Number)Double.parseDouble(valueStr) : (Number)Integer.parseInt(valueStr);
                }
                catch (NumberFormatException e) {
                    value = valueStr;
                }
            }
            result.put(key, value);
        }
        return result;
    }

    private static int processCropEntries(Map<String, Map<String, Object>> cropEntries, Map<String, AgritechCropConfig.CropInfo> crops) {
        int count = 0;
        for (Map.Entry<String, Map<String, Object>> entry : cropEntries.entrySet()) {
            Object lineInfo;
            int lineNum;
            String cropName = entry.getKey();
            Map<String, Object> cropConfig = entry.getValue();
            try {
                Object seedObj = cropConfig.get("seed");
                if (seedObj == null) {
                    lineNum = cropLineNumbers.getOrDefault(cropName, -1);
                    lineInfo = lineNum > 0 ? " (line " + lineNum + ")" : "";
                    MAIN_LOGGER.warn("Crop override '{}'{} is missing a seed ID, skipping", (Object)cropName, lineInfo);
                    AgritechOverrideConfig.logWarning("Crop override '{}'{} is missing a seed ID, skipping", cropName, lineInfo);
                    continue;
                }
                String seedId = seedObj.toString();
                Item seedItem = RegistryHelper.getItem(seedId);
                if (seedItem == null) {
                    int lineNum2 = cropLineNumbers.getOrDefault(cropName, -1);
                    Object lineInfo2 = lineNum2 > 0 ? " (line " + lineNum2 + ")" : "";
                    MAIN_LOGGER.warn("Crop override '{}'{} uses non-existent seed item: {}, skipping", new Object[]{cropName, lineInfo2, seedId});
                    AgritechOverrideConfig.logWarning("Crop override '{}'{} uses non-existent seed item: {}, skipping", cropName, lineInfo2, seedId);
                    continue;
                }
                ArrayList<String> validSoils = new ArrayList<String>();
                Object soilsObj = cropConfig.get("soil");
                if (soilsObj instanceof List) {
                    List soilsList = (List)soilsObj;
                    for (Object soilObj : soilsList) {
                        String soilId = soilObj.toString();
                        Block soilBlock = RegistryHelper.getBlock(soilId);
                        if (soilBlock == null) {
                            int lineNum3 = cropLineNumbers.getOrDefault(cropName, -1);
                            Object lineInfo3 = lineNum3 > 0 ? " (line " + lineNum3 + ")" : "";
                            MAIN_LOGGER.warn("Crop override '{}'{} references non-existent soil block: {}, skipping this soil", new Object[]{cropName, lineInfo3, soilId});
                            AgritechOverrideConfig.logWarning("Crop override '{}'{} references non-existent soil block: {}, skipping this soil", cropName, lineInfo3, soilId);
                            continue;
                        }
                        validSoils.add(soilId);
                    }
                }
                if (validSoils.isEmpty()) {
                    int lineNum4 = cropLineNumbers.getOrDefault(cropName, -1);
                    Object lineInfo4 = lineNum4 > 0 ? " (line " + lineNum4 + ")" : "";
                    MAIN_LOGGER.warn("Crop override '{}'{} has no valid soils, skipping", (Object)cropName, lineInfo4);
                    AgritechOverrideConfig.logWarning("Crop override '{}'{} has no valid soils, skipping", cropName, lineInfo4);
                    continue;
                }
                ArrayList<AgritechCropConfig.DropInfo> drops = new ArrayList<AgritechCropConfig.DropInfo>();
                Object dropsObj = cropConfig.get("drops");
                if (dropsObj instanceof List) {
                    List dropsList = (List)dropsObj;
                    int defaultMinCount = 1;
                    int defaultMaxCount = 1;
                    float defaultChance = 1.0f;
                    if (cropConfig.containsKey("min_count") && cropConfig.get("min_count") instanceof Number) {
                        defaultMinCount = ((Number)cropConfig.get("min_count")).intValue();
                    }
                    if (cropConfig.containsKey("max_count") && cropConfig.get("max_count") instanceof Number) {
                        defaultMaxCount = ((Number)cropConfig.get("max_count")).intValue();
                    }
                    if (cropConfig.containsKey("chance") && cropConfig.get("chance") instanceof Number) {
                        defaultChance = ((Number)cropConfig.get("chance")).floatValue();
                    }
                    for (Object dropObj : dropsList) {
                        String dropId;
                        int minCount = defaultMinCount;
                        int maxCount = defaultMaxCount;
                        float chance = defaultChance;
                        if (dropObj instanceof Map) {
                            Map dropMap = (Map)dropObj;
                            Object itemObj = dropMap.get("item");
                            if (itemObj == null) {
                                int lineNum5 = cropLineNumbers.getOrDefault(cropName, -1);
                                Object lineInfo5 = lineNum5 > 0 ? " (line " + lineNum5 + ")" : "";
                                MAIN_LOGGER.warn("Crop override '{}'{} has drop without item ID, skipping", (Object)cropName, lineInfo5);
                                AgritechOverrideConfig.logWarning("Crop override '{}'{} has drop without item ID, skipping", cropName, lineInfo5);
                                continue;
                            }
                            dropId = itemObj.toString();
                            if (dropMap.containsKey("min_count") && dropMap.get("min_count") instanceof Number) {
                                minCount = ((Number)dropMap.get("min_count")).intValue();
                            }
                            if (dropMap.containsKey("max_count") && dropMap.get("max_count") instanceof Number) {
                                maxCount = ((Number)dropMap.get("max_count")).intValue();
                            }
                            if (dropMap.containsKey("chance") && dropMap.get("chance") instanceof Number) {
                                chance = ((Number)dropMap.get("chance")).floatValue();
                            }
                        } else {
                            dropId = dropObj.toString();
                        }
                        Item dropItem = RegistryHelper.getItem(dropId);
                        if (dropItem == null) {
                            int lineNum6 = cropLineNumbers.getOrDefault(cropName, -1);
                            Object lineInfo6 = lineNum6 > 0 ? " (line " + lineNum6 + ")" : "";
                            MAIN_LOGGER.warn("Crop override '{}'{} references non-existent drop item: {}, skipping this drop", new Object[]{cropName, lineInfo6, dropId});
                            AgritechOverrideConfig.logWarning("Crop override '{}'{} references non-existent drop item: {}, skipping this drop", cropName, lineInfo6, dropId);
                            continue;
                        }
                        drops.add(new AgritechCropConfig.DropInfo(dropId, minCount, maxCount, chance));
                    }
                }
                if (drops.isEmpty()) {
                    int lineNum7 = cropLineNumbers.getOrDefault(cropName, -1);
                    Object lineInfo7 = lineNum7 > 0 ? " (line " + lineNum7 + ")" : "";
                    MAIN_LOGGER.warn("Crop override '{}'{} has no valid drops, skipping", (Object)cropName, lineInfo7);
                    AgritechOverrideConfig.logWarning("Crop override '{}'{} has no valid drops, skipping", cropName, lineInfo7);
                    continue;
                }
                AgritechCropConfig.CropInfo cropInfo = new AgritechCropConfig.CropInfo();
                cropInfo.validSoils = validSoils;
                cropInfo.drops = drops;
                crops.put(seedId, cropInfo);
                ++count;
                MAIN_LOGGER.info("Added crop override for '{}' with seed {}", (Object)cropName, (Object)seedId);
            }
            catch (Exception e) {
                lineNum = cropLineNumbers.getOrDefault(cropName, -1);
                lineInfo = lineNum > 0 ? " (line " + lineNum + ")" : "";
                MAIN_LOGGER.error("Error processing crop override '{}'{}: {}", new Object[]{cropName, lineInfo, e.getMessage()});
                AgritechOverrideConfig.logError("Error processing crop override '{}'{}: {}", cropName, lineInfo, e.getMessage());
            }
        }
        return count;
    }

    private static int processSoilEntries(Map<String, Map<String, Object>> soilEntries, Map<String, AgritechCropConfig.SoilInfo> soils) {
        int count = 0;
        for (Map.Entry<String, Map<String, Object>> entry : soilEntries.entrySet()) {
            Object lineInfo;
            int lineNum;
            String soilName = entry.getKey();
            Map<String, Object> soilConfig = entry.getValue();
            try {
                Object blockObj = soilConfig.get("block");
                if (blockObj == null) {
                    lineNum = soilLineNumbers.getOrDefault(soilName, -1);
                    lineInfo = lineNum > 0 ? " (line " + lineNum + ")" : "";
                    MAIN_LOGGER.warn("Soil override '{}'{} is missing a block ID, skipping", (Object)soilName, lineInfo);
                    AgritechOverrideConfig.logWarning("Soil override '{}'{} is missing a block ID, skipping", soilName, lineInfo);
                    continue;
                }
                String soilId = blockObj.toString();
                Block soilBlock = RegistryHelper.getBlock(soilId);
                if (soilBlock == null) {
                    int lineNum2 = soilLineNumbers.getOrDefault(soilName, -1);
                    Object lineInfo2 = lineNum2 > 0 ? " (line " + lineNum2 + ")" : "";
                    MAIN_LOGGER.warn("Soil override '{}'{} uses non-existent block: {}, skipping", new Object[]{soilName, lineInfo2, soilId});
                    AgritechOverrideConfig.logWarning("Soil override '{}'{} uses non-existent block: {}, skipping", soilName, lineInfo2, soilId);
                    continue;
                }
                float growthModifier = 0.5f;
                Object modifierObj = soilConfig.get("growth_modifier");
                if (modifierObj instanceof Number) {
                    growthModifier = ((Number)modifierObj).floatValue();
                }
                AgritechCropConfig.SoilInfo soilInfo = new AgritechCropConfig.SoilInfo(growthModifier);
                soils.put(soilId, soilInfo);
                ++count;
                MAIN_LOGGER.info("Added soil override for '{}' with block {}", (Object)soilName, (Object)soilId);
            }
            catch (Exception e) {
                lineNum = soilLineNumbers.getOrDefault(soilName, -1);
                lineInfo = lineNum > 0 ? " (line " + lineNum + ")" : "";
                MAIN_LOGGER.error("Error processing soil override '{}'{}: {}", new Object[]{soilName, lineInfo, e.getMessage()});
                AgritechOverrideConfig.logError("Error processing soil override '{}'{}: {}", soilName, lineInfo, e.getMessage());
            }
        }
        return count;
    }

    private static void createDefaultOverrideFile(Path configDir, Path overridePath) {
        block9: {
            try {
                if (!Files.exists(configDir, new LinkOption[0])) {
                    Files.createDirectories(configDir, new FileAttribute[0]);
                }
                try (FileWriter writer = new FileWriter(overridePath.toFile());){
                    writer.write(AgritechOverrideConfig.createBasicTemplate());
                }
                MAIN_LOGGER.info("Created default override.toml file with examples at {}", (Object)overridePath);
            }
            catch (IOException e) {
                MAIN_LOGGER.error("Failed to create default override.toml file: {}", (Object)e.getMessage());
                if (!HAS_LOGGED_ERRORS) break block9;
                ERROR_LOGGER.error("Failed to create default override.toml file: {}", (Object)e.getMessage());
            }
        }
    }

    public static void resetErrorFlag() {
        HAS_LOGGED_ERRORS = false;
        ERROR_LOGGER = null;
        ERROR_LOG_PATH = null;
    }

    private static String createBasicTemplate() {
        return "# AgriTech Override Configuration\n# This file allows you to add custom crops and soils without modifying the core configuration.\n# Any entries here will override existing configurations for the same items/blocks. For instance, the growth modififier for minecraft:farmland can be overwritten here.\n\n# How to use:\n# 1. Add [crops.your_crop_name] sections for new crops or to override existing ones\n# 2. Add [soils.your_soil_name] sections for new soils or to override existing ones\n# 3. Save the file and restart your game\n\n# IMPORTANT: Make sure to verify the exact item and block IDs from your mods\n# Incorrect IDs will be skipped with a warning message in the log\n# The mod uses resource location format (e.g., \"minecraft:dirt\" not just \"dirt\")\n# The easiest way to check IDs is with F3+H enabled (shows tooltip IDs) or via JEI/REI\n\n# Example crops:\n\n# [crops.example_wheat]\n# seed = \"examplemod:wheat_seeds\"\n# soil = [\n#   \"minecraft:farmland\",\n#   \"examplemod:rich_soil\"\n# ]\n# # There are two ways to specify drops:\n# # 1. Simple drops with default settings:\n# drops = [\n#   \"examplemod:wheat\",\n#   \"examplemod:wheat_seeds\"\n# ]\n# min_count = 1  # Minimum drop count for all simple drops (default: 1)\n# max_count = 3  # Maximum drop count for all simple drops (default: 1)\n# chance = 0.75  # Drop chance for all simple drops (default: 1.0)\n\n# # 2. Detailed drops with individual settings (use this for multiple drops with different chances):\n# # [crops.example_wheat_advanced]\n# # seed = \"examplemod:wheat_seeds\"\n# # soil = [\"minecraft:farmland\"]\n# # drops = [\n# #   { item = \"examplemod:wheat\", min_count = 1, max_count = 3, chance = 1.0 },\n# #   { item = \"examplemod:wheat_seeds\", min_count = 1, max_count = 2, chance = 0.3 }\n# # ]\n\n# Example soils:\n\n# [soils.example_rich_soil]\n# block = \"examplemod:rich_soil\"\n# growth_modifier = 0.8  # Growth speed multiplier (default: 0.5)\n\n# REAL EXAMPLE - Uncomment to use\n# This example adds support for a mod's herb crop\n\n# [crops.herb_crop]\n# seed = \"herbmod:herb_seeds\"\n# soil = [\n#   \"minecraft:farmland\",\n#   \"minecraft:dirt\",\n#   \"minecraft:clay\"\n# ]\n# drops = [\n#   { item = \"herbmod:herb\", min_count = 1, max_count = 3, chance = 1.0 },\n#   { item = \"herbmod:herb_seeds\", min_count = 1, max_count = 2, chance = 0.3 }\n# ]\n\n# [soils.enriched_soil]\n# block = \"herbmod:enriched_soil\"\n# growth_modifier = 1.25\n";
    }
}

