/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.config.ServerConfig;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.plugins.PluginManager;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class SecretPacket
implements Packet<SecretPacket> {
    public static final class_8710.class_9154<SecretPacket> SECRET = new class_8710.class_9154(new class_2960("voicechat", "secret"));
    private UUID secret;
    private int serverPort;
    private UUID playerUUID;
    private ServerConfig.Codec codec;
    private int mtuSize;
    private double voiceChatDistance;
    private int keepAlive;
    private boolean groupsEnabled;
    private String voiceHost;
    private boolean allowRecording;

    public SecretPacket() {
    }

    public SecretPacket(class_3222 player, UUID secret, int port, ServerConfig serverConfig) {
        this.secret = secret;
        this.serverPort = port;
        this.playerUUID = player.method_5667();
        this.codec = serverConfig.voiceChatCodec.get();
        this.mtuSize = serverConfig.voiceChatMtuSize.get();
        this.voiceChatDistance = serverConfig.voiceChatDistance.get();
        this.keepAlive = serverConfig.keepAlive.get();
        this.groupsEnabled = serverConfig.groupsEnabled.get();
        this.voiceHost = PluginManager.instance().getVoiceHost(serverConfig.voiceHost.get());
        this.allowRecording = serverConfig.allowRecording.get();
    }

    public UUID getSecret() {
        return this.secret;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public ServerConfig.Codec getCodec() {
        return this.codec;
    }

    public int getMtuSize() {
        return this.mtuSize;
    }

    public double getVoiceChatDistance() {
        return this.voiceChatDistance;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public boolean groupsEnabled() {
        return this.groupsEnabled;
    }

    public String getVoiceHost() {
        return this.voiceHost;
    }

    public boolean allowRecording() {
        return this.allowRecording;
    }

    @Override
    public SecretPacket fromBytes(class_2540 buf) {
        this.secret = buf.method_10790();
        this.serverPort = buf.readInt();
        this.playerUUID = buf.method_10790();
        this.codec = ServerConfig.Codec.values()[buf.readByte()];
        this.mtuSize = buf.readInt();
        this.voiceChatDistance = buf.readDouble();
        this.keepAlive = buf.readInt();
        this.groupsEnabled = buf.readBoolean();
        this.voiceHost = buf.method_10800(Short.MAX_VALUE);
        this.allowRecording = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(class_2540 buf) {
        buf.method_10797(this.secret);
        buf.method_53002(this.serverPort);
        buf.method_10797(this.playerUUID);
        buf.method_52997(this.codec.ordinal());
        buf.method_53002(this.mtuSize);
        buf.method_52940(this.voiceChatDistance);
        buf.method_53002(this.keepAlive);
        buf.method_52964(this.groupsEnabled);
        buf.method_10814(this.voiceHost);
        buf.method_52964(this.allowRecording);
    }

    @Override
    public class_8710.class_9154<SecretPacket> method_56479() {
        return SECRET;
    }
}

