/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.toma.configuration.ConfigurationSettings;
import dev.toma.configuration.TestingConfig;
import dev.toma.configuration.config.Config;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.format.ConfigFormats;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import dev.toma.configuration.config.io.ConfigIO;
import dev.toma.configuration.service.ServiceHelper;
import dev.toma.configuration.service.services.Platform;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public final class Configuration {
    public static final String MODID = "configuration";
    @ApiStatus.Internal
    public static final Logger LOGGER = LogManager.getLogger((String)"Configuration");
    @ApiStatus.Internal
    public static final Platform PLATFORM = ServiceHelper.loadService(Platform.class);
    public static final Codec<ConfigHolder<?>> BY_ID_CODEC = Codec.STRING.comapFlatMap(id -> {
        Optional optional = Configuration.getConfig(id);
        return optional.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown config ID '" + id + "'"));
    }, ConfigHolder::getConfigId);

    @ApiStatus.Internal
    public static void setup() {
        if (PLATFORM.isDevelopmentEnvironment()) {
            Configuration.registerConfig(TestingConfig.class, ConfigFormats.YAML);
        }
        ConfigurationSettings.loadSettings();
    }

    public static <CFG> ConfigHolder<CFG> registerConfig(Class<CFG> cfgClass, IConfigFormatHandler formatFactory) {
        String group;
        Config cfg = cfgClass.getAnnotation(Config.class);
        if (cfg == null) {
            throw new IllegalArgumentException("Config class must be annotated with '@Config' annotation");
        }
        String id = cfg.id();
        String filename = cfg.filename();
        if (filename.isEmpty()) {
            filename = id;
        }
        if ((group = cfg.group()).isEmpty()) {
            group = id;
        }
        ConfigHolder<CFG> holder = new ConfigHolder<CFG>(cfgClass, id, filename, group, formatFactory);
        ConfigHolder.registerConfig(holder);
        if (cfgClass.getAnnotation(Config.NoAutoSync.class) == null) {
            ConfigIO.FILE_WATCH_MANAGER.addTrackedConfig(holder);
        }
        return holder;
    }

    public static <CFG> Optional<ConfigHolder<CFG>> getConfig(String id) {
        return ConfigHolder.getConfig(id);
    }
}

