/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.theme;

import dev.toma.configuration.client.theme.adapter.DisplayAdapter;
import dev.toma.configuration.client.theme.adapter.DisplayAdapterManager;
import dev.toma.configuration.client.widget.AbstractThemeWidget;
import dev.toma.configuration.client.widget.ColorWidget;
import dev.toma.configuration.client.widget.EditBoxWidget;
import dev.toma.configuration.client.widget.SliderWidget;
import dev.toma.configuration.client.widget.render.IRenderer;
import dev.toma.configuration.config.adapter.AdapterHolder;
import dev.toma.configuration.config.adapter.TypeMatcher;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

public final class ConfigTheme {
    private final Set<AdapterHolder<DisplayAdapter>> displayAdapters = new HashSet<AdapterHolder<DisplayAdapter>>();
    private Header header;
    private Footer footer;
    private Scrollbar scrollbar;
    private ConfigEntry configEntry;
    private Integer backgroundFillColor;
    private int widgetTextColor;
    private int widgetTextColorHovered;
    private int widgetTextColorDisabled;
    private BackgroundRendererFactory<AbstractThemeWidget> buttonBackground = BackgroundRendererFactory.none();
    private BackgroundRendererFactory<EditBoxWidget> editBoxBackground = BackgroundRendererFactory.none();
    private BackgroundRendererFactory<SliderWidget<?>> sliderBackground = BackgroundRendererFactory.none();
    private BackgroundRendererFactory<SliderWidget<?>> sliderHandle = BackgroundRendererFactory.none();
    private BackgroundRendererFactory<ColorWidget> colorBackground = BackgroundRendererFactory.none();

    public ConfigTheme copy() {
        ConfigTheme theme = new ConfigTheme();
        theme.displayAdapters.addAll(this.displayAdapters);
        theme.header = this.header;
        theme.footer = this.footer;
        theme.scrollbar = this.scrollbar;
        theme.configEntry = this.configEntry;
        theme.backgroundFillColor = this.backgroundFillColor;
        theme.widgetTextColor = this.widgetTextColor;
        theme.widgetTextColorHovered = this.widgetTextColorHovered;
        theme.widgetTextColorDisabled = this.widgetTextColorDisabled;
        theme.buttonBackground = this.buttonBackground;
        theme.editBoxBackground = this.editBoxBackground;
        theme.sliderBackground = this.sliderBackground;
        theme.sliderHandle = this.sliderHandle;
        theme.colorBackground = this.colorBackground;
        return theme;
    }

    public DisplayAdapter getAdapter(Class<?> type) {
        Class<?> mappedType = DisplayAdapterManager.mapType(type);
        return this.displayAdapters.stream().filter(holder -> holder.test(mappedType)).sorted().findFirst().map(AdapterHolder::adapter).orElse(null);
    }

    public void registerDisplayAdapter(TypeMatcher matcher, DisplayAdapter adapter) {
        AdapterHolder<DisplayAdapter> adapterHolder = new AdapterHolder<DisplayAdapter>(matcher, adapter);
        this.displayAdapters.remove(adapterHolder);
        this.displayAdapters.add(adapterHolder);
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public void setFooter(Footer footer) {
        this.footer = footer;
    }

    public void setScrollbar(Scrollbar scrollbar) {
        this.scrollbar = scrollbar;
    }

    public void setConfigEntry(ConfigEntry configEntry) {
        this.configEntry = configEntry;
    }

    public void setBackgroundFillColor(Integer backgroundFillColor) {
        this.backgroundFillColor = backgroundFillColor;
    }

    public void setWidgetTextColor(int widgetTextColor, int widgetTextColorHovered, int widgetTextColorDisabled) {
        this.widgetTextColor = widgetTextColor;
        this.widgetTextColorHovered = widgetTextColorHovered;
        this.widgetTextColorDisabled = widgetTextColorDisabled;
    }

    public void setButtonBackground(BackgroundRendererFactory<AbstractThemeWidget> buttonBackground) {
        this.buttonBackground = buttonBackground;
    }

    public void setEditBoxBackground(BackgroundRendererFactory<EditBoxWidget> editBoxBackground) {
        this.editBoxBackground = editBoxBackground;
    }

    public void setSliderBackground(BackgroundRendererFactory<SliderWidget<?>> sliderBackground) {
        this.sliderBackground = sliderBackground;
    }

    public void setSliderHandle(BackgroundRendererFactory<SliderWidget<?>> sliderHandle) {
        this.sliderHandle = sliderHandle;
    }

    public void setColorBackground(BackgroundRendererFactory<ColorWidget> colorBackground) {
        this.colorBackground = colorBackground;
    }

    public Header getHeader() {
        return this.header;
    }

    public Footer getFooter() {
        return this.footer;
    }

    public Scrollbar getScrollbar() {
        return this.scrollbar;
    }

    public ConfigEntry getConfigEntry() {
        return this.configEntry;
    }

    public Integer getBackgroundFillColor() {
        return this.backgroundFillColor;
    }

    public int getWidgetTextColor(boolean active, boolean hovered) {
        return active ? (hovered ? this.widgetTextColorHovered : this.widgetTextColor) : this.widgetTextColorDisabled;
    }

    public IRenderer getButtonBackground(AbstractThemeWidget widget) {
        return this.buttonBackground.create(widget);
    }

    public IRenderer getEditBoxBackground(EditBoxWidget widget) {
        return this.editBoxBackground.create(widget);
    }

    public IRenderer getSliderBackground(SliderWidget<?> widget) {
        return this.sliderBackground.create(widget);
    }

    public IRenderer getSliderHandle(SliderWidget<?> widget) {
        return this.sliderHandle.create(widget);
    }

    public IRenderer getColorBackground(ColorWidget widget) {
        return this.colorBackground.create(widget);
    }

    @FunctionalInterface
    public static interface BackgroundRendererFactory<T> {
        public IRenderer create(T var1);

        public static <T> BackgroundRendererFactory<T> none() {
            return t -> null;
        }
    }

    public record Header(class_2561 customText, int backgroundColor, int foregroundColor) {
    }

    public record Footer(int backgroundColor) {
    }

    public record Scrollbar(int width, Integer backgroundColor) {
    }

    public record ConfigEntry(int color, UnaryOperator<class_2583> modifiedValueStyle, Integer hoveredColorBackground) {
    }
}

