/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.validate;

import dev.toma.configuration.config.validate.IValidationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5244;

public class AggregatedValidationResult
implements IValidationResult {
    public static final class_2561 CHILD_VALUE_WARNING = class_2561.method_43471((String)"text.configuration.validation.child_failed.warning");
    public static final class_2561 CHILD_VALUE_ERROR = class_2561.method_43471((String)"text.configuration.validation.child_failed.error");
    private final IValidationResult.Severity severity;
    private final List<class_2561> messages;

    private AggregatedValidationResult(IValidationResult.Severity severity, List<class_2561> messages) {
        this.severity = severity;
        this.messages = Collections.unmodifiableList(messages);
    }

    public static AggregatedValidationResult joinChild(AggregatedValidationResult r1, AggregatedValidationResult r2) {
        IValidationResult.Severity result;
        ArrayList<class_2561> messages = new ArrayList<class_2561>();
        IValidationResult.Severity s1 = r1 != null ? r1.severity() : IValidationResult.Severity.NONE;
        IValidationResult.Severity s2 = r2 != null ? r2.severity() : IValidationResult.Severity.NONE;
        IValidationResult.Severity severity = result = s1.isHigherSeverityThan(s2) ? s1 : s2;
        if (result == IValidationResult.Severity.NONE) {
            return new AggregatedValidationResult(IValidationResult.Severity.NONE, Collections.emptyList());
        }
        if (r1 != null) {
            messages.addAll(r1.messages);
        }
        if (r2 != null && s2.isWarningOrError()) {
            messages.add(class_5244.field_39003);
            messages.add(s2 == IValidationResult.Severity.WARNING ? CHILD_VALUE_WARNING : CHILD_VALUE_ERROR);
        }
        return new AggregatedValidationResult(result, messages);
    }

    public static AggregatedValidationResult aggregate(List<IValidationResult> results) {
        IValidationResult.Severity severity = IValidationResult.Severity.NONE;
        ArrayList<class_2561> messages = new ArrayList<class_2561>();
        if (!results.isEmpty()) {
            for (IValidationResult result : results) {
                List<class_2561> resultMessages = result.messages().stream().filter(c -> c != null && !c.equals((Object)class_5244.field_39003)).toList();
                IValidationResult.Severity resultSeverity = result.severity();
                if (!resultSeverity.isHigherSeverityThan(severity)) continue;
                messages.addAll(resultMessages);
                messages.add(class_5244.field_39003);
                severity = resultSeverity;
            }
        }
        return new AggregatedValidationResult(severity, messages);
    }

    public boolean isValid() {
        return this.severity.isValid();
    }

    @Override
    public IValidationResult.Severity severity() {
        return this.severity;
    }

    @Override
    public List<class_2561> messages() {
        return this.messages;
    }
}

