/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.validate.NumberRange;
import dev.toma.configuration.config.value.AbstractArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.NumericArrayValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import net.minecraft.class_2540;

public class ByteArrayValue
extends NumericArrayValue<Byte> {
    public ByteArrayValue(ValueData<Byte[]> valueData) {
        super(valueData, (byte)-128, (byte)127);
    }

    @Override
    public NumberRange<Byte> getValueRange(Field field) {
        Configurable.Range range = field.getAnnotation(Configurable.Range.class);
        return range != null ? NumberRange.interval(this, (byte)Math.max(range.min(), (long)((Byte)this.min()).byteValue()), (byte)Math.min(range.max(), (long)((Byte)this.max()).byteValue())) : NumberRange.all(this);
    }

    @Override
    public Byte createElementInstance() {
        return (byte)0;
    }

    @Override
    public void serialize(IConfigFormat format) {
        format.writeByteArray(this.getId(), (Byte[])this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readByteArray(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter<Byte[]> {
        @Override
        public void encodeToBuffer(ConfigValue<Byte[]> value, class_2540 buffer) {
            AbstractArrayValue.saveToBuffer((Byte[])value.get(), buffer, (buf, aByte) -> buf.method_52997((int)aByte.byteValue()));
        }

        @Override
        public Byte[] decodeFromBuffer(ConfigValue<Byte[]> value, class_2540 buffer) {
            return AbstractArrayValue.readFromBuffer(buffer, Byte[]::new, class_2540::readByte);
        }

        @Override
        public ConfigValue<Byte[]> serialize(TypeAdapter.TypeAttributes<Byte[]> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new ByteArrayValue(ValueData.of(attributes));
        }
    }
}

