/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.value.AbstractArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.ValueData;
import net.minecraft.class_2540;

public class CharArrayValue
extends AbstractArrayValue<Character> {
    public CharArrayValue(ValueData<Character[]> value) {
        super((ValueData<T[]>)value);
    }

    @Override
    public Character createElementInstance() {
        return Character.valueOf('a');
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeCharArray(this.getId(), (Character[])this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readCharArray(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter<Character[]> {
        @Override
        public ConfigValue<Character[]> serialize(TypeAdapter.TypeAttributes<Character[]> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new CharArrayValue(ValueData.of(attributes));
        }

        @Override
        public void encodeToBuffer(ConfigValue<Character[]> value, class_2540 buffer) {
            Character[] chars = (Character[])value.get();
            buffer.method_53002(chars.length);
            for (Character c : chars) {
                buffer.method_53004((int)c.charValue());
            }
        }

        @Override
        public Character[] decodeFromBuffer(ConfigValue<Character[]> value, class_2540 buffer) {
            Character[] characters = new Character[buffer.readInt()];
            for (int i = 0; i < characters.length; ++i) {
                characters[i] = Character.valueOf(buffer.readChar());
            }
            return characters;
        }
    }
}

