/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.validate.NumberRange;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.NumericValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import net.minecraft.class_2540;

public class DoubleValue
extends NumericValue<Double> {
    public DoubleValue(ValueData<Double> valueData) {
        super(valueData, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    @Override
    protected NumberRange<Double> getValueRange(Field field, Double min, Double max) {
        Configurable.DecimalRange range = field.getAnnotation(Configurable.DecimalRange.class);
        return range != null ? NumberRange.interval(this, range.min(), range.max()) : NumberRange.all(this);
    }

    @Override
    public Double getValueFromSlider(double sliderValue) {
        NumberRange range = this.getRange();
        double delta = (Double)range.max() - (Double)range.min();
        return (Double)range.min() + delta * sliderValue;
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeDouble(this.getId(), (Double)this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readDouble(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter<Double> {
        @Override
        public ConfigValue<Double> serialize(TypeAdapter.TypeAttributes<Double> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new DoubleValue(ValueData.of(attributes));
        }

        @Override
        public void encodeToBuffer(ConfigValue<Double> value, class_2540 buffer) {
            buffer.method_52940(((Double)value.get()).doubleValue());
        }

        @Override
        public Double decodeFromBuffer(ConfigValue<Double> value, class_2540 buffer) {
            return buffer.readDouble();
        }

        @Override
        public void setFieldValue(Field field, Object instance, Object value) throws IllegalAccessException {
            field.setDouble(instance, (Double)value);
        }
    }
}

