/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.validate.NumberRange;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.NumericValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import net.minecraft.class_2540;

public class ShortValue
extends NumericValue<Short> {
    public ShortValue(ValueData<Short> data) {
        super(data, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
    }

    @Override
    protected NumberRange<Short> getValueRange(Field field, Short min, Short max) {
        Configurable.Range range = field.getAnnotation(Configurable.Range.class);
        return range != null ? NumberRange.interval(this, (short)Math.max(range.min(), (long)min.shortValue()), (short)Math.min(range.max(), (long)max.shortValue())) : NumberRange.all(this);
    }

    @Override
    public Short getValueFromSlider(double sliderValue) {
        NumberRange range = this.getRange();
        int delta = (Short)range.max() - (Short)range.min();
        return (short)((Short)range.min() + (short)((double)delta * sliderValue));
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeShort(this.getId(), (Short)this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readShort(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter<Short> {
        @Override
        public ConfigValue<Short> serialize(TypeAdapter.TypeAttributes<Short> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new ShortValue(ValueData.of(attributes));
        }

        @Override
        public void encodeToBuffer(ConfigValue<Short> value, class_2540 buffer) {
            buffer.method_52997((int)((Short)value.get()).shortValue());
        }

        @Override
        public Short decodeFromBuffer(ConfigValue<Short> value, class_2540 buffer) {
            return buffer.readShort();
        }

        @Override
        public void setFieldValue(Field field, Object instance, Object value) throws IllegalAccessException {
            field.setShort(instance, (Short)value);
        }
    }
}

