/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.network.message;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.value.ConfigValue;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record S2C_SendConfigDataMessage(String config, Map<String, NetworkConfigValue<?>> values) implements class_8710
{
    public static final class_2960 IDENTIFIER = class_2960.method_60655((String)"configuration", (String)"send_config_data");
    public static final class_8710.class_9154<S2C_SendConfigDataMessage> TYPE = new class_8710.class_9154(IDENTIFIER);
    public static final class_9139<class_2540, S2C_SendConfigDataMessage> CODEC = class_9139.method_56437((o, s2CSendConfigDataMessage) -> s2CSendConfigDataMessage.encode((class_2540)o), S2C_SendConfigDataMessage::decode);

    public S2C_SendConfigDataMessage(String config) {
        this(config, null);
    }

    private static Map<String, ConfigValue<?>> loadValuesForSynchronization(String config) {
        ConfigHolder holder = ConfigHolder.getConfig(config).orElseThrow(() -> new IllegalArgumentException("Unknown config: " + config));
        return holder.getNetworkSerializedFields();
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    private void encode(class_2540 buffer) {
        Map<String, ConfigValue<?>> synchronizedFields = S2C_SendConfigDataMessage.loadValuesForSynchronization(this.config);
        buffer.method_10814(this.config);
        buffer.method_53002(synchronizedFields.size());
        for (Map.Entry<String, ConfigValue<?>> entry : synchronizedFields.entrySet()) {
            String field = entry.getKey();
            ConfigValue<?> value = entry.getValue();
            buffer.method_10814(field);
            this.encodeToBuffer(value, buffer);
        }
    }

    private <T> void encodeToBuffer(ConfigValue<T> value, class_2540 buffer) {
        TypeAdapter<T> adapter = value.getAdapter();
        adapter.encodeToBuffer(value, buffer);
    }

    private static S2C_SendConfigDataMessage decode(class_2540 buffer) {
        Map<String, ConfigValue<?>> synchronizedFields;
        String config = buffer.method_19772();
        int valuesCount = buffer.readInt();
        if (valuesCount != (synchronizedFields = S2C_SendConfigDataMessage.loadValuesForSynchronization(config)).size()) {
            throw new IllegalArgumentException("Number of synchronization fields did not match for config " + config);
        }
        LinkedHashMap values = new LinkedHashMap();
        for (int i = 0; i < valuesCount; ++i) {
            String field = buffer.method_19772();
            ConfigValue<?> configValue = synchronizedFields.get(field);
            if (configValue == null) {
                Configuration.LOGGER.fatal("Received unknown config value {}", (Object)field);
                throw new RuntimeException("Unknown config field: " + field);
            }
            S2C_SendConfigDataMessage.saveValue(values, configValue, field, buffer);
        }
        return new S2C_SendConfigDataMessage(config, values);
    }

    private static <T> void saveValue(Map<String, NetworkConfigValue<?>> map, ConfigValue<T> value, String field, class_2540 buffer) {
        TypeAdapter<T> adapter = value.getAdapter();
        T t = adapter.decodeFromBuffer(value, buffer);
        map.put(field, new NetworkConfigValue<T>(value, t));
    }

    public void receive() {
        for (Map.Entry<String, NetworkConfigValue<?>> entry : this.values.entrySet()) {
            NetworkConfigValue<?> value = entry.getValue();
            value.bind();
        }
    }

    private record NetworkConfigValue<T>(ConfigValue<T> configValue, T value) {
        void bind() {
            this.configValue.setFromNetwork(this.value);
        }
    }
}

