/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_9331;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumLocatorResult;
import team.tnt.collectorsalbum.common.init.ItemDataComponentRegistry;
import team.tnt.collectorsalbum.common.init.RegistryTags;
import team.tnt.collectorsalbum.integrations.PlatformIntegrations;

public final class PlayerAlbumTracker {
    private static final PlayerAlbumTracker INSTANCE = new PlayerAlbumTracker();
    private final Map<UUID, Album> playerAlbums = new HashMap<UUID, Album>();

    private PlayerAlbumTracker() {
    }

    public static PlayerAlbumTracker get() {
        return INSTANCE;
    }

    public AlbumLocatorResult findAlbum(class_1657 player, Album previousAlbum) {
        AlbumLocatorResult integrationResult = PlatformIntegrations.getAlbumLocatorResult(player, previousAlbum);
        if (integrationResult.exists()) {
            return integrationResult;
        }
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960() || !itemStack.method_31573(RegistryTags.Items.ALBUM)) continue;
            Album album = (Album)itemStack.method_57824((class_9331)ItemDataComponentRegistry.ALBUM.get());
            if (previousAlbum != null && previousAlbum.test(album)) {
                return AlbumLocatorResult.found(itemStack, previousAlbum, i);
            }
            return AlbumLocatorResult.found(itemStack, album, i);
        }
        return AlbumLocatorResult.notFound();
    }

    public Optional<Album> getAlbum(class_1657 player) {
        return this.getAlbum(player.method_5667());
    }

    public Optional<Album> getAlbum(UUID playerUuid) {
        return Optional.ofNullable(this.playerAlbums.get(playerUuid));
    }

    public void cacheAlbum(class_1657 player, Album album) {
        this.cacheAlbum(player.method_5667(), album);
    }

    public void cacheAlbum(UUID playerUuid, Album album) {
        this.playerAlbums.put(playerUuid, Objects.requireNonNull(album));
    }

    public void deleteCachedAlbum(UUID playerUuid) {
        this.playerAlbums.remove(playerUuid);
    }

    public void clearCache() {
        this.playerAlbums.clear();
    }
}

