/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.menu;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_9331;
import team.tnt.collectorsalbum.CollectorsAlbum;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.AlbumCategoryUiTemplate;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.init.ItemDataComponentRegistry;
import team.tnt.collectorsalbum.common.init.MenuRegistry;
import team.tnt.collectorsalbum.common.menu.AlbumRestrictedSlot;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;

public class AlbumCategoryMenu
extends class_1703 {
    private class_2960 category;
    private final Int2IntMap cardNumberToSlotCache = new Int2IntOpenHashMap();

    public AlbumCategoryMenu(int menuId, class_1661 inventory) {
        super((class_3917)MenuRegistry.ALBUM_CATEGORY.get(), menuId);
    }

    public AlbumCategoryMenu(int menuId, class_1661 playerInventory, class_2960 category) {
        this(menuId, playerInventory);
        this.category = category;
        class_1799 itemStack = playerInventory.field_7546.method_6047();
        Album album = (Album)itemStack.method_57824((class_9331)ItemDataComponentRegistry.ALBUM.get());
        if (album == null) {
            return;
        }
        AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
        AlbumCategory albumCategory = manager.findById(category).orElse(null);
        if (albumCategory != null) {
            int x;
            int y;
            AlbumCategoryUiTemplate template = albumCategory.visualTemplate();
            AlbumCategoryUiTemplate.SlotPositionTemplate slotTemplate = template.slotTemplate;
            int xStart = slotTemplate.xAlbumSlotPositionStart();
            int yStart = slotTemplate.yAlbumSlotPositionStart();
            int xSpacing = slotTemplate.xSlotSpacing();
            int ySpacing = slotTemplate.ySlotSpacing();
            int pageWidth = slotTemplate.pageWidth();
            int[] cardNumbers = albumCategory.getCardNumbers();
            int slotsPerPage = slotTemplate.columns() * slotTemplate.rows();
            AlbumInventoryWrapper wrapper = new AlbumInventoryWrapper(cardNumbers.length, itemStack, category, album);
            block0: for (int y2 = 0; y2 < slotTemplate.rows(); ++y2) {
                for (int x2 = 0; x2 < slotTemplate.columns(); ++x2) {
                    int cardX = xStart + x2 * xSpacing;
                    int cardY = yStart + y2 * ySpacing;
                    int cardIndex = x2 + y2 * slotTemplate.columns();
                    if (cardIndex >= cardNumbers.length) continue block0;
                    this.method_7621(new CardSlot((class_1263)wrapper, cardIndex, cardX, cardY, category, cardNumbers[cardIndex]));
                    this.cardNumberToSlotCache.put(cardNumbers[cardIndex], cardIndex);
                }
            }
            if (cardNumbers.length >= slotsPerPage) {
                int cardsLength = slotTemplate.columns() * xSpacing - xSpacing;
                int rightStartX = pageWidth * 2 - 18 - cardsLength - xStart + 2;
                block2: for (y = 0; y < slotTemplate.rows(); ++y) {
                    for (x = 0; x < slotTemplate.columns(); ++x) {
                        int cardX = rightStartX + x * xSpacing;
                        int cardY = yStart + y * ySpacing;
                        int cardIndex = slotsPerPage + x + y * slotTemplate.columns();
                        if (cardIndex >= cardNumbers.length) continue block2;
                        this.method_7621(new CardSlot((class_1263)wrapper, cardIndex, cardX, cardY, category, cardNumbers[cardIndex]));
                        this.cardNumberToSlotCache.put(cardNumbers[cardIndex], cardIndex);
                    }
                }
            }
            int playerX = slotTemplate.xPlayerSlotPositionStart();
            int playerY = slotTemplate.yPlayerSlotPositionStart();
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.method_7621(new AlbumRestrictedSlot((class_1263)playerInventory, 9 + x + y * 9, playerX + 1 + x * 18, playerY + 1 + y * 18));
                }
            }
            for (int x3 = 0; x3 < 9; ++x3) {
                this.method_7621(new AlbumRestrictedSlot((class_1263)playerInventory, x3, playerX + 1 + x3 * 18, playerY + 59));
            }
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        CollectorsAlbum.forceAlbumReload(player);
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 slotItem = slot.method_7677();
            itemStack = slotItem.method_7972();
            AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
            int slotsCount = manager.findById(this.category).map(cat -> cat.getCardNumbers().length).orElse(0);
            if (slotsCount == 0) {
                return this.transferInInventory(slotItem, index, 0);
            }
            if (index >= 0 && index < slotsCount) {
                slot.method_7668();
                if (!this.method_7616(slotItem, slotsCount, slotsCount + 36, true)) {
                    return class_1799.field_8037;
                }
            } else if (index >= slotsCount && index < slotsCount + 36) {
                AlbumCard albumCard = this.getCardInfo(slotItem);
                if (albumCard == null || !albumCard.category().equals((Object)this.category)) {
                    return this.transferInInventory(slotItem, index, slotsCount);
                }
                int cardNumber = albumCard.cardNumber();
                if (!this.cardNumberToSlotCache.containsKey(cardNumber)) {
                    return this.transferInInventory(slotItem, index, slotsCount);
                }
                int cardSlot = this.cardNumberToSlotCache.get(cardNumber);
                class_1735 targetSlot = (class_1735)this.field_7761.get(cardSlot);
                if (slotItem.method_7947() > 1) {
                    if (!targetSlot.method_7681()) {
                        itemStack = slotItem.method_7972();
                        itemStack.method_7939(1);
                        targetSlot.method_7673(itemStack);
                        slotItem.method_7934(1);
                        return slotItem;
                    }
                    return class_1799.field_8037;
                }
                AlbumCard replacement = null;
                if (targetSlot.method_7681()) {
                    class_1799 inSlot = targetSlot.method_7677();
                    replacement = this.getCardInfo(inSlot);
                }
                if (replacement == null || albumCard.compareTo(replacement) > 0) {
                    itemStack = targetSlot.method_7677().method_7972();
                    targetSlot.method_7673(slotItem);
                    slot.method_7673(itemStack.method_7972());
                }
            }
        }
        return class_1799.field_8037;
    }

    public AlbumCategory getCategory() {
        if (this.category == null) {
            throw new IllegalStateException("Category is not defined");
        }
        AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
        return manager.findById(this.category).orElseThrow();
    }

    private class_1799 transferInInventory(class_1799 itemStack, int index, int cards) {
        if (index >= cards && index < cards + 27 ? !this.method_7616(itemStack, cards + 27, cards + 36, false) : index >= cards + 27 && index < cards + 36 && !this.method_7616(itemStack, cards, cards + 9, false)) {
            return class_1799.field_8037;
        }
        return itemStack;
    }

    private AlbumCard getCardInfo(class_1799 itemStack) {
        return AlbumCardManager.getInstance().getCardInfo(itemStack.method_7909()).orElse(null);
    }

    private static final class AlbumInventoryWrapper
    extends class_1277 {
        private final class_1799 itemStack;
        private final class_2960 category;

        AlbumInventoryWrapper(int size, class_1799 itemStack, class_2960 category, Album album) {
            super(size);
            this.itemStack = itemStack;
            this.category = category;
            class_2371<class_1799> itemStacks = album.getInventory(category);
            for (int i = 0; i < itemStacks.size(); ++i) {
                class_1799 stack = (class_1799)itemStacks.get(i);
                if (stack.method_7960()) continue;
                this.method_54454().set(i, (Object)stack.method_7972());
            }
        }

        public void method_5447(int index, class_1799 itemStack) {
            Album album = (Album)this.itemStack.method_57824((class_9331)ItemDataComponentRegistry.ALBUM.get());
            if (album != null) {
                Album.Mutable mutable = new Album.Mutable(album);
                mutable.set(this.category, index, itemStack.method_7972());
                Album updated = mutable.toImmutable();
                this.itemStack.method_57379((class_9331)ItemDataComponentRegistry.ALBUM.get(), (Object)updated);
            }
            super.method_5447(index, itemStack);
        }
    }

    private static final class CardSlot
    extends class_1735 {
        private final class_2960 category;
        private final int cardNumber;

        public CardSlot(class_1263 container, int index, int slotX, int slotY, class_2960 category, int number) {
            super(container, index, slotX, slotY);
            this.category = category;
            this.cardNumber = number;
        }

        public boolean method_7680(class_1799 itemStack) {
            AlbumCardManager manager = AlbumCardManager.getInstance();
            return manager.getCardInfo(itemStack.method_7909()).map(info -> {
                class_2960 cardCategory = info.category();
                int cardNumber = info.cardNumber();
                return cardNumber == this.cardNumber && cardCategory.equals((Object)this.category);
            }).orElse(false);
        }

        public int method_7675() {
            return 1;
        }

        public int method_7676(class_1799 $$0) {
            return this.method_7675();
        }
    }
}

