/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.AlbumCardType;
import team.tnt.collectorsalbum.platform.resource.PlatformGsonCodecReloadListener;

public class AlbumCardManager
extends PlatformGsonCodecReloadListener<AlbumCard> {
    private static final class_2960 IDENTIFIER = class_2960.method_60655((String)"collectorsalbum", (String)"album_card_manager");
    private static final AlbumCardManager INSTANCE = new AlbumCardManager();
    public static final Codec<AlbumCard> BY_NAME_CODEC = class_2960.field_25139.comapFlatMap(identifier -> {
        AlbumCard card = AlbumCardManager.INSTANCE.registeredCards.get(identifier);
        return card != null ? DataResult.success((Object)card) : DataResult.error(() -> "Unknown card: " + String.valueOf(identifier));
    }, AlbumCard::identifier);
    private final Map<class_2960, AlbumCard> registeredCards = new HashMap<class_2960, AlbumCard>();
    private final Map<class_1792, AlbumCard> byItemMap = new HashMap<class_1792, AlbumCard>();

    private AlbumCardManager() {
        super("album/cards", AlbumCardType.INSTANCE_CODEC);
    }

    public static AlbumCardManager getInstance() {
        return INSTANCE;
    }

    public Optional<AlbumCard> getCardInfo(class_1792 item) {
        return Optional.ofNullable(this.byItemMap.get(item));
    }

    public AlbumCard getCardById(class_2960 location) {
        return this.registeredCards.get(location);
    }

    public boolean isCard(class_1792 item) {
        return this.byItemMap.containsKey(item);
    }

    @Override
    public class_2960 identifier() {
        return IDENTIFIER;
    }

    @Override
    protected void preApply(Map<class_2960, JsonElement> resources, class_3300 manager, class_3695 profiler) {
        this.registeredCards.clear();
        this.byItemMap.clear();
    }

    @Override
    protected void resolve(class_2960 path, AlbumCard element) {
        if (this.registeredCards.putIfAbsent(element.identifier(), element) != null) {
            throw new IllegalArgumentException("Duplicate card with ID: " + String.valueOf(element.identifier()));
        }
        class_1799 itemStack = element.asItem();
        class_1792 item = itemStack.method_7909();
        if (this.byItemMap.putIfAbsent(item, element) != null) {
            throw new IllegalArgumentException(String.format("Duplicate item registered as a card in %s and %s cards", path.toString(), this.byItemMap.get(item).identifier()));
        }
    }

    @Override
    public List<AlbumCard> getNetworkData() {
        return new ArrayList<AlbumCard>(this.registeredCards.values());
    }

    @Override
    public synchronized void onNetworkDataReceived(List<AlbumCard> collection) {
        this.registeredCards.clear();
        this.byItemMap.clear();
        collection.forEach(card -> {
            this.registeredCards.put(card.identifier(), (AlbumCard)card);
            this.byItemMap.put(card.asItem().method_7909(), (AlbumCard)card);
        });
    }
}

