/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.bonus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumBonusDescriptionOutput;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.CommonLabels;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.CardCategoryFilter;
import team.tnt.collectorsalbum.common.init.AlbumBonusRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonus;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonusType;
import team.tnt.collectorsalbum.common.resource.bonus.IntermediateAlbumBonus;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;

public class AlbumCategoryCardBonusFilter
implements IntermediateAlbumBonus {
    public static final class_2561 UNKNOWN_CATEGORY_LABEL = class_2561.method_43471((String)"collectorsalbum.label.unknown").method_27692(class_124.field_1061);
    public static final String MATCHED = "collectorsalbum.label.bonus.matched_cards";
    public static final MapCodec<AlbumCategoryCardBonusFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("category").forGetter(t -> t.category), (App)CardCategoryFilter.CODEC.optionalFieldOf("filter", (Object)CardCategoryFilter.NO_FILTER).forGetter(t -> t.filter), (App)AlbumBonusType.INSTANCE_CODEC.fieldOf("item").forGetter(t -> t.item)).apply((Applicative)instance, AlbumCategoryCardBonusFilter::new));
    private final class_2960 category;
    private final CardCategoryFilter filter;
    private final AlbumBonus item;

    public AlbumCategoryCardBonusFilter(class_2960 category, CardCategoryFilter filter, AlbumBonus item) {
        this.category = category;
        this.filter = filter;
        this.item = item;
    }

    @Override
    public void addDescription(AlbumBonusDescriptionOutput description) {
        class_2561 categoryDisplayLabel = AlbumCategoryManager.getInstance().findById(this.category).map(AlbumCategory::getDisplayText).orElse(UNKNOWN_CATEGORY_LABEL);
        class_5250 categoryIdentifierLabel = class_2561.method_43470((String)this.category.toString());
        description.text((class_2561)class_2561.method_43469((String)"collectorsalbum.tooltip.card.category", (Object[])new Object[]{categoryDisplayLabel}), (class_2561)categoryIdentifierLabel);
        description.nested(() -> {
            if (this.filter != CardCategoryFilter.NO_FILTER) {
                description.text(CardCategoryFilter.LABEL_FILTER);
                description.nested(() -> this.filter.generateDescriptionLabels(description));
            }
            boolean canApply = this.canApply(description.getContext());
            class_5250 matchingCards = class_2561.method_43470((String)String.valueOf(this.getMatchingCards(description.getContext()))).method_27692(AlbumBonusDescriptionOutput.getBooleanColor(canApply));
            class_5250 matched = class_2561.method_43469((String)MATCHED, (Object[])new Object[]{matchingCards});
            description.text((class_2561)matched, this.filter.cardCountFilter().getDisplayComponent());
            description.condition(CommonLabels.APPLIES, CommonLabels.getBoolState(canApply), canApply, this);
        });
    }

    @Override
    public void apply(ActionContext context) {
        if (this.canApply(context)) {
            this.item.apply(context);
        } else {
            this.item.removed(context);
        }
    }

    @Override
    public void removed(ActionContext context) {
        this.item.removed(context);
    }

    @Override
    public List<AlbumBonus> children() {
        return Collections.singletonList(this.item);
    }

    @Override
    public AlbumBonusType<?> getType() {
        return (AlbumBonusType)AlbumBonusRegistry.CATEGORY_FILTER.get();
    }

    @Override
    public boolean canApply(ActionContext context) {
        int matching = this.getMatchingCards(context);
        return this.filter.cardCountFilter().test(matching);
    }

    private int getMatchingCards(ActionContext context) {
        return context.get("album", Album.class).map(album -> {
            Collection<AlbumCard> cards = album.getCardsForCategory(this.category);
            List<AlbumCard> validCards = cards.stream().filter(card -> card.test(this.filter)).toList();
            return validCards.size();
        }).orElse(0);
    }
}

