/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.bonus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import team.tnt.collectorsalbum.common.AlbumBonusDescriptionOutput;
import team.tnt.collectorsalbum.common.init.AlbumBonusRegistry;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonus;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonusType;
import team.tnt.collectorsalbum.common.resource.function.ConstantNumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProviderType;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;

public class AlbumMobEffectBonus
implements AlbumBonus {
    public static final MapCodec<AlbumMobEffectBonus> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("rewriteExisting", (Object)false).forGetter(t -> t.rewriteExisting), (App)Codec.BOOL.optionalFieldOf("forceRemove", (Object)false).forGetter(t -> t.forceRemove), (App)class_1291.field_51933.fieldOf("effect").forGetter(t -> t.effect), (App)Codec.either((Codec)class_5699.field_33442, NumberProviderType.INSTANCE_CODEC).optionalFieldOf("duration", (Object)Either.left((Object)120)).forGetter(t -> Either.right((Object)t.duration)), (App)Codec.either((Codec)class_5699.method_48766((int)0, (int)255), NumberProviderType.INSTANCE_CODEC).optionalFieldOf("amplifier", (Object)Either.right((Object)ConstantNumberProvider.ZERO)).forGetter(t -> Either.right((Object)t.amplifier)), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)true).forGetter(t -> t.ambient), (App)Codec.BOOL.optionalFieldOf("visible", (Object)false).forGetter(t -> t.visible), (App)Codec.BOOL.optionalFieldOf("showIcon", (Object)true).forGetter(t -> t.showIcon)).apply((Applicative)instance, AlbumMobEffectBonus::new));
    private final boolean rewriteExisting;
    private final boolean forceRemove;
    private final class_6880<class_1291> effect;
    private final NumberProvider duration;
    private final NumberProvider amplifier;
    private final boolean ambient;
    private final boolean visible;
    private final boolean showIcon;

    public AlbumMobEffectBonus(boolean rewriteExisting, boolean forceRemove, class_6880<class_1291> effect, Either<Integer, NumberProvider> duration, Either<Integer, NumberProvider> amplifier, boolean ambient, boolean visible, boolean showIcon) {
        this.rewriteExisting = rewriteExisting;
        this.forceRemove = forceRemove;
        this.effect = effect;
        this.duration = (NumberProvider)duration.map(ConstantNumberProvider::new, Function.identity());
        this.amplifier = (NumberProvider)amplifier.map(ConstantNumberProvider::new, Function.identity());
        this.ambient = ambient;
        this.visible = visible;
        this.showIcon = showIcon;
    }

    @Override
    public void addDescription(AlbumBonusDescriptionOutput description) {
        class_1291 mobEffect = (class_1291)this.effect.comp_349();
        int amplifierValue = this.amplifier.intValue();
        ActionContext context = description.getContext();
        class_1657 player = context.getOrThrow("player", class_1657.class);
        class_2561 amplifier = amplifierValue >= 1 && amplifierValue <= 9 ? class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + (amplifierValue + 1)))) : class_5244.field_39003;
        class_5250 title = class_2561.method_43469((String)"collectorsalbum.label.bonus.mob_effect.effect", (Object[])new Object[]{mobEffect.method_5560(), amplifier}).method_27692(class_124.field_1078);
        class_5250 tooltip = class_2561.method_43469((String)"collectorsalbum.label.bonus.mob_effect.duration", (Object[])new Object[]{class_1292.method_5577((class_1293)this.createEffectInstance(), (float)1.0f, (float)player.method_37908().method_54719().method_54748())});
        description.text((class_2561)title, (class_2561)tooltip);
    }

    @Override
    public void apply(ActionContext context) {
        class_1293 instance;
        class_1657 player = context.getOrThrow("player", class_1657.class);
        if (!player.method_6092(instance = this.createEffectInstance()) && this.rewriteExisting) {
            player.method_6016(this.effect);
            player.method_6092(instance);
        }
    }

    @Override
    public void removed(ActionContext context) {
        if (this.forceRemove) {
            class_1657 player = context.getOrThrow("player", class_1657.class);
            player.method_6016(this.effect);
        }
    }

    @Override
    public AlbumBonusType<?> getType() {
        return (AlbumBonusType)AlbumBonusRegistry.MOB_EFFECT.get();
    }

    private class_1293 createEffectInstance() {
        return new class_1293(this.effect, this.duration.intValue(), this.amplifier.intValue(), this.ambient, this.visible, this.showIcon);
    }
}

