/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.bonus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumBonusDescriptionOutput;
import team.tnt.collectorsalbum.common.CommonLabels;
import team.tnt.collectorsalbum.common.card.IntFilter;
import team.tnt.collectorsalbum.common.init.AlbumBonusRegistry;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonus;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonusType;
import team.tnt.collectorsalbum.common.resource.bonus.IntermediateAlbumBonus;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;

public class AlbumPointBonusFilter
implements IntermediateAlbumBonus {
    public static final MapCodec<AlbumPointBonusFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IntFilter.CODEC.fieldOf("filter").forGetter(t -> t.range), (App)AlbumBonusType.INSTANCE_CODEC.fieldOf("item").forGetter(t -> t.item)).apply((Applicative)instance, AlbumPointBonusFilter::new));
    public static final class_2561 POINT_FILTER = class_2561.method_43471((String)"collectorsalbum.label.bonus.point_filter");
    private final IntFilter range;
    private final AlbumBonus item;

    public AlbumPointBonusFilter(IntFilter range, AlbumBonus item) {
        this.range = range;
        this.item = item;
    }

    @Override
    public void addDescription(AlbumBonusDescriptionOutput description) {
        boolean applicable = this.canApply(description.getContext());
        class_2561 base = this.range.getDisplayComponent();
        class_5250 value = base != null ? class_2561.method_43470((String)(base.getString() + " - " + CommonLabels.getBoolState(applicable).getString())).method_27692(AlbumBonusDescriptionOutput.getBooleanColor(applicable)) : null;
        description.condition(POINT_FILTER, (class_2561)value, applicable, this);
    }

    @Override
    public void apply(ActionContext context) {
        if (this.canApply(context)) {
            this.item.apply(context);
        } else {
            this.item.removed(context);
        }
    }

    @Override
    public void removed(ActionContext context) {
        this.item.removed(context);
    }

    @Override
    public List<AlbumBonus> children() {
        return Collections.singletonList(this.item);
    }

    @Override
    public AlbumBonusType<?> getType() {
        return (AlbumBonusType)AlbumBonusRegistry.ALBUM_POINT_FILTER.get();
    }

    @Override
    public boolean canApply(ActionContext context) {
        Album album = context.getNullable("album", Album.class);
        if (album == null) {
            return false;
        }
        return this.range.test(album.getPoints());
    }
}

