/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.bonus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.value.IConfigValueReadable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import team.tnt.collectorsalbum.common.AlbumBonusDescriptionOutput;
import team.tnt.collectorsalbum.common.CommonLabels;
import team.tnt.collectorsalbum.common.init.AlbumBonusRegistry;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonus;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonusType;
import team.tnt.collectorsalbum.common.resource.bonus.IntermediateAlbumBonus;
import team.tnt.collectorsalbum.common.resource.bonus.NoBonus;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;

public class ConfigToggleBonusFilter
implements IntermediateAlbumBonus {
    private static final String IS_ENABLED = "collectorsalbum.label.bonus.config_toggle.enabled";
    private static final String IS_DISABLED = "collectorsalbum.label.bonus.config_toggle.disabled";
    private static final class_2561 UNKNOWN_CONFIG_OPTION = class_2561.method_43471((String)"collectorsalbum.label.bonus.config_toggle.unknown").method_27692(class_124.field_1061);
    public static final MapCodec<ConfigToggleBonusFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Configuration.BY_ID_CODEC.fieldOf("config").forGetter(t -> t.config), (App)Codec.STRING.fieldOf("path").forGetter(t -> t.path), (App)AlbumBonusType.INSTANCE_CODEC.fieldOf("enabled").forGetter(t -> t.enabled), (App)AlbumBonusType.INSTANCE_CODEC.optionalFieldOf("disabled", (Object)NoBonus.INSTANCE).forGetter(t -> t.disabled)).apply((Applicative)instance, ConfigToggleBonusFilter::new));
    private final ConfigHolder<?> config;
    private final String path;
    private final AlbumBonus enabled;
    private final AlbumBonus disabled;

    public ConfigToggleBonusFilter(ConfigHolder<?> config, String path, AlbumBonus enabled, AlbumBonus disabled) {
        this.config = config;
        this.path = path;
        this.enabled = enabled;
        this.disabled = disabled;
    }

    @Override
    public void addDescription(AlbumBonusDescriptionOutput description) {
        Optional configValue = this.config.getConfigValue(this.path, Boolean.class);
        class_2561 configLabel = configValue.map(val -> val.getTitle().method_27661().method_27692(class_124.field_1078)).orElse(UNKNOWN_CONFIG_OPTION);
        class_5250 configName = class_2561.method_43471((String)("config.screen." + this.config.getConfigId()));
        description.text(configLabel, (class_2561)configName);
        boolean enabled = this.canApply(description.getContext());
        if (this.enabled != NoBonus.INSTANCE) {
            description.nested(() -> {
                description.text((class_2561)class_2561.method_43471((String)IS_ENABLED).method_27692(AlbumBonusDescriptionOutput.getBooleanColor(enabled)), CommonLabels.getBoolState(enabled));
                description.nested(() -> this.enabled.addDescription(description));
            });
        }
        if (this.disabled != NoBonus.INSTANCE) {
            description.nested(() -> {
                description.text((class_2561)class_2561.method_43471((String)IS_DISABLED).method_27692(AlbumBonusDescriptionOutput.getBooleanColor(!enabled)), CommonLabels.getBoolState(!enabled));
                description.nested(() -> this.disabled.addDescription(description));
            });
        }
    }

    @Override
    public void apply(ActionContext context) {
        if (this.canApply(context)) {
            this.enabled.apply(context);
        } else {
            this.disabled.apply(context);
        }
    }

    @Override
    public void removed(ActionContext context) {
        this.enabled.removed(context);
        this.disabled.removed(context);
    }

    @Override
    public List<AlbumBonus> children() {
        return Arrays.asList(this.enabled, this.disabled);
    }

    @Override
    public AlbumBonusType<?> getType() {
        return (AlbumBonusType)AlbumBonusRegistry.CONFIG_TOGGLE.get();
    }

    @Override
    public boolean canApply(ActionContext context) {
        return this.config.getConfigValue(this.path, Boolean.class).map(value -> (Boolean)value.get(IConfigValueReadable.Mode.SAVED)).orElse(false);
    }
}

