/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.drops;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import team.tnt.collectorsalbum.CollectorsAlbum;
import team.tnt.collectorsalbum.common.init.ItemDropProviderRegistry;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProvider;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProviderType;
import team.tnt.collectorsalbum.common.resource.drops.NoItemDropProvider;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.common.resource.util.OutputBuilder;

public class EntityFilterItemDropProvider
implements ItemDropProvider {
    public static final MapCodec<EntityFilterItemDropProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41266).fieldOf("filter").forGetter(t -> t.filter), (App)ItemDropProviderType.INSTANCE_CODEC.fieldOf("pass").forGetter(t -> t.pass), (App)ItemDropProviderType.INSTANCE_CODEC.optionalFieldOf("fail", (Object)NoItemDropProvider.INSTANCE).forGetter(t -> t.fail)).apply((Applicative)instance, EntityFilterItemDropProvider::new));
    private final class_6862<class_1299<?>> filter;
    private final ItemDropProvider pass;
    private final ItemDropProvider fail;

    public EntityFilterItemDropProvider(class_6862<class_1299<?>> filter, ItemDropProvider pass, ItemDropProvider fail) {
        this.filter = filter;
        this.pass = pass;
        this.fail = fail;
    }

    @Override
    public void generateDrops(ActionContext context, OutputBuilder<class_1799> output) {
        class_1297 entity = context.getNullable("entity", class_1297.class);
        if (entity == null) {
            CollectorsAlbum.LOGGER.warn("Failed to generate item drop, 'entity' key is not found in drop context!");
            return;
        }
        class_1299 entityType = entity.method_5864();
        if (entityType.method_20210(this.filter)) {
            this.pass.generateDrops(context, output);
        } else {
            this.fail.generateDrops(context, output);
        }
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return (ItemDropProviderType)ItemDropProviderRegistry.ENTITY_FILTER.get();
    }
}

