/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.drops;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import team.tnt.collectorsalbum.CollectorsAlbum;
import team.tnt.collectorsalbum.common.init.ItemDropProviderRegistry;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProvider;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProviderType;
import team.tnt.collectorsalbum.common.resource.function.ConstantNumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProviderType;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.common.resource.util.OutputBuilder;
import team.tnt.collectorsalbum.util.TagHelper;

public class TagDropProvider
implements ItemDropProvider {
    public static final MapCodec<TagDropProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41197).fieldOf("tag").forGetter(t -> t.tagKey), (App)Codec.either((Codec)class_5699.field_33442, NumberProviderType.INSTANCE_CODEC).optionalFieldOf("count", (Object)Either.left((Object)1)).forGetter(t -> Either.right((Object)t.size))).apply((Applicative)instance, TagDropProvider::new));
    private final class_6862<class_1792> tagKey;
    private final NumberProvider size;

    public TagDropProvider(class_6862<class_1792> tagKey, Either<Integer, NumberProvider> size) {
        this.tagKey = tagKey;
        this.size = (NumberProvider)size.map(ConstantNumberProvider::new, Function.identity());
    }

    @Override
    public void generateDrops(ActionContext context, OutputBuilder<class_1799> output) {
        class_5819 random = context.getOrThrow("random", class_5819.class);
        class_1792 item = TagHelper.getRandomTagValue(this.tagKey, class_7923.field_41178, random);
        if (item != null) {
            int sizeUpperBound = item.method_7882();
            int itemSize = class_3532.method_15340((int)this.size.intValue(), (int)1, (int)sizeUpperBound);
            output.accept(new class_1799((class_1935)item, itemSize));
        } else {
            CollectorsAlbum.LOGGER.warn("Failed to obtain items for tag {} for drop generation", this.tagKey);
        }
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return (ItemDropProviderType)ItemDropProviderRegistry.TAG_DROP_PROVIDER.get();
    }
}

