/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.util;

import java.util.List;
import team.tnt.collectorsalbum.common.resource.util.OutputBuilder;

public class SingleItemOutputBuilder<T>
implements OutputBuilder<T> {
    private T item;
    private boolean allowsOverwrite;

    private SingleItemOutputBuilder(boolean allowsOverwrite) {
        this.allowsOverwrite = allowsOverwrite;
    }

    public static <T> SingleItemOutputBuilder<T> acceptsFirst() {
        return new SingleItemOutputBuilder<T>(false);
    }

    public static <T> SingleItemOutputBuilder<T> acceptsLast() {
        return new SingleItemOutputBuilder<T>(true);
    }

    @Override
    public void accept(T item) {
        if (this.allowsOverwrite || this.item == null) {
            this.item = item;
        }
    }

    @Override
    public void acceptAll(List<T> items) {
        items.forEach(this::accept);
    }

    public T getItemOrDefault(T defaultItem) {
        return this.item != null ? this.item : defaultItem;
    }

    public boolean isLocked() {
        return !this.allowsOverwrite && this.item != null;
    }
}

