/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.platform;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_9139;

public final class Codecs {
    public static final Codec<Float> PERCENT_FLOAT = Codecs.rangeInclusiveFloat(0.0f, 1.0f);
    public static final Codec<Integer> COLOR_CODEC = Codec.either((Codec)Codec.INT, (Codec)Codec.STRING.comapFlatMap(text -> {
        try {
            int color = Integer.decode(text);
            return DataResult.success((Object)color);
        }
        catch (NumberFormatException e) {
            return DataResult.error(e::getMessage);
        }
    }, Integer::toHexString)).xmap(either -> (Integer)either.map(Function.identity(), Function.identity()), Either::left);

    public static Codec<Float> rangeInclusiveFloat(float min, float max) {
        return Codec.FLOAT.validate(f -> f.floatValue() >= min && f.floatValue() <= max ? DataResult.success((Object)f) : DataResult.error(() -> String.format("Value [%f] is not within required range [%f;%f]", f, Float.valueOf(min), Float.valueOf(max))));
    }

    public static <T> Codec<T[]> array(Codec<T> codec, IntFunction<T[]> toArray) {
        return Codecs.array(codec, toArray, Arrays::asList);
    }

    public static <T> Codec<T[]> array(Codec<T> codec, IntFunction<T[]> toArray, Function<T[], List<T>> toList) {
        return codec.listOf().xmap(list -> {
            Object[] values = (Object[])toArray.apply(list.size());
            for (int i = 0; i < list.size(); ++i) {
                values[i] = list.get(i);
            }
            return values;
        }, toList);
    }

    public static <T> Codec<Supplier<T>> supplier(Codec<T> codec) {
        return codec.xmap(t -> () -> t, Supplier::get);
    }

    public static <T, C extends Collection<T>> DataResult<C> requireSize(C collection, int size) {
        return collection.size() != size ? DataResult.error(() -> String.format("Collection must contain exactly %d elements, found %d!", size, collection.size())) : DataResult.success(collection);
    }

    public static <T> Codec<Set<T>> setCodec(Codec<T> codec) {
        return Codecs.setCodec(codec, HashSet::new);
    }

    public static <T> Codec<Set<T>> setCodec(Codec<T> codec, Function<List<T>, Set<T>> codecFactory) {
        return codec.listOf().xmap(codecFactory, ArrayList::new);
    }

    public static <T> Codec<class_2371<T>> nonNullListCodec(Codec<T> codec, T empty) {
        return codec.listOf().xmap(list -> {
            class_2371 nonNullList = class_2371.method_10213((int)list.size(), (Object)empty);
            for (int i = 0; i < list.size(); ++i) {
                nonNullList.set(i, list.get(i));
            }
            return nonNullList;
        }, Function.identity());
    }

    public static <BUF extends class_2540, T> class_9139<BUF, class_2371<T>> nonNullListStreamCodec(class_9139<BUF, T> codec, Predicate<T> skip, T empty) {
        return class_9139.method_56437((buf, list) -> {
            for (Object t : list) {
                boolean saved = !skip.test(t);
                buf.method_52964(saved);
                if (!saved) continue;
                codec.encode(buf, t);
            }
        }, buf -> {
            int size = buf.readInt();
            class_2371 list = class_2371.method_10213((int)size, (Object)empty);
            for (int i = 0; i < size; ++i) {
                boolean saved = buf.readBoolean();
                if (!saved) continue;
                Object t = codec.decode(buf);
                list.set(i, t);
            }
            return list;
        });
    }

    public static Codec<Float> minFloat(float min) {
        return Codecs.rangeInclusiveFloat(min, Float.MAX_VALUE);
    }

    public static Codec<Float> maxFloat(float max) {
        return Codecs.rangeInclusiveFloat(-3.4028235E38f, max);
    }

    public static <E extends Enum<E>> Codec<E> simpleEnumCodec(Class<E> type) {
        return Codecs.enumCodec(type, s -> Enum.valueOf(type, s), Enum::name);
    }

    public static <E extends Enum<E>> Codec<E> simpleEnumCodec(Class<E> type, UnaryOperator<String> nameTransform) {
        return Codecs.enumCodec(type, s -> Enum.valueOf(type, (String)nameTransform.apply((String)s)), Enum::name);
    }

    public static <E extends Enum<E>> Codec<E> enumCodecWithEncoder(Class<E> type, Function<E, String> encoder) {
        return Codecs.enumCodec(type, s -> Enum.valueOf(type, s), encoder);
    }

    public static <E extends Enum<E>> Codec<E> enumCodecWithDecoder(Class<E> type, Function<String, E> decoder) {
        return Codecs.enumCodec(type, decoder, Enum::name);
    }

    public static <E extends Enum<E>> Codec<E> enumCodec(Class<E> type, Function<String, E> decoder, Function<E, String> encoder) {
        return Codec.STRING.flatXmap(key -> {
            try {
                Enum value = (Enum)decoder.apply((String)key);
                return DataResult.success((Object)value);
            }
            catch (Exception e) {
                return DataResult.error(() -> String.format("Failed to decode enum '%s' due to error %s", type.getSimpleName(), e));
            }
        }, value -> {
            try {
                String key = (String)encoder.apply(value);
                return DataResult.success((Object)key);
            }
            catch (Exception e) {
                return DataResult.error(() -> String.format("Failed to encode enum to text for provided value '%s' due to error %s", value, e));
            }
        });
    }
}

