/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.platform.network;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import team.tnt.collectorsalbum.platform.Identifiable;
import team.tnt.collectorsalbum.platform.JavaServiceLoader;
import team.tnt.collectorsalbum.platform.network.Network;
import team.tnt.collectorsalbum.platform.network.PacketDirection;
import team.tnt.collectorsalbum.platform.network.PacketHandler;
import team.tnt.collectorsalbum.platform.network.PacketHolder;

public final class PlatformNetworkManager
implements Identifiable {
    public static final Network NETWORK = JavaServiceLoader.loadService(Network.class);
    private final class_2960 identifier;
    private Registry registry = new Registry();

    private PlatformNetworkManager(class_2960 identifier) {
        this.identifier = identifier;
    }

    @Override
    public class_2960 identifier() {
        return this.identifier;
    }

    public static class_2960 generatePacketIdentifier(Identifiable identifiable, Class<? extends class_8710> type) {
        return PlatformNetworkManager.generatePacketIdentifier(identifiable.identifier().method_12836(), type);
    }

    public static class_2960 generatePacketIdentifier(class_2960 identifier, Class<? extends class_8710> type) {
        return PlatformNetworkManager.generatePacketIdentifier(identifier.method_12836(), type);
    }

    public static class_2960 generatePacketIdentifier(String namespace, Class<? extends class_8710> type) {
        return class_2960.method_60655((String)namespace, (String)type.getSimpleName().replaceAll("([A-Z])", "_$1").toLowerCase(Locale.ROOT));
    }

    public static PlatformNetworkManager create(class_2960 identifier) {
        return new PlatformNetworkManager(identifier);
    }

    public static PlatformNetworkManager create(String namespace) {
        return PlatformNetworkManager.create(class_2960.method_60655((String)namespace, (String)"network"));
    }

    public <P extends class_8710, BUF extends class_2540> void registerPacket(PacketDirection direction, Class<P> payloadType, class_8710.class_9154<P> type, class_9139<BUF, P> codec) {
        this.registerPacket(direction, payloadType, type, codec, null);
    }

    public <P extends class_8710, BUF extends class_2540> void registerPacket(PacketDirection direction, Class<P> payloadType, class_8710.class_9154<P> type, class_9139<BUF, P> codec, PacketHandler<P> handler) {
        this.registry.register(direction, new PacketHolder<P, BUF>(payloadType, type, codec, handler));
    }

    public void bind() {
        ArrayList c2s = new ArrayList();
        ArrayList s2c = new ArrayList();
        this.bindRef(c2s::addAll, s2c::addAll);
        NETWORK.initialize(this.identifier, c2s, s2c);
    }

    public void bindRef(Consumer<List<PacketHolder<?, ?>>> c2sPackets, Consumer<List<PacketHolder<?, ?>>> s2cPackets) {
        List<PacketHolder<?, ?>> c2s = this.registry.sidePackets.get((Object)PacketDirection.CLIENT_TO_SERVER);
        List<PacketHolder<?, ?>> s2c = this.registry.sidePackets.get((Object)PacketDirection.SERVER_TO_CLIENT);
        if (!c2s.isEmpty()) {
            c2sPackets.accept(c2s);
        }
        if (!s2c.isEmpty()) {
            s2cPackets.accept(s2c);
        }
        this.registry = null;
    }

    private static final class Registry {
        private final EnumMap<PacketDirection, List<PacketHolder<?, ?>>> sidePackets = new EnumMap(PacketDirection.class);

        private Registry() {
            this.sidePackets.put(PacketDirection.CLIENT_TO_SERVER, new ArrayList());
            this.sidePackets.put(PacketDirection.SERVER_TO_CLIENT, new ArrayList());
        }

        void register(PacketDirection direction, PacketHolder<?, ?> packet) {
            this.sidePackets.get((Object)direction).add(packet);
        }
    }
}

