/*
 * Decompiled with CFR 0.152.
 */
package jeb.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import jeb.Jeb;
import jeb.accessor.AnimatedResultButtonExtension;
import jeb.accessor.RecipeBookWidgetBridge;
import jeb.client.FavoritesManager;
import jeb.mixin.RecipeBookResultsAccessor;
import jeb.mixin.RecipeBookWidgetAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeBookTabButton;
import net.minecraft.client.gui.screens.recipebook.RecipeButton;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeBookComponent.class})
public abstract class RecipeBookWidgetSearchMixin
implements RecipeBookWidgetBridge {
    @Shadow
    private ClientRecipeBook f_100283_;
    @Shadow
    private RecipeBookTabButton f_100280_;
    @Shadow
    protected Minecraft f_100272_;
    @Final
    @Shadow
    private RecipeBookPage f_100284_;
    @Shadow
    private EditBox f_100281_;
    @Shadow
    @Final
    private List<RecipeBookTabButton> f_100279_;
    @Shadow
    protected StateSwitchingButton f_100270_;
    @Unique
    private StateSwitchingButton jeb$customToggleButton;
    @Unique
    private boolean jeb$customToggleState = false;
    @Shadow
    protected RecipeBookMenu<?> f_100271_;

    @Shadow
    public void m_100387_() {
    }

    @Override
    public void jeb$refresh() {
        this.m_100387_();
    }

    @Inject(method={"initVisuals"}, at={@At(value="TAIL")})
    private void jeb$addCustomToggleButton(CallbackInfo ci) {
        int x = this.f_100270_.m_252754_();
        int y = this.f_100270_.m_252907_() + 120;
        this.jeb$customToggleButton = new StateSwitchingButton(x, y, 24, 24, false);
        if (Jeb.customToggleEnabled) {
            this.jeb$customToggleButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Show 3x3")));
            this.jeb$customToggleButton.m_94624_(152, 78, 26, 26, new ResourceLocation("minecraft", "textures/gui/recipe_book.png"));
        } else {
            this.jeb$customToggleButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Show 2x2")));
            this.jeb$customToggleButton.m_94624_(152, 78, 26, 26, new ResourceLocation("minecraft", "textures/gui/recipe_book.png"));
        }
        this.jeb$customToggleButton.m_93666_((Component)Component.m_237113_((String)"!"));
        this.jeb$customToggleButton.f_93624_ = true;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/StateSwitchingButton;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", ordinal=0, shift=At.Shift.AFTER)})
    private void jeb$renderCustomToggle(GuiGraphics p_283597_, int p_282668_, int p_283506_, float p_282813_, CallbackInfo ci) {
        if (this.jeb$customToggleButton != null && this.jeb$customToggleButton.f_93624_) {
            this.jeb$customToggleButton.m_88315_(p_283597_, p_282668_, p_283506_, p_282813_);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="RETURN")}, cancellable=true)
    private void jeb$clickCustomToggle(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (this.jeb$customToggleButton != null && this.jeb$customToggleButton.m_6375_(mouseX, mouseY, button)) {
            this.jeb$customToggleState = !this.jeb$customToggleState;
            this.jeb$customToggleButton.m_94635_(this.jeb$customToggleState);
            Jeb.customToggleEnabled = !Jeb.customToggleEnabled;
            Jeb.saveConfig();
            if (Jeb.customToggleEnabled) {
                this.jeb$customToggleButton.m_94624_(152, 78, 26, 26, new ResourceLocation("minecraft", "textures/gui/recipe_book.png"));
            } else {
                this.jeb$customToggleButton.m_94624_(152, 78, 26, 26, new ResourceLocation("minecraft", "textures/gui/recipe_book.png"));
            }
            this.jeb$customToggleButton.m_257544_(Jeb.customToggleEnabled ? Tooltip.m_257550_((Component)Component.m_237113_((String)"Show 3x3")) : Tooltip.m_257550_((Component)Component.m_237113_((String)"Show 2x2")));
            this.jeb$refresh();
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private boolean isFavoritesTabActive() {
        return this.f_100280_.m_100455_() == RecipeBookCategories.CAMPFIRE;
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void onKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        RecipeButton hovered;
        if (Jeb.ClientModEvents.FAVORITE_KEY != null && Jeb.ClientModEvents.FAVORITE_KEY.m_90832_(keyCode, scanCode) && (hovered = ((RecipeBookResultsAccessor)this.f_100284_).getHoveredResultButton()) != null) {
            if (this.isFavoritesTabActive()) {
                FavoritesManager.removeFavorite(hovered.m_100488_().m_8043_(hovered.m_100471_().m_266543_()));
                this.jeb$refresh();
            } else {
                FavoritesManager.saveFavorite(hovered.m_100488_().m_8043_(hovered.m_100471_().m_266543_()));
            }
            ((AnimatedResultButtonExtension)hovered).jeb$flash();
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;handlePlaceRecipe(ILnet/minecraft/world/item/crafting/Recipe;Z)V", shift=At.Shift.AFTER)})
    private void onRecipeClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        Minecraft client = Minecraft.m_91087_();
        RecipeManager recipeManager = client.f_91073_.m_7465_();
        Recipe recipe = this.f_100284_.m_100408_();
        RecipeCollection collection = this.f_100284_.m_100439_();
        Screen screenHandler = client.f_91080_;
        if (collection != null && recipe != null && screenHandler != null && !collection.m_100512_()) {
            recipeManager.m_44043_(recipe.m_6423_()).ifPresent(recipe1 -> {
                if (screenHandler instanceof RecipeUpdateListener) {
                    RecipeBookComponent recipeBookWidget = ((RecipeUpdateListener)client.f_91080_).m_5564_();
                    AbstractContainerMenu menu = client.f_91074_.f_36096_;
                    recipeBookWidget.m_7173_(recipe1, (List)menu.f_38839_);
                }
            });
        }
    }

    @Unique
    private boolean recipeDisplayMatchesIngredientQuery(Recipe<?> recipe, String query) {
        query = query.toLowerCase(Locale.ROOT);
        for (Ingredient ingredient : recipe.m_7527_()) {
            for (ItemStack stack : ingredient.m_43908_()) {
                String itemName = stack.m_41720_().m_5456_().toString().toLowerCase(Locale.ROOT);
                if (!itemName.contains(query)) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private boolean recipeResultMatchesQuery(Recipe<?> recipe, String query, String modName) {
        if (recipe == null || recipe.m_8043_(this.f_100272_.f_91073_.m_9598_()) == null || recipe.m_8043_(this.f_100272_.f_91073_.m_9598_()).m_41619_()) {
            return false;
        }
        ItemStack stack = recipe.m_8043_(this.f_100272_.f_91073_.m_9598_());
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        Minecraft client = Minecraft.m_91087_();
        String name = stack.m_41611_().getString().toLowerCase(Locale.ROOT);
        String id = stack.m_41720_().toString().toLowerCase(Locale.ROOT);
        String key = "";
        Component nameComponent = stack.m_41786_();
        ComponentContents componentContents = nameComponent.m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            key = translatable.m_237508_().toLowerCase(Locale.ROOT);
        }
        if (modName != null && !modName.isEmpty() && !BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).m_135827_().contains(modName)) {
            return false;
        }
        if (name.contains(query) || id.contains(query) || key.contains(query)) {
            return true;
        }
        TooltipFlag.Default tooltipFlag = this.f_100272_.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_;
        try {
            List tooltip = stack.m_41651_((Player)this.f_100272_.f_91074_, (TooltipFlag)tooltipFlag);
            for (Component line : tooltip) {
                String clean = ChatFormatting.m_126649_((String)line.getString()).toLowerCase(Locale.ROOT).trim();
                if (!clean.contains(query)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Inject(method={"updateCollections"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCustomSearch(boolean resetCurrentPage, CallbackInfo ci) {
        String string = this.f_100281_.m_94155_();
        boolean searchIngredients = string.startsWith("#");
        String query = (searchIngredients ? string.substring(1) : string).toLowerCase();
        String modName = null;
        if (string.startsWith("@")) {
            int endIndex = string.indexOf(" ");
            if (endIndex != -1) {
                modName = string.substring(1, endIndex).trim();
                query = string.substring(endIndex + 1).toLowerCase();
            } else {
                modName = string.substring(1).trim();
                query = "";
            }
        }
        ArrayList filteredList = new ArrayList();
        if (this.isFavoritesTabActive()) {
            Set<ResourceLocation> favoriteItems = FavoritesManager.loadFavoriteItemIds();
            ArrayList<RecipeCollection> favorites = new ArrayList<RecipeCollection>();
            block0: for (RecipeCollection collection : this.f_100283_.m_90623_(RecipeBookCategories.CRAFTING_SEARCH)) {
                for (Recipe recipe : collection.m_100516_()) {
                    ResourceLocation id;
                    ItemStack stack = recipe.m_8043_(this.f_100272_.f_91073_.m_9598_());
                    if (stack.m_41619_() || !favoriteItems.contains(id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()))) continue;
                    favorites.add(new RecipeCollection(this.f_100272_.f_91073_.m_9598_(), List.of(recipe)));
                    continue block0;
                }
            }
            filteredList.addAll(favorites);
            this.f_100284_.m_100436_(filteredList, resetCurrentPage);
            ci.cancel();
            return;
        }
        block2: for (RecipeCollection collection : this.f_100283_.m_90623_(this.f_100280_.m_100455_())) {
            if (!collection.m_100515_()) continue;
            for (Recipe recipe : collection.m_100516_()) {
                boolean match = searchIngredients ? this.recipeDisplayMatchesIngredientQuery(recipe, query) : this.recipeResultMatchesQuery(recipe, query, modName);
                if (!match) continue;
                filteredList.add(collection);
                continue block2;
            }
        }
        StackedContents contents = ((RecipeBookWidgetAccessor)((Object)this)).getRecipeFinder();
        for (RecipeCollection rc2 : filteredList) {
            rc2.m_100501_(contents, ((RecipeBookWidgetAccessor)((Object)this)).getCraftingScreenHandler().m_6635_(), ((RecipeBookWidgetAccessor)((Object)this)).getCraftingScreenHandler().m_6656_(), (RecipeBook)this.f_100283_);
        }
        if (this.jeb$customToggleState) {
            filteredList.removeIf(rc -> !rc.m_100515_());
        }
        if (this.f_100283_.m_12689_(this.f_100271_)) {
            filteredList.removeIf(rc -> !rc.m_100512_());
        }
        if (!Objects.equals(Jeb.search, string)) {
            Jeb.filtered = Jeb.generateCustomRecipeList(string);
        }
        filteredList.addAll(Jeb.filtered);
        Jeb.search = string;
        this.f_100284_.m_100436_(filteredList, resetCurrentPage);
        ci.cancel();
    }
}

