/*
 * Decompiled with CFR 0.152.
 */
package com.basicallymods.signs.common.menu;

import com.basicallymods.signs.common.data.SignRecipe;
import com.basicallymods.signs.common.registry.ModBlocks;
import com.basicallymods.signs.common.registry.ModMenus;
import com.basicallymods.signs.common.registry.ModRecipeTypes;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class SignWorkbenchMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int DYE_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private List<SignRecipe> recipes = Lists.newArrayList();
    private ItemStack input = ItemStack.f_41583_;
    private ItemStack dye = ItemStack.f_41583_;
    long lastSoundTime;
    final Slot inputSlot;
    final Slot resultSlot;
    final Slot dyeSlot;
    Runnable slotUpdateListener = () -> {};
    public final Container container = new SimpleContainer(2){

        public void m_6596_() {
            super.m_6596_();
            SignWorkbenchMenu.this.m_6199_((Container)this);
            SignWorkbenchMenu.this.slotUpdateListener.run();
        }
    };
    final ResultContainer resultContainer = new ResultContainer();

    public SignWorkbenchMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.f_39287_);
    }

    public SignWorkbenchMenu(int pContainerId, Inventory pPlayerInventory, final ContainerLevelAccess pAccess) {
        super((MenuType)ModMenus.SIGN_WORKBENCH_MENU.get(), pContainerId);
        this.access = pAccess;
        this.level = pPlayerInventory.f_35978_.m_9236_();
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 20, 15));
        this.dyeSlot = this.m_38897_(new Slot(this.container, 1, 20, 52));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 2, 143, 33){

            public boolean m_5857_(ItemStack p_40362_) {
                return false;
            }

            public void m_142406_(@NotNull Player pPlayer, @NotNull ItemStack itemStack) {
                itemStack.m_41678_(pPlayer.m_9236_(), pPlayer, itemStack.m_41613_());
                SignWorkbenchMenu.this.resultContainer.m_58395_(pPlayer, this.getRelevantItems());
                ItemStack signItem = SignWorkbenchMenu.this.inputSlot.m_6201_(1);
                ItemStack dyeItem = SignWorkbenchMenu.this.dyeSlot.m_6201_(1);
                if (!signItem.m_41619_() && !dyeItem.m_41619_()) {
                    SignWorkbenchMenu.this.setupResultSlot();
                }
                pAccess.m_39292_((level, blockPos) -> {
                    long l = level.m_46467_();
                    if (SignWorkbenchMenu.this.lastSoundTime != l) {
                        level.m_5594_(null, blockPos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        SignWorkbenchMenu.this.lastSoundTime = l;
                    }
                });
                super.m_142406_(pPlayer, itemStack);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(SignWorkbenchMenu.this.inputSlot.m_7993_(), SignWorkbenchMenu.this.dyeSlot.m_7993_());
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)pPlayerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)pPlayerInventory, k, 8 + k * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<SignRecipe> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && this.dyeSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player pPlayer) {
        return SignWorkbenchMenu.m_38889_((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)ModBlocks.SIGN_WORKBENCH.get()));
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        if (this.isValidRecipeIndex(pId)) {
            this.selectedRecipeIndex.m_6422_(pId);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int pRecipeIndex) {
        return pRecipeIndex >= 0 && pRecipeIndex < this.recipes.size();
    }

    public void m_6199_(Container pInventory) {
        ItemStack signItem = this.inputSlot.m_7993_();
        ItemStack dyeItem = this.dyeSlot.m_7993_();
        if (!signItem.m_150930_(this.input.m_41720_()) || !dyeItem.m_150930_(this.dye.m_41720_())) {
            this.input = signItem.m_41777_();
            this.dye = dyeItem.m_41777_();
            this.setupRecipeList(pInventory, signItem);
        }
    }

    private void setupRecipeList(Container pContainer, ItemStack signItem) {
        this.recipes.clear();
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (!signItem.m_41619_()) {
            this.recipes = this.level.m_7465_().m_44056_((RecipeType)ModRecipeTypes.SIGN_WORKBENCH_RECIPE.get(), pContainer, this.level);
        }
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            SignRecipe stonecutterrecipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            ItemStack itemstack = stonecutterrecipe.m_5874_(this.container, this.level.m_9598_());
            if (itemstack.m_246617_(this.level.m_246046_())) {
                this.resultContainer.m_6029_((Recipe)stonecutterrecipe);
                this.resultSlot.m_5852_(itemstack);
            } else {
                this.resultSlot.m_5852_(ItemStack.f_41583_);
            }
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public MenuType<?> m_6772_() {
        return (MenuType)ModMenus.SIGN_WORKBENCH_MENU.get();
    }

    public void registerUpdateListener(Runnable pListener) {
        this.slotUpdateListener = pListener;
    }

    public boolean m_5882_(ItemStack pStack, Slot pSlot) {
        return pSlot.f_40218_ != this.resultContainer && super.m_5882_(pStack, pSlot);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            Item item = itemstack1.m_41720_();
            itemstack = itemstack1.m_41777_();
            if (pIndex == 2) {
                item.m_7836_(itemstack1, pPlayer.m_9236_(), pPlayer);
                if (!this.m_38903_(itemstack1, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (pIndex == 0 || pIndex == 1 ? !this.m_38903_(itemstack1, 3, 39, false) : (this.level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.SIGN_WORKBENCH_RECIPE.get(), (Container)new SimpleContainer(new ItemStack[]{itemstack1}), this.level).isPresent() ? !this.m_38903_(itemstack1, 0, 2, false) : (pIndex >= 3 && pIndex < 30 ? !this.m_38903_(itemstack1, 0, 2, false) && !this.m_38903_(itemstack1, 30, 39, false) : pIndex >= 30 && pIndex < 39 && !this.m_38903_(itemstack1, 0, 2, false) && !this.m_38903_(itemstack1, 3, 30, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
            this.m_38946_();
        }
        return itemstack;
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.resultContainer.m_8016_(2);
        this.access.m_39292_((p_40313_, p_40314_) -> this.m_150411_(pPlayer, this.container));
    }
}

