/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.registry;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.kinetics.millstone.MillstoneBlockEntity;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.PonderRegistrationHelper;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.instruction.EmitParticlesInstruction;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pointing;
import com.tterrag.registrate.fabric.SimpleFlowableFluid;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import net.dakotapride.garnished.CreateGarnished;
import net.dakotapride.garnished.registry.GarnishedBlocks;
import net.dakotapride.garnished.registry.GarnishedEnchantments;
import net.dakotapride.garnished.registry.GarnishedFluids;
import net.dakotapride.garnished.registry.GarnishedItems;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1477;
import net.minecraft.class_1545;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;

public class GarnishedPonderIndex {
    static final PonderRegistrationHelper HELPER = new PonderRegistrationHelper("garnished");

    public static void index() {
        HELPER.forComponents(new ItemProviderEntry[]{GarnishedBlocks.DULSE_KELP, GarnishedBlocks.VERMILION_KELP, GarnishedItems.DRIED_DULSE_KELP, GarnishedItems.DRIED_VERMILION_KELP, GarnishedBlocks.DRIED_DULSE_KELP_BLOCK, GarnishedBlocks.DRIED_VERMILION_KELP_BLOCK}).addStoryBoard("boundless_sea/kelp_garnished", ScenesAndInteractions::kelpInWaterBlocks).addStoryBoard("boundless_sea/dulse_kelp", ScenesAndInteractions::dulseKelp).addStoryBoard("boundless_sea/vermilion_kelp", ScenesAndInteractions::vermilionKelp);
        HELPER.forComponents(new ItemProviderEntry[]{GarnishedItems.MASTIC_RESIN, GarnishedItems.MASTIC_RESIN_RED, GarnishedItems.MASTIC_RESIN_ORANGE, GarnishedItems.MASTIC_RESIN_YELLOW, GarnishedItems.MASTIC_RESIN_GREEN, GarnishedItems.MASTIC_RESIN_BLUE, GarnishedItems.MASTIC_RESIN_PURPLE, GarnishedItems.MASTIC_PASTE, GarnishedItems.MASTIC_PASTE_RED, GarnishedItems.MASTIC_PASTE_ORANGE, GarnishedItems.MASTIC_PASTE_YELLOW, GarnishedItems.MASTIC_PASTE_GREEN, GarnishedItems.MASTIC_PASTE_BLUE, GarnishedItems.MASTIC_PASTE_PURPLE}).addStoryBoard("sugarcoated/mastic_resin", ScenesAndInteractions::masticResinRecipe).addStoryBoard("sugarcoated/coloured_mastic_resin", ScenesAndInteractions::colouredMasticResin).addStoryBoard("sugarcoated/mastic_paste", ScenesAndInteractions::masticPaste).addStoryBoard("sugarcoated/mastic_fluid", ScenesAndInteractions::masticFluid).addStoryBoard("sugarcoated/mastic_fluid_interactions_1", ScenesAndInteractions::createStoneInteractions).addStoryBoard("sugarcoated/mastic_fluid_interactions_2", ScenesAndInteractions::vanillaStoneInteractions).addStoryBoard("sugarcoated/mastic_fluid_interactions_3", ScenesAndInteractions::garnishedStoneInteractions);
        HELPER.forComponents(new ItemProviderEntry[]{GarnishedItems.CRACKED_WALNUT, GarnishedItems.CRACKED_ALMOND, GarnishedItems.CRACKED_BUHG, GarnishedItems.CRACKED_CASHEW, GarnishedItems.CRACKED_CHESTNUT, GarnishedItems.CRACKED_HAZELNUT, GarnishedItems.CRACKED_MACADAMIA, GarnishedItems.CRACKED_PECAN, GarnishedItems.CRACKED_PISTACHIO}).addStoryBoard("general/cracked_nut_grown", ScenesAndInteractions::grownNutTree).addStoryBoard("general/milling_nuts", ScenesAndInteractions::millingNuts).addStoryBoard("general/cracked_nut_plant", ScenesAndInteractions::crackedNuts);
        HELPER.forComponents(new ItemProviderEntry[]{GarnishedItems.WOODEN_HATCHET, GarnishedItems.STONE_HATCHET, GarnishedItems.IRON_HATCHET, GarnishedItems.GOLDEN_HATCHET, GarnishedItems.DIAMOND_HATCHET, GarnishedItems.NETHERITE_HATCHET, GarnishedItems.AMETRINE_HATCHET, GarnishedItems.AQUAMARINE_HATCHET, GarnishedItems.JADE_HATCHET, GarnishedItems.RUBY_HATCHET, GarnishedItems.GILDED_NETHERITE_HATCHET, GarnishedItems.ROSE_GOLD_HATCHET, GarnishedItems.SAPPHIRE_HATCHET, GarnishedItems.TOPAZ_HATCHET, GarnishedItems.WARDEN_HATCHET}).addStoryBoard("general/hatchets_showcase", ScenesAndInteractions::hatchets).addStoryBoard("general/hatchet_attacking", ScenesAndInteractions::hatchetAttacking).addStoryBoard("integration/integrated_hatchets", ScenesAndInteractions::integratedHatchets);
        HELPER.forComponents(new ItemProviderEntry[]{GarnishedItems.BOTTLED_PEANUT_OIL}).addStoryBoard("general/bottled_peanut_oil", ScenesAndInteractions::bottledPeanutOil).addStoryBoard("general/blaze_burner_additional_heat_sources", ScenesAndInteractions::additionalHeatSources);
        HELPER.forComponents(new ItemProviderEntry[]{GarnishedItems.APPLE_CIDER, GarnishedItems.CRYPTIC_APPLE_CIDER, GarnishedItems.BITTER_APPLE_CIDER}).addStoryBoard("general/apple_cider_creation", ScenesAndInteractions::appleCiderCreation).addStoryBoard("general/apple_cider_fluid", ScenesAndInteractions::bottledAppleCider).addStoryBoard("general/other_apple_cider_items", ScenesAndInteractions::appleCiderMisc);
        HELPER.forComponents(new ItemProviderEntry[]{GarnishedItems.FERMENTED_CASHEW_MIXTURE, GarnishedItems.CASHEW_SORBET_SCOOP}).addStoryBoard("general/cashew_mixture_fluid", ScenesAndInteractions::cashewMixtureFluid).addStoryBoard("general/cashew_sorbet_scoop_creation", ScenesAndInteractions::cashewSorbetScoopCreation);
        HELPER.forComponents(new ItemProviderEntry[]{GarnishedItems.BRITTLE_DUST, GarnishedItems.SENILE_DUST, GarnishedItems.SENILE_SPREAD}).addStoryBoard("incineration/brittle_dust", ScenesAndInteractions::brittleDust).addStoryBoard("incineration/senile_dust", ScenesAndInteractions::senileDust).addStoryBoard("incineration/senile_spread", ScenesAndInteractions::senileSpread);
        HELPER.forComponents(new ItemProviderEntry[]{GarnishedItems.CRUSHED_SEPIA_FUNGUS, GarnishedBlocks.SEPIA_FUNGUS});
        HELPER.forComponents(new ItemProviderEntry[]{GarnishedItems.CRUSHED_CRIMSON_FUNGUS, GarnishedItems.CRUSHED_WARPED_FUNGUS, GarnishedItems.CRUSHED_SEPIA_FUNGUS, GarnishedItems.CRUSHED_SHROOMLIGHT}).addStoryBoard("incineration/crushing_fungus", ScenesAndInteractions::crushingFungus);
        HELPER.forComponents(new ItemProviderEntry[]{GarnishedItems.BOTTLED_PEANUT_OIL, GarnishedItems.APPLE_CIDER, GarnishedItems.FERMENTED_CASHEW_MIXTURE, GarnishedItems.CRYPTIC_APPLE_CIDER, GarnishedItems.BITTER_APPLE_CIDER}).addStoryBoard("general/basic_fluid_interactions", ScenesAndInteractions::basicFluidInteractions).addStoryBoard("sugarcoated/mastic_fluid_interactions_1", ScenesAndInteractions::createStoneInteractions).addStoryBoard("sugarcoated/mastic_fluid_interactions_2", ScenesAndInteractions::vanillaStoneInteractions).addStoryBoard("sugarcoated/mastic_fluid_interactions_3", ScenesAndInteractions::garnishedStoneInteractions);
    }

    static class ScenesAndInteractions {
        ScenesAndInteractions() {
        }

        public static void driedKelpBlocks(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("dried_kelp_blocks", "Dried Kelp Blocks from Garnished");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
        }

        public static void kelpInWaterBlocks(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("kelp_garnished", "kelp_blocks_from_garnished");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.overlay.showText(180).attachKeyFrame().placeNearTarget().text("worldgen_certain_biomes").pointAt(util.vector.of(2.0, 1.5, 2.0));
            scene.idle(30);
            scene.markAsFinished();
        }

        public static void dulseKelp(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("dulse_kelp", "dulse_kelp");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(10);
            class_1799 itemStack = new class_1799((class_1935)GarnishedBlocks.DULSE_KELP.method_8389());
            class_1799 itemStack1 = new class_1799(GarnishedItems.DRIED_DULSE_KELP);
            class_243 entitySpawn = util.vector.centerOf(3, 1, 1);
            class_243 entitySpawn1 = util.vector.centerOf(3, 2, 3);
            ElementLink entity = scene.world.createItemEntity(entitySpawn, util.vector.of(0.0, 0.0, 0.0), itemStack);
            scene.idle(10);
            scene.overlay.showText(100).attachKeyFrame().placeNearTarget().text("frozen_ocean_kelp").pointAt(util.vector.centerOf(3, 1, 1));
            scene.idle(110);
            scene.world.modifyEntity(entity, class_1297::method_31472);
            scene.idle(10);
            ElementLink entity1 = scene.world.createItemEntity(entitySpawn1, util.vector.of(0.0, 0.0, 0.0), itemStack1);
            scene.overlay.showText(100).attachKeyFrame().placeNearTarget().text("dried_dulse_kelp").pointAt(util.vector.centerOf(3, 2, 3));
            scene.idle(110);
            scene.world.modifyEntity(entity1, class_1297::method_31472);
            scene.idle(10);
            scene.overlay.showText(100).attachKeyFrame().placeNearTarget().text("dried_dulse_kelp_block").pointAt(util.vector.centerOf(3, 1, 3));
            scene.idle(120);
        }

        public static void vermilionKelp(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("vermilion_kelp", "vermilion_kelp");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(10);
            class_1799 itemStack = new class_1799((class_1935)GarnishedBlocks.VERMILION_KELP.method_8389());
            class_1799 itemStack1 = new class_1799(GarnishedItems.DRIED_VERMILION_KELP);
            class_243 entitySpawn = util.vector.centerOf(3, 1, 1);
            class_243 entitySpawn1 = util.vector.centerOf(3, 2, 3);
            ElementLink entity = scene.world.createItemEntity(entitySpawn, util.vector.of(0.0, 0.0, 0.0), itemStack);
            scene.idle(10);
            scene.overlay.showText(100).attachKeyFrame().placeNearTarget().text("cold_ocean_kelp").pointAt(util.vector.centerOf(3, 1, 1));
            scene.idle(110);
            scene.world.modifyEntity(entity, class_1297::method_31472);
            scene.idle(10);
            ElementLink entity1 = scene.world.createItemEntity(entitySpawn1, util.vector.of(0.0, 0.0, 0.0), itemStack1);
            scene.overlay.showText(100).attachKeyFrame().placeNearTarget().text("dried_vermilion_kelp").pointAt(util.vector.centerOf(3, 2, 3));
            scene.idle(110);
            scene.world.modifyEntity(entity1, class_1297::method_31472);
            scene.idle(10);
            scene.overlay.showText(100).attachKeyFrame().placeNearTarget().text("dried_vermilion_kelp_block").pointAt(util.vector.centerOf(1, 1, 3));
            scene.idle(120);
        }

        public static void masticResinRecipe(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("mastic_resin_recipe", "mastic_resin_recipe");
            scene.configureBasePlate(0, 0, 5);
            scene.showBasePlate();
            scene.world.showSection(util.select.layer(0), class_2350.field_11036);
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(40);
            class_2338 basin = util.grid.at(2, 2, 2);
            class_2338 pressPos = util.grid.at(2, 4, 2);
            class_1799 slimeBall = new class_1799((class_1935)class_1802.field_8777);
            class_1799 wheatSeeds = new class_1799((class_1935)class_1802.field_8317);
            class_1799 masticResin = new class_1799(GarnishedItems.MASTIC_RESIN);
            scene.overlay.showText(100).attachKeyFrame().placeNearTarget().text("mastic_resin_recipe_ingredients").pointAt(util.vector.centerOf(2, 2, 2));
            scene.idle(10);
            scene.overlay.showControls(new InputWindowElement(util.vector.topOf(basin), Pointing.LEFT).withItem(slimeBall), 30);
            scene.overlay.showControls(new InputWindowElement(util.vector.topOf(basin), Pointing.RIGHT).withItem(wheatSeeds), 30);
            scene.idle(30);
            Class<MechanicalPressBlockEntity> type = MechanicalPressBlockEntity.class;
            scene.world.modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BASIN));
            scene.world.createItemOnBeltLike(basin, class_2350.field_11036, wheatSeeds);
            scene.world.createItemOnBeltLike(basin, class_2350.field_11036, wheatSeeds);
            scene.world.createItemOnBeltLike(basin, class_2350.field_11036, wheatSeeds);
            scene.world.createItemOnBeltLike(basin, class_2350.field_11036, slimeBall);
            scene.idle(80);
            scene.overlay.showText(100).attachKeyFrame().placeNearTarget().text("mastic_resin_recipe_result").pointAt(util.vector.centerOf(1, 2, 1));
            scene.idle(10);
            scene.world.modifyBlockEntityNBT(util.select.position(basin), BasinBlockEntity.class, nbt -> nbt.method_10566("VisualizedItems", (class_2520)NBTHelper.writeCompoundList((Iterable)ImmutableList.of((Object)IntAttached.with((int)1, (Object)masticResin)), ia -> (class_2487)((class_1799)ia.getValue()).serializeNBT())));
            scene.idle(4);
            scene.world.createItemOnBelt(util.grid.at(2, 1, 1), class_2350.field_11036, masticResin);
            scene.idle(30);
            scene.markAsFinished();
        }

        public static void colouredMasticResin(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("coloured_mastic_resin", "coloured_mastic_resin");
            scene.configureBasePlate(0, 0, 5);
            scene.showBasePlate();
            scene.world.showSection(util.select.layer(0), class_2350.field_11036);
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.overlay.showText(120).attachKeyFrame().placeNearTarget().text("coloured_mastic_resin_basic").pointAt(util.vector.centerOf(3, 2, 3));
            scene.idle(40);
            Class<MechanicalCrafterBlockEntity> type = MechanicalCrafterBlockEntity.class;
            class_1799 masticResin = new class_1799(GarnishedItems.MASTIC_RESIN);
            class_1799 redDye = new class_1799((class_1935)class_1802.field_8264);
            scene.world.setCraftingResult(util.grid.at(3, 1, 3), new class_1799(GarnishedItems.MASTIC_RESIN_RED));
            scene.world.modifyBlockEntity(util.grid.at(3, 3, 3), type, mct -> TransferUtil.insertItem((Storage)mct.getInventory(), (class_1799)masticResin.method_7972()));
            scene.world.modifyBlockEntity(util.grid.at(3, 3, 2), type, mct -> TransferUtil.insertItem((Storage)mct.getInventory(), (class_1799)masticResin.method_7972()));
            scene.idle(5);
            scene.world.modifyBlockEntity(util.grid.at(3, 3, 1), type, mct -> TransferUtil.insertItem((Storage)mct.getInventory(), (class_1799)masticResin.method_7972()));
            scene.idle(5);
            scene.world.modifyBlockEntity(util.grid.at(3, 2, 1), type, mct -> TransferUtil.insertItem((Storage)mct.getInventory(), (class_1799)masticResin.method_7972()));
            scene.idle(5);
            scene.world.modifyBlockEntity(util.grid.at(3, 2, 2), type, mct -> TransferUtil.insertItem((Storage)mct.getInventory(), (class_1799)redDye.method_7972()));
            scene.idle(5);
            scene.world.modifyBlockEntity(util.grid.at(3, 2, 3), type, mct -> TransferUtil.insertItem((Storage)mct.getInventory(), (class_1799)masticResin.method_7972()));
            scene.idle(5);
            scene.world.modifyBlockEntity(util.grid.at(3, 1, 3), type, mct -> TransferUtil.insertItem((Storage)mct.getInventory(), (class_1799)masticResin.method_7972()));
            scene.idle(5);
            scene.world.modifyBlockEntity(util.grid.at(3, 1, 2), type, mct -> TransferUtil.insertItem((Storage)mct.getInventory(), (class_1799)masticResin.method_7972()));
            scene.idle(5);
            scene.world.modifyBlockEntity(util.grid.at(3, 1, 1), type, mct -> TransferUtil.insertItem((Storage)mct.getInventory(), (class_1799)masticResin.method_7972()));
            scene.idle(70);
            scene.rotateCameraY(-60.0f);
            scene.idle(30);
            scene.overlay.showText(120).attachKeyFrame().placeNearTarget().text("red_mastic_resin_result").pointAt(util.vector.centerOf(3, 1, 4));
            scene.idle(140);
            scene.overlay.showText(120).attachKeyFrame().placeNearTarget().text("mastic_resin_recoloured").pointAt(util.vector.centerOf(3, 1, 4));
            scene.idle(140);
            scene.overlay.showText(60).placeNearTarget().text("mastic_resin_colour_wheel").pointAt(util.vector.centerOf(3, 1, 4));
            scene.idle(80);
            scene.markAsFinished();
        }

        public static void masticPaste(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("mastic_paste", "mastic_paste");
            scene.configureBasePlate(0, 0, 5);
            scene.showBasePlate();
            scene.world.showSection(util.select.fromTo(4, 0, 5, 0, 0, 5), class_2350.field_11043);
            scene.idle(10);
            scene.world.showSection(util.select.fromTo(0, 1, 3, 4, 4, 5), class_2350.field_11043);
            scene.idle(10);
            class_1799 redMasticResin = new class_1799(GarnishedItems.MASTIC_RESIN_RED);
            class_1799 redMasticPaste = new class_1799(GarnishedItems.MASTIC_PASTE_RED);
            scene.overlay.showText(120).attachKeyFrame().placeNearTarget().text("mastic_paste_creation").pointAt(util.vector.centerOf(2, 3, 3));
            scene.idle(60);
            ElementLink redMasticResinEntity = scene.world.createItemOnBelt(util.grid.at(4, 1, 3), class_2350.field_11035, redMasticResin);
            scene.idle(30);
            scene.world.stallBeltItem(redMasticResinEntity, true);
            scene.idle(5);
            Class<MechanicalPressBlockEntity> type = MechanicalPressBlockEntity.class;
            scene.world.modifyBlockEntity(util.grid.at(2, 3, 3), type, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BELT));
            scene.idle(30);
            scene.world.modifyBlockEntity(util.grid.at(2, 3, 3), type, pte -> pte.getPressingBehaviour().makePressingParticleEffect(util.grid.at(2, 2, 3).method_10074().method_46558().method_1031(0.0, 0.5, 0.0), redMasticResin));
            scene.world.removeItemsFromBelt(util.grid.at(2, 3, 3).method_10087(2));
            redMasticResinEntity = scene.world.createItemOnBelt(util.grid.at(2, 3, 3).method_10087(2), class_2350.field_11036, redMasticPaste);
            scene.world.stallBeltItem(redMasticResinEntity, true);
            scene.idle(15);
            scene.world.stallBeltItem(redMasticResinEntity, false);
            scene.idle(60);
            class_1799 redMasticResinBlock = new class_1799(GarnishedBlocks.RED_MASTIC_BLOCK);
            scene.world.showSection(util.select.fromTo(0, 1, 0, 4, 4, 2), class_2350.field_11035);
            scene.idle(30);
            scene.overlay.showText(120).attachKeyFrame().placeNearTarget().text("mastic_block").pointAt(util.vector.of(2.0, 3.5, 1.0));
            scene.idle(10);
            scene.overlay.showControls(new InputWindowElement(util.vector.topOf(util.grid.at(2, 2, 1)), Pointing.RIGHT).withItem(redMasticPaste), 30);
            scene.idle(30);
            Class<MechanicalPressBlockEntity> type1 = MechanicalPressBlockEntity.class;
            scene.world.modifyBlockEntity(util.grid.at(2, 4, 1), type1, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BASIN));
            scene.world.createItemOnBeltLike(util.grid.at(2, 2, 1), class_2350.field_11036, redMasticPaste);
            scene.idle(80);
            scene.overlay.showText(60).attachKeyFrame().placeNearTarget().text("mastic_block_result").pointAt(util.vector.centerOf(1, 2, 1));
            scene.idle(10);
            scene.world.modifyBlockEntityNBT(util.select.position(util.grid.at(2, 2, 1)), BasinBlockEntity.class, nbt -> nbt.method_10566("VisualizedItems", (class_2520)NBTHelper.writeCompoundList((Iterable)ImmutableList.of((Object)IntAttached.with((int)1, (Object)redMasticResinBlock)), ia -> (class_2487)((class_1799)ia.getValue()).serializeNBT())));
            scene.idle(4);
            scene.world.createItemOnBeltLike(util.grid.at(1, 1, 1), class_2350.field_11036, redMasticResinBlock);
            scene.idle(60);
            scene.markAsFinished();
        }

        public static void masticFluid(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("mastic_fluid", "mastic_fluid");
            scene.configureBasePlate(0, 0, 5);
            scene.showBasePlate();
            scene.world.showSection(util.select.fromTo(4, 0, 5, 0, 0, 5), class_2350.field_11043);
            scene.idle(10);
            scene.world.showSection(util.select.fromTo(1, 1, 3, 4, 4, 5), class_2350.field_11043);
            scene.idle(10);
            class_1799 redMasticResinBlock = new class_1799(GarnishedBlocks.RED_MASTIC_BLOCK);
            scene.overlay.showControls(new InputWindowElement(util.vector.topOf(util.grid.at(3, 2, 3)), Pointing.RIGHT).withItem(redMasticResinBlock), 30);
            scene.idle(20);
            scene.overlay.showText(60).attachKeyFrame().placeNearTarget().text("mastic_fluid_input").pointAt(util.vector.of(3.0, 3.0, 3.0));
            scene.idle(80);
            Class<MechanicalMixerBlockEntity> type = MechanicalMixerBlockEntity.class;
            scene.world.modifyBlockEntity(util.grid.at(3, 4, 3), type, MechanicalMixerBlockEntity::startProcessingBasin);
            scene.world.createItemOnBeltLike(util.grid.at(3, 2, 3), class_2350.field_11036, redMasticResinBlock);
            scene.idle(15);
            scene.world.modifyBlockEntity(util.grid.at(1, 1, 3), FluidTankBlockEntity.class, be -> TransferUtil.insertFluid((Storage)be.getTankInventory(), (FluidStack)ScenesAndInteractions.fluid(((SimpleFlowableFluid.Flowing)GarnishedFluids.RED_MASTIC_RESIN.get()).method_15751(), 20250)));
            scene.world.modifyBlockEntity(util.grid.at(3, 4, 3), type, MechanicalMixerBlockEntity::startProcessingBasin);
            scene.world.createItemOnBeltLike(util.grid.at(3, 2, 3), class_2350.field_11036, redMasticResinBlock);
            scene.idle(15);
            scene.world.modifyBlockEntity(util.grid.at(1, 1, 3), FluidTankBlockEntity.class, be -> TransferUtil.insertFluid((Storage)be.getTankInventory(), (FluidStack)ScenesAndInteractions.fluid(((SimpleFlowableFluid.Flowing)GarnishedFluids.RED_MASTIC_RESIN.get()).method_15751(), 40500)));
            scene.world.modifyBlockEntity(util.grid.at(3, 4, 3), type, MechanicalMixerBlockEntity::startProcessingBasin);
            scene.world.createItemOnBeltLike(util.grid.at(3, 2, 3), class_2350.field_11036, redMasticResinBlock);
            scene.idle(15);
            scene.world.modifyBlockEntity(util.grid.at(1, 1, 3), FluidTankBlockEntity.class, be -> TransferUtil.insertFluid((Storage)be.getTankInventory(), (FluidStack)ScenesAndInteractions.fluid(((SimpleFlowableFluid.Flowing)GarnishedFluids.RED_MASTIC_RESIN.get()).method_15751(), 60750)));
            scene.world.modifyBlockEntity(util.grid.at(3, 4, 3), type, MechanicalMixerBlockEntity::startProcessingBasin);
            scene.world.createItemOnBeltLike(util.grid.at(3, 2, 3), class_2350.field_11036, redMasticResinBlock);
            scene.idle(15);
            scene.world.modifyBlockEntity(util.grid.at(1, 1, 3), FluidTankBlockEntity.class, be -> TransferUtil.insertFluid((Storage)be.getTankInventory(), (FluidStack)ScenesAndInteractions.fluid(((SimpleFlowableFluid.Flowing)GarnishedFluids.RED_MASTIC_RESIN.get()).method_15751(), 81000)));
            scene.world.modifyBlockEntity(util.grid.at(3, 4, 3), type, MechanicalMixerBlockEntity::startProcessingBasin);
            scene.world.createItemOnBeltLike(util.grid.at(3, 2, 3), class_2350.field_11036, redMasticResinBlock);
            scene.idle(15);
            scene.world.modifyBlockEntity(util.grid.at(1, 1, 3), FluidTankBlockEntity.class, be -> TransferUtil.insertFluid((Storage)be.getTankInventory(), (FluidStack)ScenesAndInteractions.fluid(((SimpleFlowableFluid.Flowing)GarnishedFluids.RED_MASTIC_RESIN.get()).method_15751(), 101250)));
            scene.idle(20);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("mastic_fluid_result").pointAt(util.vector.of(1.0, 2.0, 3.0));
            scene.idle(120);
            scene.world.showSection(util.select.fromTo(1, 1, 1, 4, 1, 1), class_2350.field_11035);
            scene.idle(10);
            scene.overlay.showText(120).attachKeyFrame().placeNearTarget().text("mastic_resin_interaction_basics").pointAt(util.vector.of(2.0, 1.5, 1.0));
            scene.idle(160);
            scene.markAsFinished();
        }

        public static void createStoneInteractions(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("mastic_resin_create_stone", "mastic_resin_create_stone");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.fromTo(1, 1, 1, 4, 1, 1), class_2350.field_11043);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("red_fluid_crimsite").pointAt(util.vector.of(2.0, 1.5, 1.0));
            scene.idle(90);
            scene.world.showSection(util.select.fromTo(1, 1, 2, 4, 1, 2), class_2350.field_11043);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("blue_fluid_asurine").pointAt(util.vector.of(2.0, 1.5, 2.0));
            scene.idle(90);
            scene.world.showSection(util.select.fromTo(1, 1, 3, 4, 1, 3), class_2350.field_11043);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("green_fluid_veridium").pointAt(util.vector.of(2.0, 1.5, 3.0));
            scene.idle(90);
            scene.markAsFinished();
        }

        public static void vanillaStoneInteractions(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("mastic_resin_vanilla_stone", "mastic_resin_vanilla_stone");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.fromTo(1, 1, 1, 4, 1, 1), class_2350.field_11043);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("regular_fluid_tuff").pointAt(util.vector.of(2.0, 1.5, 1.0));
            scene.idle(90);
            scene.world.showSection(util.select.fromTo(1, 1, 2, 4, 1, 2), class_2350.field_11043);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("orange_fluid_terracotta").pointAt(util.vector.of(2.0, 1.5, 2.0));
            scene.idle(90);
            scene.markAsFinished();
        }

        public static void garnishedStoneInteractions(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("mastic_resin_garnished_stone", "mastic_resin_garnished_stone");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.fromTo(1, 1, 1, 4, 1, 1), class_2350.field_11043);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("yellow_fluid_carnotite").pointAt(util.vector.of(2.0, 1.5, 1.0));
            scene.idle(90);
            scene.world.showSection(util.select.fromTo(1, 1, 2, 4, 1, 2), class_2350.field_11043);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("purple_fluid_abyssal_stone").pointAt(util.vector.of(2.0, 1.5, 2.0));
            scene.idle(90);
            scene.markAsFinished();
        }

        public static void crackedNuts(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("cracked_nuts", "cracked_nuts");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.fromTo(1, 1, 4, 4, 1, 3), class_2350.field_11033);
            scene.world.showSection(util.select.fromTo(4, 1, 0, 3, 1, 0), class_2350.field_11033);
            scene.idle(3);
            scene.world.showSection(util.select.position(2, 1, 2), class_2350.field_11033);
            scene.idle(15);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("cracked_nut_plant").pointAt(util.vector.of(2.0, 1.5, 2.0));
            scene.idle(100);
            scene.markAsFinished();
        }

        public static void grownNutTree(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("nut_tree", "nut_tree");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(10);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("nut_tree_worldgen").pointAt(util.vector.topOf(1, 1, 1));
            scene.idle(90);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("nut_leaves").pointAt(util.vector.of(2.0, 4.0, 0.0));
            scene.idle(90);
            scene.world.hideSection(util.select.fromTo(0, 2, 0, 4, 6, 4), class_2350.field_11036);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("nut_wood").pointAt(util.vector.of(2.0, 1.5, 2.0));
            scene.idle(90);
            scene.markAsFinished();
        }

        public static void millingNuts(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("milling_nuts", "milling_nuts");
            scene.configureBasePlate(0, 0, 5);
            scene.showBasePlate();
            scene.idle(5);
            scene.world.showSection(util.select.position(3, 0, 5), class_2350.field_11033);
            scene.world.showSection(util.select.position(4, 1, 5), class_2350.field_11033);
            scene.idle(10);
            scene.world.showSection(util.select.fromTo(0, 1, 2, 4, 2, 4), class_2350.field_11043);
            scene.idle(5);
            scene.world.showSection(util.select.fromTo(0, 1, 1, 4, 2, 1), class_2350.field_11035);
            scene.idle(10);
            class_1799 itemStack = new class_1799(GarnishedItems.UNGARNISHED_WALNUT);
            class_243 entitySpawn = util.vector.topOf(util.grid.at(4, 2, 2).method_10086(3));
            class_1799 crackedWalnut = new class_1799(GarnishedItems.CRACKED_WALNUT);
            ElementLink entity1 = scene.world.createItemEntity(entitySpawn, util.vector.of(0.0, 0.2, 0.0), itemStack);
            scene.idle(18);
            scene.world.modifyEntity(entity1, class_1297::method_31472);
            scene.world.modifyBlockEntity(util.grid.at(4, 2, 2), MillstoneBlockEntity.class, ms -> ms.inputInv.setStackInSlot(0, itemStack));
            scene.idle(50);
            scene.world.modifyBlockEntity(util.grid.at(4, 2, 2), MillstoneBlockEntity.class, ms -> ms.inputInv.setStackInSlot(0, class_1799.field_8037));
            scene.idle(5);
            ElementLink entity2 = scene.world.createItemOnBelt(util.grid.at(4, 1, 1), class_2350.field_11035, crackedWalnut);
            scene.idle(15);
            scene.world.stallBeltItem(entity2, true);
            scene.overlay.showText(80).placeNearTarget().text("cracked_nuts_additional_value").pointAt(util.vector.topOf(3, 1, 1));
            scene.idle(90);
            scene.world.stallBeltItem(entity2, false);
            scene.idle(40);
            scene.markAsFinished();
        }

        public static void nutWood(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("nut_wood", "nut_wood");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(10);
            scene.markAsFinished();
        }

        public static void hatchets(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("hatchets", "hatchets");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(10);
            class_1799 itemStack = new class_1799(GarnishedItems.IRON_HATCHET);
            class_243 entitySpawn = util.vector.topOf(util.grid.at(2, 1, 2).method_10086(3));
            ElementLink entity = scene.world.createItemEntity(entitySpawn, util.vector.of(0.0, 0.0, 0.0), itemStack);
            scene.idle(5);
            scene.overlay.showText(100).attachKeyFrame().placeNearTarget().text("hatchet_desc").pointAt(util.vector.topOf(2, 1, 2));
            scene.idle(110);
            scene.world.modifyEntity(entity, class_1297::method_31472);
            scene.markAsFinished();
        }

        public static void hatchetAttacking(SceneBuilder scene, SceneBuildingUtil util) {
            Class<DeployerBlockEntity> teType = DeployerBlockEntity.class;
            class_1799 netheriteHatchet = new class_1799(GarnishedItems.NETHERITE_HATCHET);
            netheriteHatchet.method_7978((class_1887)GarnishedEnchantments.RAVAGING.get(), 0);
            scene.world.modifyBlockEntityNBT(util.select.position(3, 2, 3), teType, nbt -> nbt.method_10566("HeldItem", netheriteHatchet.serializeNBT()));
            scene.title("hatchet_attacking", "hatchet_attacking");
            scene.configureBasePlate(0, 0, 5);
            scene.showBasePlate();
            scene.world.showSection(util.select.layer(0), class_2350.field_11036);
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11035);
            scene.idle(10);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("hatchet_enchantment_ravaging").pointAt(util.vector.centerOf(3, 2, 3));
            scene.idle(100);
            ElementLink blaze = scene.world.createEntity(w -> {
                class_1545 entity = (class_1545)class_1299.field_6099.method_5883(w);
                class_243 p = util.vector.topOf(util.grid.at(1, 1, 3));
                entity.method_5814(p.field_1352, p.field_1351, p.field_1350);
                entity.field_6014 = p.field_1352;
                entity.field_6036 = p.field_1351;
                entity.field_5969 = p.field_1350;
                entity.field_5982 = 210.0f;
                entity.method_36456(210.0f);
                entity.field_6259 = 210.0f;
                entity.field_6241 = 210.0f;
                return entity;
            });
            scene.idle(30);
            scene.world.moveDeployer(util.grid.at(3, 2, 3), 1.0f, 25);
            scene.idle(26);
            scene.world.modifyEntity(blaze, entity -> entity.method_5879(0.0f));
            scene.idle(7);
            scene.world.modifyEntity(blaze, class_1297::method_31472);
            class_1799 itemStack = new class_1799(GarnishedItems.ENFLAMED_MANDIBLE);
            ElementLink itemEntity = scene.world.createItemEntity(util.vector.centerOf(1, 2, 3), util.vector.of(0.0, 0.2, 0.0), itemStack);
            scene.idle(5);
            scene.world.moveDeployer(util.grid.at(3, 2, 3), -1.0f, 25);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("modified_drops_ravaging").pointAt(util.vector.centerOf(1, 2, 3));
            scene.idle(100);
            scene.world.modifyEntity(itemEntity, class_1297::method_31472);
            class_243 frontVec = util.vector.blockSurface(util.grid.at(3, 2, 3), class_2350.field_11039).method_1031(-0.125, 0.0, 0.0);
            class_1799 netheriteHatchet1 = new class_1799(GarnishedItems.NETHERITE_HATCHET);
            netheriteHatchet1.method_7978((class_1887)GarnishedEnchantments.SALVAGING.get(), 1);
            scene.overlay.showControls(new InputWindowElement(frontVec, Pointing.DOWN).rightClick().withItem(class_1802.field_8598.method_7854()), 40);
            scene.world.modifyBlockEntityNBT(util.select.position(3, 2, 3), teType, nbt -> nbt.method_10566("HeldItem", netheriteHatchet.serializeNBT()));
            scene.idle(10);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("hatchet_enchantment_salvaging").pointAt(util.vector.centerOf(3, 2, 3));
            scene.idle(100);
            ElementLink squid = scene.world.createEntity(w -> {
                class_1477 entity = (class_1477)class_1299.field_6114.method_5883(w);
                class_243 p = util.vector.topOf(util.grid.at(1, 1, 3));
                entity.method_5814(p.field_1352, p.field_1351, p.field_1350);
                entity.field_6014 = p.field_1352;
                entity.field_6036 = p.field_1351;
                entity.field_5969 = p.field_1350;
                entity.field_5982 = 210.0f;
                entity.method_36456(210.0f);
                entity.field_6259 = 210.0f;
                entity.field_6241 = 210.0f;
                return entity;
            });
            scene.idle(30);
            scene.world.moveDeployer(util.grid.at(3, 2, 3), 1.0f, 25);
            scene.idle(26);
            scene.world.modifyEntity(squid, entity -> entity.method_5879(0.0f));
            scene.idle(7);
            scene.world.modifyEntity(squid, class_1297::method_31472);
            class_1799 itemStack1 = new class_1799((class_1935)class_1802.field_8794, 7);
            ElementLink itemEntity1 = scene.world.createItemEntity(util.vector.centerOf(1, 2, 3), util.vector.of(0.0, 0.2, 0.0), itemStack1);
            scene.idle(5);
            scene.world.moveDeployer(util.grid.at(3, 2, 3), -1.0f, 25);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("modified_drops_salvaging").pointAt(util.vector.centerOf(1, 2, 3));
            scene.idle(100);
            scene.world.modifyEntity(itemEntity, class_1297::method_31472);
            scene.markAsFinished();
        }

        public static void integratedHatchets(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("integrated_hatchets", "integrated_hatchets");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(10);
            class_1799 roseGoldHatchet = new class_1799(GarnishedItems.ROSE_GOLD_HATCHET);
            class_1799 wardenHatchet = new class_1799(GarnishedItems.WARDEN_HATCHET);
            class_1799 gildedNetheriteHatchet = new class_1799(GarnishedItems.GILDED_NETHERITE_HATCHET);
            class_243 spawn = util.vector.topOf(util.grid.at(3, 1, 1).method_10086(3));
            class_243 spawn1 = util.vector.topOf(util.grid.at(2, 1, 3).method_10086(4));
            class_243 spawn2 = util.vector.topOf(util.grid.at(3, 1, 3).method_10086(2));
            ElementLink entity = scene.world.createItemEntity(spawn, util.vector.of(0.0, 0.0, 0.0), roseGoldHatchet);
            scene.idle(5);
            ElementLink entity1 = scene.world.createItemEntity(spawn1, util.vector.of(0.0, 0.0, 0.0), wardenHatchet);
            scene.idle(5);
            ElementLink entity2 = scene.world.createItemEntity(spawn2, util.vector.of(0.0, 0.0, 0.0), gildedNetheriteHatchet);
            scene.idle(15);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("integrated_hatchets_basics").pointAt(util.vector.centerOf(2, 1, 3));
            scene.idle(90);
            String[] mods = new String[]{"additional_additions", "deeper_darker", "stuff_and_additions", "mythic_upgrades"};
            scene.overlay.showText(160).attachKeyFrame().independent(40).placeNearTarget().text("integrated_hatchets_mods");
            int y = 60;
            for (String s : mods) {
                scene.idle(15);
                scene.overlay.showText(100).colored(PonderPalette.MEDIUM).placeNearTarget().independent(y).text(s);
                y += 20;
            }
            scene.idle(110);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("integrated_hatchets_abilities").pointAt(util.vector.of(2.0, 1.0, 3.0));
            scene.idle(90);
            scene.markAsFinished();
        }

        public static void brittleDust(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("brittle_dust", "brittle_dust");
            scene.configureBasePlate(0, 0, 5);
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.fromTo(2, 1, 0, 4, 2, 2), class_2350.field_11039);
            scene.idle(10);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("brittle_dust_ingredients").pointAt(util.vector.topOf(3, 1, 1));
            scene.idle(90);
            scene.world.hideSection(util.select.fromTo(2, 1, 0, 4, 2, 2), class_2350.field_11034);
            scene.idle(10);
            scene.world.showSection(util.select.position(3, 0, 5), class_2350.field_11033);
            scene.world.showSection(util.select.fromTo(0, 1, 0, 1, 2, 4), class_2350.field_11033);
            scene.world.showSection(util.select.fromTo(2, 1, 2, 2, 2, 4), class_2350.field_11033);
            scene.idle(10);
            class_243 spawnPosition = util.vector.topOf(util.grid.at(1, 2, 4).method_10086(3));
            class_1799 scorchiaStack = new class_1799((class_1935)((class_2248)AllPaletteStoneTypes.SCORCHIA.getBaseBlock().get()).method_8389());
            class_1799 brittleDustStack = new class_1799(GarnishedItems.BRITTLE_DUST, 2);
            ElementLink entity = scene.world.createItemEntity(spawnPosition, util.vector.of(0.0, 0.0, 0.0), scorchiaStack);
            scene.idle(26);
            scene.world.modifyEntity(entity, class_1297::method_31472);
            scene.idle(10);
            EmitParticlesInstruction.Emitter blockSpace = EmitParticlesInstruction.Emitter.withinBlockSpace((class_2394)new class_2392(class_2398.field_11218, scorchiaStack), (class_243)util.vector.of(0.0, 0.0, 0.0));
            scene.effects.emitParticles(util.vector.centerOf(util.grid.at(1, 2, 3)).method_1031(0.0, -0.2, 0.0), blockSpace, 3.0f, 40);
            scene.idle(10);
            ElementLink entity1 = scene.world.createItemOnBelt(util.grid.at(1, 1, 2), class_2350.field_11035, brittleDustStack);
            scene.idle(20);
            scene.world.stallBeltItem(entity1, true);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("brittle_dust_result").pointAt(util.vector.topOf(util.grid.at(1, 1, 1)));
            scene.idle(90);
            scene.world.stallBeltItem(entity1, false);
            scene.idle(40);
            scene.markAsFinished();
        }

        public static void senileDust(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("senile_dust", "senile_dust");
            scene.configureBasePlate(0, 0, 5);
            scene.showBasePlate();
            scene.idle(5);
            scene.world.showSection(util.select.position(5, 0, 1), class_2350.field_11033);
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(10);
            class_1799 stack = new class_1799(GarnishedItems.BRITTLE_DUST);
            class_1799 output = new class_1799(GarnishedItems.SENILE_DUST);
            ElementLink beltStack = scene.world.createItemOnBelt(util.grid.at(2, 1, 1), class_2350.field_11043, stack);
            scene.idle(18);
            scene.world.stallBeltItem(beltStack, true);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("senile_dust_creation").pointAt(util.vector.centerOf(2, 1, 2));
            scene.idle(30);
            scene.effects.emitParticles(util.vector.of(2.0, 2.0, 2.0), EmitParticlesInstruction.Emitter.simple((class_2394)class_2398.field_22246, (class_243)class_243.field_1353), 0.5f, 25);
            scene.idle(24);
            scene.world.changeBeltItemTo(beltStack, output);
            scene.idle(36);
            scene.world.stallBeltItem(beltStack, false);
            scene.idle(30);
            scene.markAsFinished();
        }

        public static void senileSpread(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("senile_spread", "senile_spread");
            class_1799 senileSpread = new class_1799(GarnishedItems.SENILE_SPREAD);
            class_1799 senileDust = new class_1799(GarnishedItems.SENILE_DUST);
            class_1799 boneMeal = new class_1799((class_1935)class_1802.field_8324);
            Class<DeployerBlockEntity> teType = DeployerBlockEntity.class;
            scene.world.modifyBlockEntityNBT(util.select.position(3, 3, 2), teType, nbt -> nbt.method_10566("HeldItem", senileDust.serializeNBT()));
            scene.configureBasePlate(0, 0, 5);
            scene.showBasePlate();
            scene.idle(5);
            scene.world.showSection(util.select.position(5, 0, 1), class_2350.field_11033);
            scene.world.showSection(util.select.position(5, 1, 2), class_2350.field_11033);
            scene.idle(10);
            scene.world.showSection(util.select.fromTo(3, 1, 0, 4, 4, 4), class_2350.field_11043);
            scene.idle(40);
            ElementLink beltItem = scene.world.createItemOnBelt(util.grid.at(3, 1, 0), class_2350.field_11043, boneMeal);
            scene.idle(36);
            scene.world.stallBeltItem(beltItem, true);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("senile_spread_creation").pointAt(util.vector.of(3.0, 1.5, 2.0));
            scene.idle(90);
            scene.world.moveDeployer(util.grid.at(3, 3, 2), 1.0f, 25);
            scene.idle(27);
            scene.world.changeBeltItemTo(beltItem, senileSpread);
            scene.idle(12);
            scene.world.moveDeployer(util.grid.at(3, 3, 2), -1.0f, 25);
            scene.idle(32);
            scene.world.showSection(util.select.fromTo(0, 1, 0, 2, 1, 4), class_2350.field_11033);
            scene.idle(20);
            scene.overlay.showControls(new InputWindowElement(util.vector.topOf(1, 1, 1), Pointing.DOWN).withItem(senileSpread).rightClick(), 30);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("senile_spread_usage").pointAt(util.vector.of(0.0, 2.0, 2.0));
            scene.idle(90);
            scene.world.showIndependentSectionImmediately(util.select.fromTo(0, 2, 0, 1, 2, 4));
            scene.idle(30);
            scene.markAsFinished();
        }

        public static void bottledPeanutOil(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("peanut_oil_item", "peanut_oil_item");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(10);
            class_1799 peanutOil = new class_1799(GarnishedItems.BOTTLED_PEANUT_OIL);
            ElementLink entity = scene.world.createItemEntity(util.vector.topOf(util.grid.at(3, 1, 1).method_10086(3)), util.vector.of(0.0, (double)0.2f, 0.0), peanutOil);
            scene.idle(10);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("peanut_oil_bottle").pointAt(util.vector.of(3.0, 1.5, 1.0));
            scene.idle(90);
            scene.markAsFinished();
        }

        public static void basicFluidInteractions(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("basic_fluid_interactions", "basic_fluid_interactions");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.fromTo(1, 1, 1, 4, 1, 1), class_2350.field_11043);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("garnish_fluid_calcite").pointAt(util.vector.of(2.0, 1.5, 1.0));
            scene.idle(90);
            scene.world.showSection(util.select.fromTo(1, 1, 2, 4, 1, 2), class_2350.field_11043);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("apple_cider_fluid_ochrum").pointAt(util.vector.of(2.0, 1.5, 2.0));
            scene.idle(90);
            scene.world.showSection(util.select.fromTo(1, 1, 3, 4, 1, 3), class_2350.field_11043);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("peanut_oil_fluid_dripstone").pointAt(util.vector.of(2.0, 1.5, 3.0));
            scene.idle(90);
            scene.world.showSection(util.select.fromTo(1, 1, 4, 4, 1, 4), class_2350.field_11043);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("cashew_mixture_fluid_end_stone").pointAt(util.vector.of(2.0, 1.5, 4.0));
            scene.idle(90);
            scene.markAsFinished();
        }

        public static void additionalHeatSources(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("heat_sources", "heat_sources");
            scene.configureBasePlate(0, 0, 5);
            scene.showBasePlate();
            scene.idle(5);
            scene.world.showSection(util.select.position(1, 0, 5), class_2350.field_11033);
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(10);
            class_1799 peanutOilBucket = new class_1799((class_1935)((SimpleFlowableFluid.Flowing)GarnishedFluids.PEANUT_OIL.get()).method_15774());
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("peanut_oil_heat_source").pointAt(util.vector.of(2.0, 1.5, 2.0));
            scene.idle(120);
            scene.overlay.showControls(new InputWindowElement(util.vector.topOf(2, 1, 2), Pointing.RIGHT).rightClick().withItem(peanutOilBucket), 30);
            scene.idle(15);
            scene.world.modifyBlock(util.grid.at(2, 1, 2), s -> (class_2680)s.method_11657((class_2769)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.SEETHING), false);
            scene.idle(40);
            scene.world.modifyBlock(util.grid.at(2, 1, 2), s -> (class_2680)s.method_11657((class_2769)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.SMOULDERING), true);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("raw_peanut_heat_source").pointAt(util.vector.of(2.0, 1.5, 2.0));
            scene.idle(120);
            scene.overlay.showControls(new InputWindowElement(util.vector.topOf(2, 1, 2), Pointing.RIGHT).rightClick().withItem(new class_1799(GarnishedItems.UNGARNISHED_BUHG)), 30);
            scene.idle(15);
            scene.world.modifyBlock(util.grid.at(2, 1, 2), s -> (class_2680)s.method_11657((class_2769)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.KINDLED), false);
            scene.idle(30);
            scene.markAsFinished();
        }

        public static void bottledAppleCider(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("apple_cider_item", "apple_cider_item");
            scene.showBasePlate();
            scene.idle(10);
            class_1799 appleCider = new class_1799(GarnishedItems.APPLE_CIDER);
            ElementLink entity = scene.world.createItemEntity(util.vector.topOf(util.grid.at(2, 1, 1).method_10086(2)), util.vector.of(0.0, (double)0.2f, 0.0), appleCider);
            scene.idle(10);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("bottled_apple_cider").pointAt(util.vector.of(2.0, 1.5, 1.0));
            scene.idle(90);
            scene.markAsFinished();
        }

        public static void appleCiderCreation(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("apple_cider_creation", "apple_cider_creation");
            scene.configureBasePlate(0, 0, 5);
            scene.showBasePlate();
            scene.idle(5);
            scene.world.showSection(util.select.position(1, 0, 5), class_2350.field_11033);
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(10);
            class_1799 crackedMacadamia = new class_1799(GarnishedItems.CRACKED_MACADAMIA);
            class_1799 apple = new class_1799((class_1935)class_1802.field_8279);
            class_1799 garnishCompound = new class_1799(GarnishedItems.GARNISH_COMPOUND);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("apple_cider_ingredients").pointAt(util.vector.of(3.0, 2.5, 3.0));
            scene.idle(100);
            scene.overlay.showControls(new InputWindowElement(util.vector.of(3.0, 2.0, 3.0), Pointing.DOWN).withItem(crackedMacadamia), 20);
            scene.idle(30);
            scene.overlay.showControls(new InputWindowElement(util.vector.of(3.0, 2.0, 3.0), Pointing.DOWN).withItem(apple), 20);
            scene.idle(30);
            scene.overlay.showControls(new InputWindowElement(util.vector.of(3.0, 2.0, 3.0), Pointing.DOWN).withItem(apple), 20);
            scene.idle(30);
            scene.overlay.showControls(new InputWindowElement(util.vector.of(3.0, 2.0, 3.0), Pointing.DOWN).withItem(garnishCompound), 20);
            scene.idle(40);
            Class<MechanicalMixerBlockEntity> type = MechanicalMixerBlockEntity.class;
            scene.world.modifyBlockEntity(util.grid.at(3, 4, 3), type, MechanicalMixerBlockEntity::startProcessingBasin);
            scene.world.createItemOnBeltLike(util.grid.at(3, 2, 3), class_2350.field_11036, crackedMacadamia);
            scene.world.createItemOnBeltLike(util.grid.at(3, 2, 3), class_2350.field_11036, apple);
            scene.world.createItemOnBeltLike(util.grid.at(3, 2, 3), class_2350.field_11036, apple);
            scene.world.createItemOnBeltLike(util.grid.at(3, 2, 3), class_2350.field_11036, garnishCompound);
            scene.idle(15);
            scene.world.modifyBlockEntity(util.grid.at(0, 1, 3), FluidTankBlockEntity.class, be -> TransferUtil.insertFluid((Storage)be.getTankInventory(), (FluidStack)ScenesAndInteractions.fluid(((SimpleFlowableFluid.Flowing)GarnishedFluids.APPLE_CIDER.get()).method_15751(), 20250)));
            scene.world.modifyBlockEntity(util.grid.at(3, 4, 3), type, MechanicalMixerBlockEntity::startProcessingBasin);
            scene.idle(15);
            scene.world.modifyBlockEntity(util.grid.at(0, 1, 3), FluidTankBlockEntity.class, be -> TransferUtil.insertFluid((Storage)be.getTankInventory(), (FluidStack)ScenesAndInteractions.fluid(((SimpleFlowableFluid.Flowing)GarnishedFluids.APPLE_CIDER.get()).method_15751(), 40500)));
            scene.world.modifyBlockEntity(util.grid.at(3, 4, 3), type, MechanicalMixerBlockEntity::startProcessingBasin);
            scene.idle(15);
            scene.world.modifyBlockEntity(util.grid.at(0, 1, 3), FluidTankBlockEntity.class, be -> TransferUtil.insertFluid((Storage)be.getTankInventory(), (FluidStack)ScenesAndInteractions.fluid(((SimpleFlowableFluid.Flowing)GarnishedFluids.APPLE_CIDER.get()).method_15751(), 60750)));
            scene.world.modifyBlockEntity(util.grid.at(3, 4, 3), type, MechanicalMixerBlockEntity::startProcessingBasin);
            scene.idle(15);
            scene.world.modifyBlockEntity(util.grid.at(0, 1, 3), FluidTankBlockEntity.class, be -> TransferUtil.insertFluid((Storage)be.getTankInventory(), (FluidStack)ScenesAndInteractions.fluid(((SimpleFlowableFluid.Flowing)GarnishedFluids.APPLE_CIDER.get()).method_15751(), 81000)));
            scene.world.modifyBlockEntity(util.grid.at(3, 4, 3), type, MechanicalMixerBlockEntity::startProcessingBasin);
            scene.idle(15);
            scene.world.modifyBlockEntity(util.grid.at(0, 1, 3), FluidTankBlockEntity.class, be -> TransferUtil.insertFluid((Storage)be.getTankInventory(), (FluidStack)ScenesAndInteractions.fluid(((SimpleFlowableFluid.Flowing)GarnishedFluids.APPLE_CIDER.get()).method_15751(), 101250)));
            scene.idle(15);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("apple_cider_result").pointAt(util.vector.of(0.0, 1.5, 3.0));
            scene.markAsFinished();
        }

        public static void appleCiderMisc(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("apple_cider_misc", "apple_cider_misc");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(10);
            class_1799 cryptic = new class_1799(GarnishedItems.CRYPTIC_APPLE_CIDER);
            class_1799 bitter = new class_1799(GarnishedItems.BITTER_APPLE_CIDER);
            ElementLink entity = scene.world.createItemEntity(util.vector.topOf(util.grid.at(3, 2, 2).method_10086(2)), util.vector.of(0.0, (double)0.2f, 0.0), cryptic);
            scene.idle(5);
            ElementLink entity1 = scene.world.createItemEntity(util.vector.topOf(util.grid.at(1, 2, 2).method_10086(3)), util.vector.of(0.0, (double)0.1f, 0.0), bitter);
            scene.idle(5);
            scene.idle(10);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("cryptic_apple_cider").pointAt(util.vector.of(3.0, 2.5, 2.0));
            scene.idle(90);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("bitter_apple_cider").pointAt(util.vector.of(1.0, 2.5, 2.0));
            scene.idle(90);
            scene.markAsFinished();
        }

        public static void crushingFungus(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("crushing_fungus", "crushing_fungus");
            scene.configureBasePlate(0, 0, 5);
            scene.showBasePlate();
            scene.idle(5);
            scene.world.showSection(util.select.position(2, 0, 5), class_2350.field_11033);
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(10);
            class_1799 crimson = new class_1799((class_1935)class_1802.field_21987);
            class_1799 warped = new class_1799((class_1935)class_1802.field_21988);
            class_1799 sepia = new class_1799(GarnishedBlocks.SEPIA_FUNGUS);
            class_1799 shroomlight = new class_1799((class_1935)class_1802.field_22017);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("crushing_fungus_basics").pointAt(util.vector.of(1.5, 3.5, 2.0));
            scene.idle(90);
            ElementLink crimsonEntity = scene.world.createItemEntity(util.vector.topOf(util.grid.at(2, 3, 2).method_10086(2)), util.vector.of(0.0, 0.0, 0.0), crimson);
            scene.idle(24);
            scene.world.modifyEntity(crimsonEntity, class_1297::method_31472);
            EmitParticlesInstruction.Emitter blockSpace = EmitParticlesInstruction.Emitter.withinBlockSpace((class_2394)new class_2392(class_2398.field_11218, crimson), (class_243)util.vector.of(0.0, 0.0, 0.0));
            scene.effects.emitParticles(util.vector.centerOf(util.grid.at(2, 3, 2)).method_1031(0.0, -0.2, 0.0), blockSpace, 3.0f, 40);
            scene.idle(24);
            class_1799 crimson1 = new class_1799(GarnishedItems.CRUSHED_CRIMSON_FUNGUS);
            class_1799 warped1 = new class_1799(GarnishedItems.CRUSHED_WARPED_FUNGUS);
            class_1799 sepia1 = new class_1799(GarnishedItems.CRUSHED_SEPIA_FUNGUS);
            class_1799 shroomlight1 = new class_1799(GarnishedItems.CRUSHED_SHROOMLIGHT);
            ElementLink crushedCrimsonEntity = scene.world.createItemEntity(util.grid.at(2, 3, 2).method_46558().method_1031(0.0, -1.4, 0.0), util.vector.of(0.0, 0.0, 0.0), crimson1);
            scene.idle(4);
            scene.world.modifyEntity(crushedCrimsonEntity, class_1297::method_31472);
            scene.world.createItemOnBelt(util.grid.at(2, 1, 2), class_2350.field_11035, crimson1);
            scene.idle(50);
            scene.addKeyframe();
            ElementLink warpedEntity = scene.world.createItemEntity(util.vector.topOf(util.grid.at(2, 3, 2).method_10086(2)), util.vector.of(0.0, 0.0, 0.0), warped);
            scene.idle(24);
            scene.world.modifyEntity(warpedEntity, class_1297::method_31472);
            EmitParticlesInstruction.Emitter blockSpace1 = EmitParticlesInstruction.Emitter.withinBlockSpace((class_2394)new class_2392(class_2398.field_11218, warped), (class_243)util.vector.of(0.0, 0.0, 0.0));
            scene.effects.emitParticles(util.vector.centerOf(util.grid.at(2, 3, 2)).method_1031(0.0, -0.2, 0.0), blockSpace1, 3.0f, 40);
            scene.idle(24);
            ElementLink crushedWarpedEntity = scene.world.createItemEntity(util.grid.at(2, 3, 2).method_46558().method_1031(0.0, -1.4, 0.0), util.vector.of(0.0, 0.0, 0.0), warped1);
            scene.idle(4);
            scene.world.modifyEntity(crushedWarpedEntity, class_1297::method_31472);
            scene.world.createItemOnBelt(util.grid.at(2, 1, 2), class_2350.field_11035, warped1);
            scene.idle(50);
            scene.addKeyframe();
            ElementLink sepiaEntity = scene.world.createItemEntity(util.vector.topOf(util.grid.at(2, 3, 2).method_10086(2)), util.vector.of(0.0, 0.0, 0.0), sepia);
            scene.idle(24);
            scene.world.modifyEntity(sepiaEntity, class_1297::method_31472);
            EmitParticlesInstruction.Emitter blockSpace2 = EmitParticlesInstruction.Emitter.withinBlockSpace((class_2394)new class_2392(class_2398.field_11218, sepia), (class_243)util.vector.of(0.0, 0.0, 0.0));
            scene.effects.emitParticles(util.vector.centerOf(util.grid.at(2, 3, 2)).method_1031(0.0, -0.2, 0.0), blockSpace2, 3.0f, 40);
            scene.idle(24);
            ElementLink crushedSepiaEntity = scene.world.createItemEntity(util.grid.at(2, 3, 2).method_46558().method_1031(0.0, -1.4, 0.0), util.vector.of(0.0, 0.0, 0.0), sepia1);
            scene.idle(4);
            scene.world.modifyEntity(crushedSepiaEntity, class_1297::method_31472);
            scene.world.createItemOnBelt(util.grid.at(2, 1, 2), class_2350.field_11035, sepia1);
            scene.idle(50);
            scene.addKeyframe();
            ElementLink shroomlightEntity = scene.world.createItemEntity(util.vector.topOf(util.grid.at(2, 3, 2).method_10086(2)), util.vector.of(0.0, 0.0, 0.0), shroomlight);
            scene.idle(24);
            scene.world.modifyEntity(shroomlightEntity, class_1297::method_31472);
            EmitParticlesInstruction.Emitter blockSpace3 = EmitParticlesInstruction.Emitter.withinBlockSpace((class_2394)new class_2392(class_2398.field_11218, shroomlight), (class_243)util.vector.of(0.0, 0.0, 0.0));
            scene.effects.emitParticles(util.vector.centerOf(util.grid.at(2, 3, 2)).method_1031(0.0, -0.2, 0.0), blockSpace3, 3.0f, 40);
            scene.idle(24);
            ElementLink crushedShroomlightEntity = scene.world.createItemEntity(util.grid.at(2, 3, 2).method_46558().method_1031(0.0, -1.4, 0.0), util.vector.of(0.0, 0.0, 0.0), shroomlight1);
            scene.idle(4);
            scene.world.modifyEntity(crushedShroomlightEntity, class_1297::method_31472);
            scene.world.createItemOnBelt(util.grid.at(2, 1, 2), class_2350.field_11035, shroomlight1);
            scene.idle(50);
            scene.markAsFinished();
        }

        public static void cashewMixtureFluid(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("cashew_mixture", "cashew_mixture");
            scene.showBasePlate();
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(10);
            class_1799 fermentedCashewMixture = new class_1799(GarnishedItems.FERMENTED_CASHEW_MIXTURE);
            ElementLink entity = scene.world.createItemEntity(util.vector.centerOf(util.grid.at(3, 2, 2).method_10086(2)), util.vector.of(0.0, 0.2, 0.0), fermentedCashewMixture);
            scene.idle(5);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("fermented_cashew_mixture").pointAt(util.vector.centerOf(util.grid.at(3, 2, 2)));
            scene.idle(90);
            scene.markAsFinished();
        }

        public static void cashewSorbetScoopCreation(SceneBuilder scene, SceneBuildingUtil util) {
            scene.title("cashew_sorbet", "cashew_sorbet");
            scene.configureBasePlate(0, 0, 5);
            scene.showBasePlate();
            scene.idle(5);
            scene.world.showSection(util.select.position(2, 0, 5), class_2350.field_11033);
            scene.idle(10);
            scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
            scene.idle(10);
            class_1799 snowball = new class_1799((class_1935)class_1802.field_8543);
            class_1799 nut = new class_1799(GarnishedItems.CASHEW);
            scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(2, 2, 3), Pointing.RIGHT).withItem(snowball), 30);
            scene.idle(35);
            scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(2, 2, 3), Pointing.RIGHT).withItem(nut), 30);
            scene.idle(35);
            scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(2, 2, 3), Pointing.RIGHT).withItem(nut), 30);
            scene.idle(35);
            scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("cashew_sorbet_ingredients").pointAt(util.vector.centerOf(util.grid.at(2, 2, 3)));
            scene.idle(90);
            class_1799 cashewSorbetScoop = new class_1799(GarnishedItems.CASHEW_SORBET_SCOOP, 2);
            Class<MechanicalMixerBlockEntity> type = MechanicalMixerBlockEntity.class;
            scene.world.modifyBlockEntity(util.grid.at(2, 4, 3), type, MechanicalMixerBlockEntity::startProcessingBasin);
            scene.idle(78);
            ElementLink beltItem = scene.world.createItemOnBelt(util.grid.at(2, 1, 2), class_2350.field_11035, cashewSorbetScoop);
            scene.idle(30);
            scene.markAsFinished();
        }

        private static FluidStack fluid(class_3611 source, int mb) {
            return new FluidStack(source, (long)mb);
        }
    }

    public static class Tags {
        public static PonderTag RECENT_CHANGES = Tags.create("recent_changes").item(GarnishedItems.BUHG, true, false).defaultLang("recent_changes", "recent_changes_description").addToIndex();
        public static PonderTag KELP_RELATED = Tags.create("kelp_related").item(GarnishedItems.DRIED_VERMILION_KELP, true, false).defaultLang("kelp_entries", "kelp_entries_description").addToIndex();
        public static PonderTag MASTIC_RESIN = Tags.create("mastic_resin").item(GarnishedItems.MASTIC_RESIN, true, true).defaultLang("mastic_resin", "mastic_resin_description").addToIndex();
        public static PonderTag CRACKED_NUTS = Tags.create("cracked_nuts").item(GarnishedItems.CRACKED_WALNUT, true, false).defaultLang("cracked_nuts", "cracked_nuts_description").addToIndex();
        public static PonderTag HATCHETS = Tags.create("hatchets").item(GarnishedItems.IRON_HATCHET, true, true).defaultLang("hatchets", "hatchets_description").addToIndex();
        public static PonderTag CRUSHED_NETHER_INGREDIENTS = Tags.create("crushed_nether_ingredients").item(GarnishedItems.BRITTLE_DUST, true, true).defaultLang("crushed_nether_ingredients", "crushed_nether_ingredients_description").addToIndex();
        public static PonderTag FLUIDS = Tags.create("fluids").item(GarnishedItems.BOTTLED_PEANUT_OIL).defaultLang("fluids", "fluids_description").addToIndex();

        private static PonderTag create(String id) {
            return new PonderTag(CreateGarnished.asResource(id));
        }

        public static void fillPonderTags() {
            PonderRegistry.TAGS.forTag(RECENT_CHANGES).add(GarnishedBlocks.DULSE_KELP).add(GarnishedBlocks.DRIED_DULSE_KELP_BLOCK).add(GarnishedItems.DRIED_DULSE_KELP).add(GarnishedBlocks.VERMILION_KELP).add(GarnishedBlocks.DRIED_VERMILION_KELP_BLOCK).add(GarnishedItems.DRIED_VERMILION_KELP);
            PonderRegistry.TAGS.forTag(CRACKED_NUTS).add(GarnishedItems.CRACKED_WALNUT).add(GarnishedItems.CRACKED_ALMOND).add(GarnishedItems.CRACKED_BUHG).add(GarnishedItems.CRACKED_CASHEW).add(GarnishedItems.CRACKED_CHESTNUT).add(GarnishedItems.CRACKED_HAZELNUT).add(GarnishedItems.CRACKED_MACADAMIA).add(GarnishedItems.CRACKED_PECAN).add(GarnishedItems.CRACKED_PISTACHIO);
            PonderRegistry.TAGS.forTag(HATCHETS).add(GarnishedItems.WOODEN_HATCHET).add(GarnishedItems.STONE_HATCHET).add(GarnishedItems.IRON_HATCHET).add(GarnishedItems.GOLDEN_HATCHET).add(GarnishedItems.DIAMOND_HATCHET).add(GarnishedItems.NETHERITE_HATCHET).add(GarnishedItems.AMETRINE_HATCHET).add(GarnishedItems.AQUAMARINE_HATCHET).add(GarnishedItems.JADE_HATCHET).add(GarnishedItems.TOPAZ_HATCHET).add(GarnishedItems.GILDED_NETHERITE_HATCHET).add(GarnishedItems.ROSE_GOLD_HATCHET).add(GarnishedItems.RUBY_HATCHET).add(GarnishedItems.SAPPHIRE_HATCHET).add(GarnishedItems.WARDEN_HATCHET);
            PonderRegistry.TAGS.forTag(KELP_RELATED).add(GarnishedBlocks.DULSE_KELP).add(GarnishedBlocks.DRIED_DULSE_KELP_BLOCK).add(GarnishedItems.DRIED_DULSE_KELP).add(GarnishedBlocks.VERMILION_KELP).add(GarnishedBlocks.DRIED_VERMILION_KELP_BLOCK).add(GarnishedItems.DRIED_VERMILION_KELP);
            PonderRegistry.TAGS.forTag(MASTIC_RESIN).add(GarnishedItems.MASTIC_RESIN).add(GarnishedItems.MASTIC_RESIN_RED).add(GarnishedItems.MASTIC_RESIN_ORANGE).add(GarnishedItems.MASTIC_RESIN_YELLOW).add(GarnishedItems.MASTIC_RESIN_GREEN).add(GarnishedItems.MASTIC_RESIN_BLUE).add(GarnishedItems.MASTIC_RESIN_PURPLE).add(GarnishedItems.MASTIC_PASTE).add(GarnishedItems.MASTIC_PASTE_RED).add(GarnishedItems.MASTIC_PASTE_ORANGE).add(GarnishedItems.MASTIC_PASTE_YELLOW).add(GarnishedItems.MASTIC_PASTE_GREEN).add(GarnishedItems.MASTIC_PASTE_BLUE).add(GarnishedItems.MASTIC_PASTE_PURPLE);
            PonderRegistry.TAGS.forTag(CRUSHED_NETHER_INGREDIENTS).add(GarnishedItems.CRUSHED_CRIMSON_FUNGUS).add(GarnishedItems.CRUSHED_WARPED_FUNGUS).add(GarnishedItems.CRUSHED_SEPIA_FUNGUS).add(GarnishedItems.CRUSHED_SHROOMLIGHT).add(GarnishedItems.BRITTLE_DUST).add(GarnishedItems.SENILE_DUST);
            PonderRegistry.TAGS.forTag(FLUIDS).add(GarnishedItems.BOTTLED_PEANUT_OIL).add(GarnishedItems.APPLE_CIDER).add(GarnishedItems.BITTER_APPLE_CIDER).add(GarnishedItems.CRYPTIC_APPLE_CIDER).add(GarnishedItems.FERMENTED_CASHEW_MIXTURE).add((class_1935)((SimpleFlowableFluid.Flowing)GarnishedFluids.GARNISH.get()).method_15774()).add((class_1935)((SimpleFlowableFluid.Flowing)GarnishedFluids.APPLE_CIDER.get()).method_15774()).add((class_1935)((SimpleFlowableFluid.Flowing)GarnishedFluids.PEANUT_OIL.get()).method_15774()).add((class_1935)((SimpleFlowableFluid.Flowing)GarnishedFluids.CASHEW_MIXTURE.get()).method_15774()).add((class_1935)((SimpleFlowableFluid.Flowing)GarnishedFluids.MASTIC_RESIN.get()).method_15774()).add((class_1935)((SimpleFlowableFluid.Flowing)GarnishedFluids.RED_MASTIC_RESIN.get()).method_15774()).add((class_1935)((SimpleFlowableFluid.Flowing)GarnishedFluids.ORANGE_MASTIC_RESIN.get()).method_15774()).add((class_1935)((SimpleFlowableFluid.Flowing)GarnishedFluids.YELLOW_MASTIC_RESIN.get()).method_15774()).add((class_1935)((SimpleFlowableFluid.Flowing)GarnishedFluids.GREEN_MASTIC_RESIN.get()).method_15774()).add((class_1935)((SimpleFlowableFluid.Flowing)GarnishedFluids.BLUE_MASTIC_RESIN.get()).method_15774()).add((class_1935)((SimpleFlowableFluid.Flowing)GarnishedFluids.PURPLE_MASTIC_RESIN.get()).method_15774());
        }
    }
}

