/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Double> FocusDiscount;
        public final ForgeConfigSpec.ConfigValue<Double> FireMasteryBuff;
        public final ForgeConfigSpec.ConfigValue<Double> WaterMasteryBuff;
        public final ForgeConfigSpec.ConfigValue<Double> AirMasteryBuff;
        public final ForgeConfigSpec.ConfigValue<Double> EarthMasteryBuff;
        public final ForgeConfigSpec.ConfigValue<Double> FireMasteryDebuff;
        public final ForgeConfigSpec.ConfigValue<Double> WaterMasteryDebuff;
        public final ForgeConfigSpec.ConfigValue<Double> AirMasteryDebuff;
        public final ForgeConfigSpec.ConfigValue<Double> EarthMasteryDebuff;

        public Common(ForgeConfigSpec.Builder builder) {
            this.FocusDiscount = builder.comment("Adjust this value to define how much the matching spell cost gets discounted by the focus").defineInRange("Elemental Focus discount", 0.2, 0.0, 0.99);
            builder.comment("Adjust these values to balance how much a spell gets amplified by the matching spell focus").push("Elemental Spell Foci - Amplify");
            this.FireMasteryBuff = builder.define("Fire Focus buff", (Object)2.0);
            this.WaterMasteryBuff = builder.define("Water Focus buff", (Object)2.0);
            this.AirMasteryBuff = builder.define("Air Focus buff", (Object)2.0);
            this.EarthMasteryBuff = builder.define("Earth Focus buff", (Object)2.0);
            builder.pop();
            builder.comment("Adjust these values to balance how much an elemental spell gets dampened by a not-matching spell focus").push("Elemental Spell Foci - Dampening");
            this.FireMasteryDebuff = builder.define("Fire Focus debuff", (Object)-1.0);
            this.WaterMasteryDebuff = builder.define("Water Focus debuff", (Object)-1.0);
            this.AirMasteryDebuff = builder.define("Air Focus debuff", (Object)-1.0);
            this.EarthMasteryDebuff = builder.define("Earth Focus debuff", (Object)-1.0);
            builder.pop();
        }
    }
}

