/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.glyphs;

import alexthw.ars_elemental.FiltersCompat;
import alexthw.ars_elemental.entity.EntityHomingProjectile;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import io.github.derringersmods.toomanyglyphs.common.glyphs.AbstractEffectFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;

public class MethodHomingProj
extends AbstractCastMethod {
    public static MethodHomingProj INSTANCE = new MethodHomingProj();

    public MethodHomingProj() {
        super("homing_projectile", "Homing Projectile");
    }

    public void summonProjectiles(World world, LivingEntity shooter, List<Predicate<LivingEntity>> ignore, List<AbstractAugment> augments, SpellResolver resolver) {
        ArrayList<EntityHomingProjectile> projectiles = new ArrayList<EntityHomingProjectile>();
        EntityHomingProjectile projectileSpell = new EntityHomingProjectile(world, resolver, ignore);
        projectiles.add(projectileSpell);
        int numSplits = MethodHomingProj.getBuffCount(augments, AugmentSplit.class);
        for (int i = 1; i < numSplits + 1; ++i) {
            Direction offset = shooter.func_174811_aO().func_176746_e();
            if (i % 2 == 0) {
                offset = offset.func_176734_d();
            }
            BlockPos projPos = shooter.func_233580_cy_().func_177967_a(offset, i / 2);
            projPos = projPos.func_177963_a(0.0, 1.5, 0.0);
            EntityHomingProjectile spell = new EntityHomingProjectile(world, resolver, ignore);
            spell.func_70107_b(projPos.func_177958_n(), projPos.func_177956_o(), projPos.func_177952_p());
            projectiles.add(spell);
        }
        float velocity = 0.5f + (float)MethodHomingProj.getBuffCount(augments, AugmentAccelerate.class) / 10.0f;
        for (EntityHomingProjectile proj : projectiles) {
            proj.shoot((Entity)shooter, shooter.field_70177_z, shooter.field_70177_z, 0.0f, velocity, 0.8f);
            world.func_217376_c((Entity)proj);
        }
    }

    public void onCast(ItemStack itemStack, LivingEntity shooter, World world, List<AbstractAugment> list, SpellContext spellContext, SpellResolver resolver) {
        Set<AbstractEffectFilter> filters;
        ArrayList<Predicate<LivingEntity>> ignore = new ArrayList<Predicate<LivingEntity>>();
        ignore.add(livingEntity -> !livingEntity.func_70089_S());
        ignore.add(livingEntity -> livingEntity == shooter);
        ignore.add(arg_0 -> ((LivingEntity)shooter).func_184191_r(arg_0));
        if (!list.contains(AugmentSensitive.INSTANCE)) {
            ignore.add(livingEntity -> livingEntity instanceof PlayerEntity);
        }
        ignore.add(livingEntity -> livingEntity instanceof FamiliarEntity);
        if (ModList.get().isLoaded("toomanyglyphs") && !(filters = FiltersCompat.getFilters(spellContext.getSpell().recipe)).isEmpty()) {
            ignore.add(livingEntity -> !FiltersCompat.checkFilters(livingEntity, filters));
        }
        if (shooter instanceof PlayerEntity) {
            ignore.add(livingEntity -> livingEntity instanceof ISummon && shooter.func_110124_au().equals(((ISummon)livingEntity).getOwnerID()));
            resolver.expendMana(shooter);
        } else if (shooter instanceof ISummon && ((ISummon)shooter).getOwnerID() != null) {
            ignore.add(livingEntity -> livingEntity.func_110124_au().equals(((ISummon)shooter).getOwnerID()));
            ignore.add(livingEntity -> livingEntity instanceof ISummon && ((ISummon)shooter).getOwnerID().equals(((ISummon)livingEntity).getOwnerID()));
        }
        this.summonProjectiles(world, shooter, ignore, list, resolver);
    }

    public void onCastOnBlock(ItemUseContext context, List<AbstractAugment> list, SpellContext spellContext, SpellResolver resolver) {
        World world = context.func_195991_k();
        PlayerEntity shooter = context.func_195999_j();
        this.onCast(ItemStack.field_190927_a, (LivingEntity)shooter, world, list, spellContext, resolver);
        resolver.expendMana((LivingEntity)shooter);
    }

    public void onCastOnBlock(BlockRayTraceResult blockRayTraceResult, LivingEntity livingEntity, List<AbstractAugment> list, SpellContext spellContext, SpellResolver spellResolver) {
    }

    public void onCastOnEntity(ItemStack itemStack, LivingEntity livingEntity, Entity entity, Hand hand, List<AbstractAugment> list, SpellContext spellContext, SpellResolver spellResolver) {
        this.onCast(itemStack, livingEntity, livingEntity.field_70170_p, list, spellContext, spellResolver);
    }

    public boolean wouldCastSuccessfully(ItemStack itemStack, LivingEntity livingEntity, World world, List<AbstractAugment> list, SpellResolver spellResolver) {
        return false;
    }

    public boolean wouldCastOnBlockSuccessfully(ItemUseContext itemUseContext, List<AbstractAugment> list, SpellResolver spellResolver) {
        return false;
    }

    public boolean wouldCastOnBlockSuccessfully(BlockRayTraceResult blockRayTraceResult, LivingEntity livingEntity, List<AbstractAugment> list, SpellResolver spellResolver) {
        return false;
    }

    public boolean wouldCastOnEntitySuccessfully(ItemStack itemStack, LivingEntity livingEntity, Entity entity, Hand hand, List<AbstractAugment> list, SpellResolver spellResolver) {
        return false;
    }

    public int getManaCost() {
        return 40;
    }

    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.THREE;
    }

    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentPierce.INSTANCE, AugmentSensitive.INSTANCE, AugmentSplit.INSTANCE, AugmentAccelerate.INSTANCE});
    }
}

