/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.item;

import alexthw.ars_elemental.ConfigHandler;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.item.ISpellModifierItem;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;

@Mod.EventBusSubscriber(modid="ars_elemental", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ElementalFocus
extends Item
implements ISpellModifierItem {
    private final SpellSchool school;

    public ElementalFocus(Item.Properties props, SpellSchool school) {
        super(props);
        this.school = school;
    }

    double getBoostMultiplier() {
        double mult;
        switch (this.school.getId()) {
            case "fire": {
                mult = (Double)ConfigHandler.COMMON.FireMasteryBuff.get();
                break;
            }
            case "water": {
                mult = (Double)ConfigHandler.COMMON.WaterMasteryBuff.get();
                break;
            }
            case "air": {
                mult = (Double)ConfigHandler.COMMON.AirMasteryBuff.get();
                break;
            }
            case "earth": {
                mult = (Double)ConfigHandler.COMMON.EarthMasteryBuff.get();
                break;
            }
            default: {
                mult = 0.0;
            }
        }
        return mult;
    }

    double getMalusMultiplier() {
        double mult;
        switch (this.school.getId()) {
            case "fire": {
                mult = (Double)ConfigHandler.COMMON.FireMasteryDebuff.get();
                break;
            }
            case "water": {
                mult = (Double)ConfigHandler.COMMON.WaterMasteryDebuff.get();
                break;
            }
            case "air": {
                mult = (Double)ConfigHandler.COMMON.AirMasteryDebuff.get();
                break;
            }
            case "earth": {
                mult = (Double)ConfigHandler.COMMON.EarthMasteryDebuff.get();
                break;
            }
            default: {
                mult = 0.0;
            }
        }
        return mult;
    }

    public SpellSchool getSchool() {
        return this.school;
    }

    public SpellStats.Builder applyItemModifiers(ItemStack stack, SpellStats.Builder builder, AbstractSpellPart spellPart, RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellContext spellContext) {
        if (!SpellSchools.ELEMENTAL.isPartOfSchool(spellPart)) {
            return builder;
        }
        if (this.school.isPartOfSchool(spellPart)) {
            builder.addAmplification(this.getBoostMultiplier());
        } else {
            builder.addAmplification(this.getMalusMultiplier());
        }
        return builder;
    }

    @SubscribeEvent
    public static void onCast(SpellCastEvent event) {
        ElementalFocus focus;
        if (!event.getWorld().field_72995_K && (focus = ElementalFocus.hasFocus(event.getWorld(), (Entity)event.getEntityLiving())) != null) {
            if (event.spell.recipe.stream().anyMatch(arg_0 -> ((SpellSchool)focus.getSchool()).isPartOfSchool(arg_0))) {
                event.spell.setCost((int)((double)event.spell.getCastingCost() * (1.0 - (Double)ConfigHandler.COMMON.FocusDiscount.get())));
            }
        }
    }

    public static ElementalFocus hasFocus(World world, Entity entity) {
        IItemHandlerModifiable items;
        if (!world.field_72995_K && entity instanceof PlayerEntity && (items = (IItemHandlerModifiable)CuriosUtil.getAllWornItems((LivingEntity)((LivingEntity)entity)).orElse(null)) != null) {
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).func_77973_b();
                if (!(item instanceof ElementalFocus)) continue;
                return (ElementalFocus)item;
            }
        }
        return null;
    }
}

