/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.item;

import alexthw.ars_elemental.ModRegistry;
import alexthw.ars_elemental.entity.AllyVhexEntity;
import alexthw.ars_elemental.entity.SummonDirewolf;
import alexthw.ars_elemental.entity.SummonSkeleHorse;
import alexthw.ars_elemental.glyphs.MethodHomingProj;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SummonEvent;
import com.hollingsworth.arsnouveau.api.item.ISpellModifierItem;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityAllyVex;
import com.hollingsworth.arsnouveau.common.entity.EntityDummy;
import com.hollingsworth.arsnouveau.common.entity.SummonHorse;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="ars_elemental")
public class NecroticFocus
extends Item
implements ISpellModifierItem {
    public static List<AbstractCastMethod> sympatheticMethods = new ArrayList<AbstractCastMethod>();

    public NecroticFocus(Item.Properties properties) {
        super(properties);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void summonedEvent(SummonEvent event) {
        if (!event.world.field_72995_K && NecroticFocus.containsThis(event.world, event.summon.getOwner((ServerWorld)event.world))) {
            EntityAllyVex oldVex;
            AllyVhexEntity newVex;
            if (event.summon instanceof SummonHorse) {
                SummonHorse oldHorse = (SummonHorse)event.summon;
                SummonSkeleHorse newHorse = NecroticFocus.replaceHorse(event.world, oldHorse);
                if (newHorse != null) {
                    oldHorse.getEntity().func_70106_y();
                    event.summon = newHorse;
                    event.world.func_217376_c((Entity)newHorse);
                }
            } else if (event.summon instanceof SummonWolf) {
                SummonWolf oldWolf = (SummonWolf)event.summon;
                SummonDirewolf newWolf = NecroticFocus.replaceWolf(event.world, oldWolf);
                if (newWolf != null) {
                    oldWolf.getEntity().func_70106_y();
                    event.summon = newWolf;
                    event.world.func_217376_c((Entity)newWolf);
                }
            } else if (event.summon instanceof EntityAllyVex && (newVex = NecroticFocus.replaceVex(event.world, oldVex = (EntityAllyVex)event.summon)) != null) {
                oldVex.getEntity().func_70106_y();
                event.summon = newVex;
                event.world.func_217376_c((Entity)newVex);
            }
        }
    }

    private static AllyVhexEntity replaceVex(World world, EntityAllyVex oldVex) {
        PlayerEntity owner = (PlayerEntity)oldVex.getOwner((ServerWorld)world);
        if (owner == null) {
            return null;
        }
        AllyVhexEntity vexEntity = new AllyVhexEntity(world, (LivingEntity)owner);
        vexEntity.func_174828_a(oldVex.func_233580_cy_(), 0.0f, 0.0f);
        vexEntity.func_213386_a((IServerWorld)world, world.func_175649_E(oldVex.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
        vexEntity.setOwner((LivingEntity)owner);
        vexEntity.setOwnerID(owner.func_110124_au());
        vexEntity.func_190651_g(oldVex.func_190646_di());
        vexEntity.func_190653_a(oldVex.serializeNBT().func_74762_e("LifeTicks"));
        return vexEntity;
    }

    private static SummonDirewolf replaceWolf(World world, SummonWolf oldWolf) {
        SummonDirewolf direwolf = new SummonDirewolf(world);
        direwolf.setTicksLeft(oldWolf.getTicksLeft());
        Vector3d hit = oldWolf.func_213303_ch();
        direwolf.func_70107_b(hit.func_82615_a(), hit.func_82617_b(), hit.func_82616_c());
        if (oldWolf.getOwnerID() == null) {
            return null;
        }
        PlayerEntity shooter = world.func_217371_b(oldWolf.getOwnerID());
        if (shooter == null) {
            return null;
        }
        direwolf.func_70624_b(shooter.func_110144_aD());
        direwolf.func_213395_q(true);
        direwolf.func_70903_f(true);
        direwolf.func_193101_c(shooter);
        direwolf.setOwnerID(shooter.func_110124_au());
        return direwolf;
    }

    public static SummonSkeleHorse replaceHorse(World world, SummonHorse oldHorse) {
        SummonSkeleHorse newHorse = new SummonSkeleHorse((EntityType<? extends HorseEntity>)((EntityType)ModRegistry.SKELEHORSE_SUMMON.get()), world);
        if (oldHorse.getOwnerID() == null) {
            return null;
        }
        PlayerEntity player = world.func_217371_b(oldHorse.getOwnerID());
        if (player == null) {
            return null;
        }
        BlockPos position = oldHorse.func_233580_cy_();
        newHorse.func_70107_b(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        newHorse.ticksLeft = oldHorse.getTicksLeft();
        newHorse.func_110263_g(player);
        newHorse.getHorseInventory().func_70299_a(0, new ItemStack((IItemProvider)Items.field_151141_av));
        newHorse.setOwnerID(player.func_110124_au());
        newHorse.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
        return newHorse;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void summonDeathEvent(SummonEvent.Death event) {
        DamageSource source;
        PlayerEntity player;
        if (!event.world.field_72995_K && event.summon.getOwner((ServerWorld)event.world) instanceof PlayerEntity && (player = (PlayerEntity)event.summon.getOwner((ServerWorld)event.world)) != null && NecroticFocus.containsThis(event.world, (Entity)player) && (source = event.source) != null && source.func_76346_g() != null && source.func_76346_g() instanceof LivingEntity) {
            LivingEntity killer = (LivingEntity)source.func_76346_g();
            killer.func_195064_c(new EffectInstance(Effects.field_82731_v, 100));
        }
    }

    public static boolean containsThis(World world, Entity entity) {
        IItemHandlerModifiable items;
        if (!world.field_72995_K && entity instanceof PlayerEntity && (items = (IItemHandlerModifiable)CuriosUtil.getAllWornItems((LivingEntity)((LivingEntity)entity)).orElse(null)) != null) {
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).func_77973_b();
                if (!(item instanceof NecroticFocus)) continue;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void castSpell(SpellCastEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof PlayerEntity && NecroticFocus.containsThis(event.getWorld(), (Entity)event.getEntityLiving()) && event.spell.getCastMethod() != null && sympatheticMethods.contains(event.spell.getCastMethod())) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            for (LivingEntity i : event.getWorld().func_225316_b(LivingEntity.class, new AxisAlignedBB(event.getEntityLiving().func_233580_cy_()).func_186662_g(30.0), l -> l instanceof ISummon && !(l instanceof EntityDummy))) {
                ISummon summon = (ISummon)i;
                Entity owner = summon.getOwner((ServerWorld)event.getWorld());
                if (!player.equals((Object)owner)) continue;
                EntitySpellResolver spellResolver = new EntitySpellResolver(new SpellContext(event.spell, i).withColors(event.context.colors));
                spellResolver.onCast(ItemStack.field_190927_a, i, i.field_70170_p);
                summon.setTicksLeft(Math.max(0, summon.getTicksLeft() - 100));
            }
        }
    }

    static {
        sympatheticMethods.add((AbstractCastMethod)MethodTouch.INSTANCE);
        sympatheticMethods.add((AbstractCastMethod)MethodProjectile.INSTANCE);
        sympatheticMethods.add(MethodHomingProj.INSTANCE);
    }
}

