/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.ghast.entity;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.ghast.entity.goal.FollowEntityPredicateGoal;
import com.iafenvoy.ghast.entity.goal.HappyGhastFlyRandomlyGoal;
import com.iafenvoy.ghast.entity.goal.HappyGhastFollowHarnessGoal;
import com.iafenvoy.ghast.entity.goal.HappyGhastLookAtEntityGoal;
import com.iafenvoy.ghast.entity.goal.HappyGhastSwimGoal;
import com.iafenvoy.ghast.entity.goal.HappyGhastTemptGoal;
import com.iafenvoy.ghast.item.HarnessItem;
import com.iafenvoy.ghast.mixin.LivingEntityAccessor;
import com.iafenvoy.ghast.registry.HGEntities;
import com.iafenvoy.ghast.registry.HGSounds;
import com.iafenvoy.ghast.registry.HGTags;
import com.mojang.serialization.Dynamic;
import java.util.Collection;
import java.util.Set;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1324;
import net.minecraft.class_1333;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

public class HappyGhastEntity
extends class_1429 {
    private static final double STANDARD_RIDER_OFFSET = 1.35;
    private long currentAge = 0L;
    private int stillTimeout = 0;
    private HappyGhastTemptGoal foodGoal;
    private HappyGhastTemptGoal harnessGoal;

    public HappyGhastEntity(class_1299<HappyGhastEntity> type, class_1937 world) {
        super(type, world);
        this.method_49477(0.6f);
        this.field_6194 = 0;
        this.method_5977(false);
        this.method_5971();
        this.field_6207 = new HappyGhastMoveControl(this);
        this.field_6206 = new HappyGhastLookControl(this);
        this.method_5946(class_1304.field_6174, 1.0f);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10544("currentAge", this.currentAge);
        nbt.method_10569("still_timeout", this.stillTimeout);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.currentAge = nbt.method_10537("currentAge");
        this.stillTimeout = nbt.method_10550("still_timeout");
    }

    protected class_4095.class_5303<HappyGhastEntity> method_28306() {
        return class_4095.method_28311((Collection)ImmutableList.of((Object)class_4140.field_18438), (Collection)ImmutableList.of());
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return HappyGhastEntity.create((class_4095<HappyGhastEntity>)this.method_28306().method_28335(dynamic));
    }

    protected static class_4095<?> create(class_4095<HappyGhastEntity> brain) {
        brain.method_18890(Set.of(class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    protected void method_5619() {
        this.field_6189 = this.method_6109() ? new GhastlingNavigation(this, this.method_37908()) : this.method_5965(this.method_37908());
        super.method_5619();
    }

    public class_243 method_24829(class_1309 p_20123_) {
        return new class_243(this.method_23317(), this.method_5829().field_1325 + 0.45, this.method_23321());
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return HappyGhastEntity.generateChild(world, entity.method_24515(), class_3730.field_16466, 0.0f);
    }

    protected class_1408 method_5965(class_1937 world) {
        return new class_1407((class_1308)this, world);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new HappyGhastSwimGoal(this));
        this.field_6201.method_6277(3, (class_1352)new HappyGhastFlyRandomlyGoal(this));
        this.field_6201.method_6277(4, (class_1352)new FollowEntityPredicateGoal(this, target -> target.method_5864().method_20210(HGTags.HAPPY_GHAST_FOLLOW) && !target.method_6109(), 1.1, 5.0f, 16.0f));
        this.field_6201.method_6277(5, (class_1352)new HappyGhastLookAtEntityGoal(this, class_1657.class, 64.0f));
        this.field_6201.method_6277(5, (class_1352)new FollowEntityPredicateGoal(this, target -> target.method_5864() == class_1299.field_6097, 1.1, 5.0f, 16.0f));
        this.foodGoal = new HappyGhastTemptGoal(this, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8543}));
        this.field_6201.method_6277(7, (class_1352)this.foodGoal);
        this.harnessGoal = new HappyGhastFollowHarnessGoal(this);
        this.field_6201.method_6277(7, (class_1352)this.harnessGoal);
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    public double method_5621() {
        return super.method_5621() + 0.5;
    }

    public class_3414 method_5994() {
        return this.method_6109() ? (class_3414)HGSounds.ENTITY_GHASTLING_AMBIENT.get() : (class_3414)HGSounds.ENTITY_HAPPY_GHAST_AMBIENT.get();
    }

    public class_3414 method_6011(class_1282 ds) {
        return this.method_6109() ? (class_3414)HGSounds.ENTITY_GHASTLING_HURT.get() : (class_3414)HGSounds.ENTITY_HAPPY_GHAST_HURT.get();
    }

    public class_3414 method_6002() {
        return this.method_6109() ? (class_3414)HGSounds.ENTITY_GHASTLING_DEATH.get() : (class_3414)HGSounds.ENTITY_HAPPY_GHAST_DEATH.get();
    }

    public boolean method_5747(float l, float d, class_1282 source) {
        return false;
    }

    protected void method_5627(class_1297 passenger) {
        if (!this.method_5782() && !this.getBodyArmor().method_7960()) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), (class_3414)HGSounds.ENTITY_HAPPY_GHAST_HARNESS_GOGGLES_DOWN.get(), this.method_5634(), 1.0f, 1.0f);
        }
        super.method_5627(passenger);
    }

    protected void method_5793(class_1297 passenger) {
        super.method_5793(passenger);
        if (!this.method_5782() && !this.getBodyArmor().method_7960()) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), (class_3414)HGSounds.ENTITY_HAPPY_GHAST_HARNESS_GOGGLES_UP.get(), this.method_5634(), 1.0f, 1.0f);
            this.rememberHomePos();
        }
    }

    public void method_5932(boolean sendPacket, boolean dropItem) {
        super.method_5932(sendPacket, dropItem);
        this.rememberHomePos();
    }

    @Nullable
    public class_1309 method_5642() {
        class_1309 class_13092;
        class_1297 class_12972;
        if (!this.method_5987() && !this.shouldStay() && !this.getBodyArmor().method_7960() && (class_12972 = this.method_31483()) instanceof class_1657) {
            class_1657 playerEntity = (class_1657)class_12972;
            class_13092 = playerEntity;
        } else {
            class_13092 = super.method_5642();
        }
        return class_13092;
    }

    public boolean method_5818(class_1297 passenger) {
        return !this.method_6109() && this.method_5685().size() < 4;
    }

    public void method_5865(class_1297 passenger) {
        if (this.method_5626(passenger)) {
            class_243 offset = (switch (this.method_5685().indexOf(passenger)) {
                case 0 -> new class_243(1.35, this.method_5621(), 0.0);
                case 1 -> new class_243(0.0, this.method_5621(), -1.35);
                case 2 -> new class_243(-1.35, this.method_5621(), 0.0);
                case 3 -> new class_243(0.0, this.method_5621(), 1.35);
                default -> class_243.field_1353;
            }).method_1024((float)(-Math.toRadians(this.method_36454()) - 1.5707963267948966));
            passenger.method_5814(this.method_23317() + offset.field_1352, this.method_23318() + offset.field_1351, this.method_23321() + offset.field_1350);
        }
    }

    public boolean method_5679(class_1282 source) {
        return source.method_49708(class_8111.field_42345) || source.method_49708(class_8111.field_42342) && this.method_6109() || super.method_5679(source);
    }

    public boolean method_5659() {
        return true;
    }

    public boolean method_5753() {
        return true;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!this.method_6109() && !this.method_5782()) {
            if (this.getBodyArmor().method_7960()) {
                if (stack.method_7909() instanceof HarnessItem) {
                    if (!this.method_37908().field_9236) {
                        this.setBodyArmor(stack.method_46651(1));
                        if (!player.method_31549().field_7477) {
                            stack.method_7934(1);
                        }
                    }
                    this.method_37908().method_43129(null, (class_1297)this, (class_3414)HGSounds.ENTITY_HAPPY_GHAST_EQUIP.get(), class_3419.field_15254, 1.0f, 1.0f);
                    return class_1269.field_5812;
                }
            } else if (stack.method_31574(class_1802.field_8868) && (class_1890.method_8225((class_1887)class_1893.field_9113, (class_1799)this.getBodyArmor()) == 0 || player.method_7337())) {
                if (!this.method_37908().field_9236) {
                    if (!player.method_31549().field_7477) {
                        player.method_31548().method_7398(this.getBodyArmor());
                    }
                    stack.method_7956(1, (class_1309)player, e -> e.method_20235(hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171));
                    this.setBodyArmor(class_1799.field_8037);
                }
                this.method_37908().method_43129(null, (class_1297)this, (class_3414)HGSounds.ENTITY_HAPPY_GHAST_UNEQUIP.get(), class_3419.field_15254, 1.0f, 1.0f);
                return class_1269.field_5812;
            }
        }
        if (this.method_6481(stack)) {
            if (this.method_6109()) {
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                this.method_5620(HappyGhastEntity.method_41321((int)(-this.method_5618())), true);
                this.method_37908().method_8421((class_1297)this, (byte)18);
                return class_1269.field_5812;
            }
            if (this.method_6032() <= this.method_6063()) {
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                this.method_6025(4.0f);
                return class_1269.field_5812;
            }
        } else {
            player.method_5804((class_1297)this);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_30949(class_1297 entity) {
        return true;
    }

    public boolean method_30948() {
        return !this.method_6109() && this.shouldStay();
    }

    public boolean hasPlayerOnTop() {
        class_238 box = this.method_5829();
        class_238 box2 = new class_238(box.field_1323 - 1.0, box.field_1325, box.field_1321 - 1.0, box.field_1320 + 1.0, box.field_1325 + box.method_17940() / 2.0, box.field_1324 + 1.0);
        for (class_1657 playerEntity : this.method_37908().method_18456()) {
            if (playerEntity.method_7325() || !box2.method_1008(playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321())) continue;
            return true;
        }
        return false;
    }

    public boolean shouldStay() {
        return this.stillTimeout > 0;
    }

    public void method_6091(class_243 movementInput) {
        this.method_5724(0.09f, movementInput);
        this.method_5784(class_1313.field_6308, this.method_18798());
        float multiplier = 0.91f;
        if (this.method_5799()) {
            multiplier = 0.8f;
        } else if (this.method_5771()) {
            multiplier = 0.5f;
        }
        this.method_18799(this.method_18798().method_1021((double)multiplier));
    }

    protected class_243 method_49482(class_1309 controllingPlayer, class_243 movementInput) {
        float f = controllingPlayer.field_6212;
        float g = 0.0f;
        float h = 0.0f;
        if (controllingPlayer.field_6250 != 0.0f) {
            float i = class_3532.method_15362((float)(controllingPlayer.method_36455() * ((float)Math.PI / 180)));
            float j = -class_3532.method_15374((float)(controllingPlayer.method_36455() * ((float)Math.PI / 180)));
            if (controllingPlayer.field_6250 < 0.0f) {
                i *= -0.5f;
                j *= -0.5f;
            }
            h = j;
            g = i;
        }
        if (((LivingEntityAccessor)controllingPlayer).isJumping()) {
            h += 0.5f;
        }
        return new class_243((double)f, (double)h, (double)g).method_1021((double)0.18f);
    }

    protected class_241 getGhastRotation(class_1309 controllingEntity) {
        return new class_241(controllingEntity.method_36455() * 0.5f, controllingEntity.method_36454());
    }

    protected void method_49481(class_1309 controllingPlayer, class_243 movementInput) {
        super.method_49481(controllingPlayer, movementInput);
        class_241 vec2f = this.getGhastRotation(controllingPlayer);
        float f = this.method_36454();
        float g = class_3532.method_15393((float)(vec2f.field_1342 - f));
        this.method_5710(f += g * 0.08f, vec2f.field_1343);
        this.field_6283 = this.field_6241 = f;
        this.field_5982 = this.field_6241;
    }

    protected void method_5623(double y, boolean onGroundIn, class_2680 state, class_2338 pos) {
    }

    public boolean method_6101() {
        return false;
    }

    public void method_5875(boolean ignored) {
        super.method_5875(true);
    }

    public int method_5945() {
        return 1;
    }

    public boolean method_6094() {
        return this.method_6109() || super.method_6094();
    }

    protected boolean method_43689() {
        return false;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    public float method_6017() {
        return 1.0f;
    }

    public class_3419 method_5634() {
        return class_3419.field_15254;
    }

    public int method_5970() {
        int i = super.method_5970();
        return this.method_5782() ? i * 6 : i;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(HGTags.HAPPY_GHAST_FOOD);
    }

    public void method_5773() {
        class_1324 kbResist;
        super.method_5773();
        ++this.currentAge;
        if (this.currentAge % 600L == 0L || this.currentAge % 20L == 0L && (192.0 <= this.method_23318() && this.method_23318() <= 196.0 || this.method_37908().method_8520(this.method_24515()))) {
            this.method_6025(1.0f);
        }
        if (this.stillTimeout > 0) {
            --this.stillTimeout;
        }
        if (this.hasPlayerOnTop()) {
            this.stillTimeout = 10;
        }
        if ((kbResist = this.method_5996(class_5134.field_23718)) != null) {
            double newValue;
            double d = newValue = this.shouldStay() ? 1.0 : (double)this.method_5685().size() * 0.05;
            if (newValue != kbResist.method_6194()) {
                kbResist.method_6192(newValue);
            }
        }
    }

    public void method_6007() {
        super.method_6007();
        this.method_5875(true);
        if (this.method_5799()) {
            this.method_5772();
        }
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        class_1315 data = super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
        this.rememberHomePos();
        return data;
    }

    public boolean isFollowingPlayer() {
        return this.foodGoal.isActive() || this.harnessGoal.isActive();
    }

    public void rememberHomePos() {
        this.field_18321.method_18878(class_4140.field_18438, (Object)class_4208.method_19443((class_5321)this.method_37908().method_27983(), (class_2338)this.method_24515()));
    }

    public void setBodyArmor(class_1799 stack) {
        this.method_5673(class_1304.field_6174, stack);
        this.rememberHomePos();
    }

    public class_1799 getBodyArmor() {
        return this.method_6118(class_1304.field_6174);
    }

    public void stopMovement() {
        this.method_5942().method_6340();
        this.method_5938(0.0f);
        this.method_5976(0.0f);
        this.method_6125(0.0f);
        this.method_18800(0.0, 0.0, 0.0);
    }

    public static HappyGhastEntity generateChild(class_3218 world, class_2338 pos, class_3730 reason, float yaw) {
        HappyGhastEntity ghast = new HappyGhastEntity((class_1299<HappyGhastEntity>)((class_1299)HGEntities.HAPPY_GHAST.get()), (class_1937)world);
        ghast.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, yaw, 0.0f);
        ghast.method_7217(true);
        ghast.method_5847(yaw);
        ghast.method_18800(0.0, 0.0, 0.0);
        ghast.method_5943((class_5425)world, world.method_8404(pos), reason, null, null);
        return ghast;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 0.18).method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23724, 0.0).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23717, 64.0).method_26868(class_5134.field_23720, 0.32);
    }

    public static void updateYaw(class_1308 ghast) {
        if (ghast.method_5968() == null) {
            class_243 vec3d = ghast.method_18798();
            ghast.method_36456(-((float)class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350)) * 57.295776f);
            ghast.field_6283 = ghast.method_36454();
        } else {
            class_1309 livingEntity = ghast.method_5968();
            if (livingEntity.method_5858((class_1297)ghast) < 4096.0) {
                double e = livingEntity.method_23317() - ghast.method_23317();
                double f = livingEntity.method_23321() - ghast.method_23321();
                ghast.method_36456(-((float)class_3532.method_15349((double)e, (double)f)) * 57.295776f);
                ghast.field_6283 = ghast.method_36454();
            }
        }
    }

    static class HappyGhastMoveControl
    extends class_1335 {
        private final HappyGhastEntity happyGhast;
        private int collisionCheckCooldown;

        public HappyGhastMoveControl(HappyGhastEntity happyGhast) {
            super((class_1308)happyGhast);
            this.happyGhast = happyGhast;
        }

        public void method_6240() {
            if (this.happyGhast.method_30948()) {
                this.field_6374 = class_1335.class_1336.field_6377;
                this.happyGhast.stopMovement();
            } else if (this.field_6374 == class_1335.class_1336.field_6378 && this.collisionCheckCooldown-- <= 0) {
                this.collisionCheckCooldown += this.happyGhast.method_6051().method_43048(5) + 2;
                class_243 vec3d = new class_243(this.field_6370 - this.happyGhast.method_23317(), this.field_6369 - this.happyGhast.method_23318(), this.field_6367 - this.happyGhast.method_23321());
                double d = vec3d.method_1033();
                if (this.willCollide(vec3d = vec3d.method_1029(), class_3532.method_15384((double)d))) {
                    this.happyGhast.method_18799(this.happyGhast.method_18798().method_1019(vec3d.method_1021(0.05)));
                } else {
                    this.field_6374 = class_1335.class_1336.field_6377;
                }
            }
        }

        private boolean willCollide(class_243 direction, int steps) {
            class_238 box = this.happyGhast.method_5829();
            for (int i = 1; i < steps; ++i) {
                box = box.method_997(direction);
                if (this.happyGhast.method_37908().method_8587((class_1297)this.happyGhast, box)) continue;
                return false;
            }
            return true;
        }
    }

    static class HappyGhastLookControl
    extends class_1333 {
        private final HappyGhastEntity happyGhast;

        HappyGhastLookControl(HappyGhastEntity happyGhast) {
            super((class_1308)happyGhast);
            this.happyGhast = happyGhast;
        }

        public void method_6231() {
            if (this.happyGhast.shouldStay()) {
                float f = HappyGhastLookControl.getYawToSubtract(this.happyGhast.method_36454());
                this.happyGhast.method_36456(this.happyGhast.method_36454() - f);
                this.happyGhast.method_5847(this.happyGhast.method_36454());
            } else if (this.field_35103 > 0) {
                --this.field_35103;
                double d = this.field_6364 - this.happyGhast.method_23317();
                double e = this.field_6362 - this.happyGhast.method_23321();
                this.happyGhast.method_36456(-((float)class_3532.method_15349((double)d, (double)e)) * 57.295776f);
                this.happyGhast.field_6241 = this.happyGhast.field_6283 = this.happyGhast.method_36454();
            } else {
                HappyGhastEntity.updateYaw(this.field_6361);
            }
        }

        public static float getYawToSubtract(float yaw) {
            float f = yaw % 90.0f;
            if (f >= 45.0f) {
                f -= 90.0f;
            }
            if (f < -45.0f) {
                f += 90.0f;
            }
            return f;
        }
    }

    static class GhastlingNavigation
    extends class_1407 {
        public GhastlingNavigation(HappyGhastEntity entity, class_1937 world) {
            super((class_1308)entity, world);
            this.method_6331(false);
            this.method_6354(true);
            this.method_23964(48.0f);
        }

        protected boolean method_6341(class_243 origin, class_243 target) {
            return GhastlingNavigation.method_43394((class_1308)this.field_6684, (class_243)origin, (class_243)target, (boolean)false);
        }
    }
}

