/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.youskill.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.youskill.YouskillMod;
import net.mcreator.youskill.procedures.Snat1000Procedure;
import net.mcreator.youskill.procedures.Snat100Procedure;
import net.mcreator.youskill.procedures.Snat10Procedure;
import net.mcreator.youskill.procedures.Snat1Procedure;
import net.mcreator.youskill.procedures.Snat5000Procedure;
import net.mcreator.youskill.procedures.Snat500Procedure;
import net.mcreator.youskill.procedures.Snat5Procedure;
import net.mcreator.youskill.world.inventory.BankomatGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BankomatGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public BankomatGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public BankomatGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(BankomatGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(BankomatGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            BankomatGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = BankomatGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Snat1Procedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            Snat5Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            Snat10Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            Snat100Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            Snat500Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            Snat1000Procedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            Snat5000Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        YouskillMod.addNetworkMessage(BankomatGUIButtonMessage.class, BankomatGUIButtonMessage::buffer, BankomatGUIButtonMessage::new, BankomatGUIButtonMessage::handler);
    }
}

