/*
 * Decompiled with CFR 0.152.
 */
package be.meiji.omakasemobu.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TomlHelper {
    @Nullable
    public static List<String> parseStringList(File configFile, String key) throws IOException {
        String[] entries;
        ArrayList<String> result = new ArrayList<String>();
        String content = Files.readString(configFile.toPath()).trim();
        int keyIndex = content.indexOf(key);
        if (keyIndex == -1) {
            return null;
        }
        int startBracket = content.indexOf("[", keyIndex);
        int endBracket = content.indexOf("]", startBracket);
        if (startBracket == -1 || endBracket == -1) {
            throw new IOException("Invalid TOML syntax for key '" + key + "': missing brackets.");
        }
        String listContent = content.substring(startBracket + 1, endBracket);
        for (String entry : entries = listContent.split(",")) {
            String trimmedEntry = entry.trim();
            if (!trimmedEntry.startsWith("\"") || !trimmedEntry.endsWith("\"") || trimmedEntry.length() < 2) continue;
            String value = trimmedEntry.substring(1, trimmedEntry.length() - 1);
            result.add(value);
        }
        return result;
    }

    public static void writeStringList(File configFile, String key, List<String> values) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(key).append(" = [");
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("\"").append(values.get(i)).append("\"");
        }
        sb.append("]\n");
        Files.writeString(configFile.toPath(), (CharSequence)sb.toString(), new OpenOption[0]);
    }
}

