/*
 * Decompiled with CFR 0.152.
 */
package be.meiji.omakasemobu;

import be.meiji.omakasemobu.util.TomlHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobRandomizerMod
implements ModInitializer {
    public static final String MOD_ID = "mob_randomizer";
    public static final String TAG_ID = "randomized";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mob_randomizer");
    private static final class_1299<?>[] DEFAULT_BLACKLIST = new class_1299[]{class_1299.field_6095, class_1299.field_6116, class_1299.field_6119, class_1299.field_6065, class_1299.field_6048};
    private static final List<class_1299<?>> blacklist = new ArrayList();
    private static final Map<Integer, Integer> RANDOMIZER = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> COMPLIMENT = new HashMap<Integer, Integer>();

    public static boolean canRandomize(class_1299<?> entity) {
        if ((class_1299.field_6077.equals(entity) || class_1299.field_6047.equals(entity) || class_1299.field_6147.equals(entity)) && blacklist.stream().noneMatch(e -> e == entity)) {
            return true;
        }
        return entity.method_5891() != class_1311.field_17715 && !class_7701.method_45406((class_7699)entity.method_45322()) && blacklist.stream().noneMatch(e -> e == entity);
    }

    @NotNull
    public static class_1299<?> randomize(class_1299<?> entityIn) {
        if (!MobRandomizerMod.canRandomize(entityIn)) {
            return entityIn;
        }
        int id = class_7923.field_41177.method_10206(entityIn);
        return (class_1299)class_7923.field_41177.method_10200(RANDOMIZER.get(id).intValue());
    }

    @NotNull
    public static class_1299<?> compliment(class_1299<?> entityIn) {
        if (!MobRandomizerMod.canRandomize(entityIn)) {
            return entityIn;
        }
        int id = class_7923.field_41177.method_10206(entityIn);
        return (class_1299)class_7923.field_41177.method_10200(COMPLIMENT.get(id).intValue());
    }

    public static class_1297 createRandomizedEntity(class_3218 world, class_1297 entity, boolean doInit) {
        class_1299<?> newType = MobRandomizerMod.randomize(entity.method_5864());
        class_1297 newEntity = newType.method_5883((class_1937)world, class_3730.field_16461);
        if (newEntity == null) {
            return null;
        }
        newEntity.method_5719(entity);
        if (doInit && entity instanceof class_1308) {
            ((class_1308)newEntity).method_5943((class_5425)world, world.method_8404(newEntity.method_24515()), class_3730.field_16461, null);
        }
        if (entity instanceof class_1308) {
            class_1308 mobEntity = (class_1308)entity;
            if (newEntity instanceof class_1308) {
                class_1308 newMobEntity = (class_1308)newEntity;
                if (mobEntity.method_5947()) {
                    newMobEntity.method_5971();
                }
            }
        }
        if (entity.method_5765()) {
            newEntity.method_5873(entity.method_5854(), true);
        }
        newEntity.method_5780(TAG_ID);
        return newEntity;
    }

    private static void config() {
        String path = "%s%s%s.toml".formatted(FabricLoader.getInstance().getConfigDir(), File.separator, MOD_ID);
        File configFile = new File(path);
        blacklist.clear();
        if (configFile.exists()) {
            try {
                List<String> entityNames = TomlHelper.parseStringList(configFile, "blacklist");
                if (entityNames != null) {
                    for (String entityName : entityNames) {
                        for (class_1299 entity : class_7923.field_41177) {
                            if (!entity.method_35050().equals(entityName)) continue;
                            blacklist.add(entity);
                        }
                    }
                    LOGGER.info("Loaded blacklist : {}", blacklist);
                    return;
                }
                LOGGER.error("The 'blacklist' key is empty in the config file. Loading default blacklist values.");
            }
            catch (IOException e) {
                LOGGER.error("Failed to read config file with error : {}\nLoading default blacklist values.", (Object)e.getMessage());
            }
        } else {
            LOGGER.info("Initializing the config file...");
            ArrayList<String> defaultNames = new ArrayList<String>();
            for (class_1299<?> type : DEFAULT_BLACKLIST) {
                defaultNames.add(type.method_35050());
            }
            try {
                TomlHelper.writeStringList(configFile, "blacklist", defaultNames);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create default config file at {}: {}", (Object)path, (Object)e.getMessage());
            }
        }
        blacklist.addAll(Arrays.asList(DEFAULT_BLACKLIST));
    }

    private void onWorldLoad(MinecraftServer server, class_3218 world) {
        MobRandomizerMod.config();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        RANDOMIZER.clear();
        COMPLIMENT.clear();
        for (class_1299 entity : class_7923.field_41177) {
            if (!MobRandomizerMod.canRandomize(entity)) continue;
            int id = class_7923.field_41177.method_10206((Object)entity);
            ids.add(id);
        }
        Random random = new Random(world.method_8412());
        Collections.shuffle(ids, random);
        int size = ids.size();
        int i = 0;
        while (i + 1 < size) {
            int id1 = (Integer)ids.get(i);
            int id2 = (Integer)ids.get(i + 1);
            RANDOMIZER.put(id1, id2);
            RANDOMIZER.put(id2, id1);
            COMPLIMENT.put(id1, id2);
            COMPLIMENT.put(id2, id1);
            LOGGER.info("Mapping {} <-> {}", class_7923.field_41177.method_10200(id1), class_7923.field_41177.method_10200(id2));
            i += 2;
        }
        if (size % 2 != 0) {
            int lastId = (Integer)ids.get(size - 1);
            RANDOMIZER.put(lastId, lastId);
            COMPLIMENT.put(lastId, lastId);
            LOGGER.info("Mapping {} <-> {} (self mapping)", class_7923.field_41177.method_10200(lastId), class_7923.field_41177.method_10200(lastId));
        }
    }

    private void onServerTick(MinecraftServer server) {
        if (server.method_3780() % 20 == 0) {
            for (class_3218 world : server.method_3738()) {
                for (class_3222 player : world.method_18456()) {
                    ArrayList entities = (ArrayList)world.method_8390(class_1297.class, new class_238(player.method_23317() - 256.0, player.method_23318() - 256.0, player.method_23321() - 256.0, player.method_23317() + 256.0, player.method_23318() + 256.0, player.method_23321() + 256.0), entity -> !entity.method_5752().contains(TAG_ID) && entity.method_5805() && entity instanceof class_1308);
                    for (class_1297 entity2 : entities) {
                        if (entity2 == null || entity2.method_5752().contains(TAG_ID) || !MobRandomizerMod.canRandomize(entity2.method_5864())) continue;
                        class_1297 newEntity = MobRandomizerMod.createRandomizedEntity(world, entity2, true);
                        if (newEntity instanceof class_1308) {
                            class_1308 newMobEntity = (class_1308)newEntity;
                            newMobEntity.method_5971();
                        }
                        if (newEntity == null) continue;
                        entity2.method_31472();
                        world.method_8649(newEntity);
                    }
                }
            }
        }
    }

    public void onInitialize() {
        ServerTickEvents.END_SERVER_TICK.register(this::onServerTick);
        ServerWorldEvents.LOAD.register(this::onWorldLoad);
    }
}

