/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.block.custom;

import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.rezolv.obsidanum.block.entity.ForgeCrucibleEntity;
import net.rezolv.obsidanum.block.enum_blocks.ScrollType;
import net.rezolv.obsidanum.block.forge_crucible.neigbor_changed.AddTagsForgeCrucible;
import net.rezolv.obsidanum.block.forge_crucible.neigbor_changed.LeftCornerCompleteRecipe;
import net.rezolv.obsidanum.gui.forge_crucible.recipes_render.ForgeCrucibleGuiMenu;
import net.rezolv.obsidanum.gui.forge_crucible.repair_render.ForgeCrucibleRepairMenu;
import org.jetbrains.annotations.Nullable;

public class ForgeCrucible
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public ForgeCrucible(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, final BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof ForgeCrucibleEntity)) {
            return InteractionResult.PASS;
        }
        ForgeCrucibleEntity crucible = (ForgeCrucibleEntity)be;
        if (player instanceof ServerPlayer) {
            ServerPlayer server = (ServerPlayer)player;
            String typeName = crucible.getReceivedData().m_128461_("TypeScroll");
            final ScrollType type = ScrollType.valueOf(typeName.isEmpty() ? "NONE" : typeName);
            MenuProvider provider = new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237115_((String)(type == ScrollType.NONE ? "container.obsidanum.forge_crucible_repair" : "container.obsidanum.forge_crucible"));
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inv, Player ply) {
                    FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer()).m_130064_(pos);
                    if (type == ScrollType.NETHER || type == ScrollType.CATACOMBS || type == ScrollType.ORDER) {
                        return new ForgeCrucibleGuiMenu(id, inv, buf);
                    }
                    return new ForgeCrucibleRepairMenu(id, inv, buf);
                }
            };
            NetworkHooks.openScreen((ServerPlayer)server, (MenuProvider)provider, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        AddTagsForgeCrucible.handleNeighborUpdate(state, level, pos, fromPos);
        LeftCornerCompleteRecipe.handleNeighborUpdate(state, level, pos, fromPos);
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ForgeCrucibleEntity(pPos, pState);
    }
}

