/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.block.custom;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.rezolv.obsidanum.block.BlocksObs;
import net.rezolv.obsidanum.block.custom.LeftCornerLevel;
import net.rezolv.obsidanum.block.entity.HammerForgeEntity;
import net.rezolv.obsidanum.sound.SoundsObs;
import org.jetbrains.annotations.Nullable;

public class HammerForge
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final Map<BlockPos, Integer> tickCounters = new HashMap<BlockPos, Integer>();

    public HammerForge(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED});
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean hasPressedCorner;
        if (level.f_46443_) {
            return;
        }
        boolean shouldBePowered = hasPressedCorner = this.checkForPressedCorners(level, pos);
        if (!((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && shouldBePowered) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
            level.m_186460_(pos, (Block)this, 2);
        } else if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && !shouldBePowered) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean isPowered = this.checkForPressedCorners((Level)level, pos);
        if ((Boolean)state.m_61143_((Property)POWERED) != isPowered) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)), 3);
            if (!isPowered) {
                tickCounters.remove(pos);
            } else {
                tickCounters.put(pos, 0);
            }
        }
        if (isPowered && tickCounters.containsKey(pos)) {
            level.m_5594_(null, pos, (SoundEvent)SoundsObs.HAMMER_FORGE.get(), SoundSource.BLOCKS, 1.5f, 1.0f);
            tickCounters.remove(pos);
        }
        level.m_186460_(pos, (Block)this, 1);
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!oldState.m_60713_(newState.m_60734_())) {
            tickCounters.remove(pos);
        }
        super.m_6810_(oldState, level, pos, newState, isMoving);
    }

    public boolean checkForPressedCorners(Level level, BlockPos centerPos) {
        if (level.f_46443_) {
            return false;
        }
        int radius = 4;
        int radiusSquared = radius * radius;
        Block cornerBlock = (Block)BlocksObs.LEFT_CORNER_LEVEL.get();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos checkPos;
                    BlockState state;
                    if (x * x + y * y + z * z > radiusSquared || (state = level.m_8055_(checkPos = centerPos.m_7918_(x, y, z))).m_60734_() != cornerBlock || !state.m_61138_((Property)LeftCornerLevel.IS_PRESSED) || !((Boolean)state.m_61143_((Property)LeftCornerLevel.IS_PRESSED)).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        return level.m_8055_(blockpos).m_60783_((BlockGetter)level, blockpos, direction);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new HammerForgeEntity(blockPos, blockState);
    }
}

