/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.block.custom;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.rezolv.obsidanum.block.BlocksObs;

public class NetherFireBlock
extends BaseFireBlock {
    public static final int MAX_AGE = 15;
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter(p_53467_ -> p_53467_.getKey() != Direction.DOWN).collect(Util.m_137448_());
    private static final VoxelShape UP_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;
    private static final int IGNITE_INSTANT = 60;
    private static final int IGNITE_EASY = 30;
    private static final int IGNITE_MEDIUM = 15;
    private static final int IGNITE_HARD = 5;
    private static final int BURN_INSTANT = 100;
    private static final int BURN_EASY = 60;
    private static final int BURN_MEDIUM = 20;
    private static final int BURN_HARD = 5;
    private final Object2IntMap<Block> igniteOdds = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> burnOdds = new Object2IntOpenHashMap();
    private float fireDamage;

    public NetherFireBlock(BlockBehaviour.Properties p_53425_) {
        super(p_53425_, 4.0f);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.f_49792_.m_61056_().stream().filter(p_53497_ -> (Integer)p_53497_.m_61143_((Property)AGE) == 0).collect(Collectors.toMap(Function.identity(), NetherFireBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState p_53491_) {
        VoxelShape voxelshape = Shapes.m_83040_();
        if (((Boolean)p_53491_.m_61143_((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)p_53491_.m_61143_((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)p_53491_.m_61143_((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)p_53491_.m_61143_((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)p_53491_.m_61143_((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.m_83281_() ? f_49237_ : voxelshape;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos) ? this.getStateWithAge(pLevel, pCurrentPos, (Integer)pState.m_61143_((Property)AGE)) : Blocks.f_50016_.m_49966_();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapesCache.get(pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return this.getStateForPlacement((BlockGetter)pContext.m_43725_(), pContext.m_8083_());
    }

    protected BlockState getStateForPlacement(BlockGetter pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7495_();
        BlockState blockstate = pLevel.m_8055_(blockpos);
        if (!this.canCatchFire(pLevel, pPos, Direction.UP) && !blockstate.m_60783_(pLevel, blockpos, Direction.UP)) {
            BlockState blockstate1 = this.m_49966_();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)blockstate1.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(this.canCatchFire(pLevel, pPos.m_121945_(direction), direction.m_122424_())));
            }
            return blockstate1;
        }
        return this.m_49966_();
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!pEntity.m_5825_()) {
            pEntity.m_7311_(pEntity.m_20094_() + 1);
            if (pEntity.m_20094_() == 0) {
                pEntity.m_20254_(12);
            }
        }
        pEntity.m_6469_(pLevel.m_269111_().m_269387_(), this.fireDamage);
        super.m_7892_(pState, pLevel, pPos, pEntity);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7495_();
        return pLevel.m_8055_(blockpos).m_60783_((BlockGetter)pLevel, blockpos, Direction.UP) || this.isValidFireLocation((BlockGetter)pLevel, pPos) || NetherFireBlock.canSurviveOnBlock(pLevel.m_8055_(pPos.m_7495_()));
    }

    public static boolean canSurviveOnBlock(BlockState pState) {
        return pState.m_204336_(BlockTags.f_13085_);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.m_186460_(pPos, (Block)this, NetherFireBlock.getFireTickDelay(pLevel.f_46441_));
        if (pLevel.m_46469_().m_46207_(GameRules.f_46131_)) {
            boolean flag1;
            if (!pState.m_60710_((LevelReader)pLevel, pPos)) {
                // empty if block
            }
            BlockState blockstate = pLevel.m_8055_(pPos.m_7495_());
            boolean flag = blockstate.isFireSource((LevelReader)pLevel, pPos, Direction.UP);
            int i = (Integer)pState.m_61143_((Property)AGE);
            if (!flag && pLevel.m_46471_() && this.isNearRain((Level)pLevel, pPos) && pRandom.m_188501_() < 0.1f + (float)i * 0.03f) {
                pLevel.m_7471_(pPos, false);
                return;
            }
            int j = Math.min(15, i + pRandom.m_188503_(4) / 2);
            if (i != j) {
                pState = (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(j));
                pLevel.m_7731_(pPos, pState, 4);
            }
            if (!flag) {
                if (!this.isValidFireLocation((BlockGetter)pLevel, pPos)) {
                    BlockPos blockpos = pPos.m_7495_();
                    if (!pLevel.m_8055_(blockpos).m_60783_((BlockGetter)pLevel, blockpos, Direction.UP) || i > 3) {
                        pLevel.m_7471_(pPos, false);
                    }
                    return;
                }
                if (i == 15 && pRandom.m_188503_(4) == 0 && !this.canCatchFire((BlockGetter)pLevel, pPos.m_7495_(), Direction.UP)) {
                    pLevel.m_7471_(pPos, false);
                    return;
                }
            }
            int k = (flag1 = pLevel.m_204166_(pPos).m_203656_(BiomeTags.f_263839_)) ? -50 : 0;
            this.tryCatchFire((Level)pLevel, pPos.m_122029_(), 250 + k, pRandom, i, Direction.WEST);
            this.tryCatchFire((Level)pLevel, pPos.m_122024_(), 250 + k, pRandom, i, Direction.EAST);
            this.tryCatchFire((Level)pLevel, pPos.m_7495_(), 200 + k, pRandom, i, Direction.UP);
            this.tryCatchFire((Level)pLevel, pPos.m_7494_(), 200 + k, pRandom, i, Direction.DOWN);
            this.tryCatchFire((Level)pLevel, pPos.m_122012_(), 250 + k, pRandom, i, Direction.SOUTH);
            this.tryCatchFire((Level)pLevel, pPos.m_122019_(), 250 + k, pRandom, i, Direction.NORTH);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int l = -1; l <= 1; ++l) {
                for (int i1 = -1; i1 <= 1; ++i1) {
                    for (int j1 = -1; j1 <= 4; ++j1) {
                        if (l == 0 && j1 == 0 && i1 == 0) continue;
                        int k1 = 100;
                        if (j1 > 1) {
                            k1 += (j1 - 1) * 100;
                        }
                        blockpos$mutableblockpos.m_122154_((Vec3i)pPos, l, j1, i1);
                        int l1 = this.getIgniteOdds((LevelReader)pLevel, (BlockPos)blockpos$mutableblockpos);
                        if (l1 <= 0) continue;
                        int i2 = (l1 + 40 + pLevel.m_46791_().m_19028_() * 7) / (i + 20);
                        if (flag1) {
                            i2 /= 2;
                        }
                        if (i2 <= 0 || pRandom.m_188503_(k1) > i2 || pLevel.m_46471_() && this.isNearRain((Level)pLevel, (BlockPos)blockpos$mutableblockpos)) continue;
                        int j2 = Math.min(15, i + pRandom.m_188503_(6) / 4);
                        pLevel.m_7731_((BlockPos)blockpos$mutableblockpos, this.getStateWithAge((LevelAccessor)pLevel, (BlockPos)blockpos$mutableblockpos, j2), 3);
                    }
                }
            }
        }
    }

    protected boolean isNearRain(Level pLevel, BlockPos pPos) {
        return pLevel.m_46758_(pPos) || pLevel.m_46758_(pPos.m_122024_()) || pLevel.m_46758_(pPos.m_122029_()) || pLevel.m_46758_(pPos.m_122012_()) || pLevel.m_46758_(pPos.m_122019_());
    }

    @Deprecated
    public int getBurnOdds(BlockState pState) {
        return pState.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? 0 : this.burnOdds.getInt((Object)pState.m_60734_());
    }

    @Deprecated
    public int getIgniteOdds(BlockState pState) {
        return pState.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? 0 : this.igniteOdds.getInt((Object)pState.m_60734_());
    }

    private void tryCatchFire(Level level, BlockPos blockPos, int flammabilityChance, RandomSource random, int fireChanceThreshold, Direction direction) {
        int flammability = level.m_8055_(blockPos).getFlammability((BlockGetter)level, blockPos, direction);
        if (random.m_188503_(flammabilityChance / 2) < flammability) {
            BlockState blockState = level.m_8055_(blockPos);
            blockState.onCaughtFire(level, blockPos, direction, null);
            if (random.m_188503_((flammabilityChance + 10) / 2) < 5 && !level.m_46758_(blockPos)) {
                int fireAge = Math.min(flammabilityChance + random.m_188503_(5) / 4, 15);
                level.m_7731_(blockPos, this.getStateWithAge((LevelAccessor)level, blockPos, fireAge), 3);
            } else {
                level.m_7471_(blockPos, false);
            }
        }
    }

    private BlockState getStateWithAge(LevelAccessor pLevel, BlockPos pPos, int pAge) {
        BlockState blockstate = NetherFireBlock.m_49245_((BlockGetter)pLevel, pPos);
        return blockstate.m_60713_((Block)BlocksObs.NETHER_FIRE.get()) ? (BlockState)blockstate.m_61124_((Property)AGE, (Comparable)Integer.valueOf(pAge)) : blockstate;
    }

    private boolean isValidFireLocation(BlockGetter pLevel, BlockPos pPos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(pLevel, pPos.m_121945_(direction), direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    private int getIgniteOdds(LevelReader pLevel, BlockPos pPos) {
        if (!pLevel.m_46859_(pPos)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockstate = pLevel.m_8055_(pPos.m_121945_(direction));
            i = Math.max(blockstate.getFireSpreadSpeed((BlockGetter)pLevel, pPos.m_121945_(direction), direction.m_122424_()), i);
        }
        return i;
    }

    @Deprecated
    protected boolean m_7599_(BlockState pState) {
        return this.getIgniteOdds(pState) > 0;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        pLevel.m_186460_(pPos, (Block)this, NetherFireBlock.getFireTickDelay(pLevel.f_46441_));
    }

    private static int getFireTickDelay(RandomSource pRandom) {
        return 30 + pRandom.m_188503_(10);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE, NORTH, EAST, SOUTH, WEST, UP});
    }

    public static BlockState m_49245_(BlockGetter pReader, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7495_();
        BlockState blockstate = pReader.m_8055_(blockpos);
        return NetherFireBlock.canSurviveOnBlock(blockstate) ? ((Block)BlocksObs.NETHER_FIRE_SOUL.get()).m_49966_() : ((NetherFireBlock)((Object)BlocksObs.NETHER_FIRE.get())).getStateForPlacement(pReader, pPos);
    }

    private void setFlammable(Block pBlock, int pEncouragement, int pFlammability) {
        if (pBlock == Blocks.f_50016_) {
            throw new IllegalArgumentException("Tried to set air on fire... This is bad.");
        }
        this.igniteOdds.put((Object)pBlock, pEncouragement);
        this.burnOdds.put((Object)pBlock, pFlammability);
    }

    public boolean canCatchFire(BlockGetter world, BlockPos pos, Direction face) {
        return world.m_8055_(pos).isFlammable(world, pos, face);
    }

    public static void bootStrap() {
        NetherFireBlock fireblock = (NetherFireBlock)((Object)BlocksObs.NETHER_FIRE.get());
        fireblock.setFlammable(Blocks.f_50705_, 5, 20);
        fireblock.setFlammable(Blocks.f_50741_, 5, 20);
        fireblock.setFlammable(Blocks.f_50742_, 5, 20);
        fireblock.setFlammable(Blocks.f_50743_, 5, 20);
        fireblock.setFlammable(Blocks.f_50744_, 5, 20);
        fireblock.setFlammable(Blocks.f_271304_, 5, 20);
        fireblock.setFlammable(Blocks.f_50745_, 5, 20);
        fireblock.setFlammable(Blocks.f_220865_, 5, 20);
        fireblock.setFlammable(Blocks.f_244477_, 5, 20);
        fireblock.setFlammable(Blocks.f_244489_, 5, 20);
        fireblock.setFlammable(Blocks.f_50398_, 5, 20);
        fireblock.setFlammable(Blocks.f_50399_, 5, 20);
        fireblock.setFlammable(Blocks.f_50400_, 5, 20);
        fireblock.setFlammable(Blocks.f_50401_, 5, 20);
        fireblock.setFlammable(Blocks.f_50402_, 5, 20);
        fireblock.setFlammable(Blocks.f_271301_, 5, 20);
        fireblock.setFlammable(Blocks.f_50403_, 5, 20);
        fireblock.setFlammable(Blocks.f_220851_, 5, 20);
        fireblock.setFlammable(Blocks.f_244004_, 5, 20);
        fireblock.setFlammable(Blocks.f_244230_, 5, 20);
        fireblock.setFlammable(Blocks.f_50192_, 5, 20);
        fireblock.setFlammable(Blocks.f_50474_, 5, 20);
        fireblock.setFlammable(Blocks.f_50475_, 5, 20);
        fireblock.setFlammable(Blocks.f_50476_, 5, 20);
        fireblock.setFlammable(Blocks.f_50477_, 5, 20);
        fireblock.setFlammable(Blocks.f_271274_, 5, 20);
        fireblock.setFlammable(Blocks.f_50478_, 5, 20);
        fireblock.setFlammable(Blocks.f_220850_, 5, 20);
        fireblock.setFlammable(Blocks.f_244313_, 5, 20);
        fireblock.setFlammable(Blocks.f_50132_, 5, 20);
        fireblock.setFlammable(Blocks.f_50479_, 5, 20);
        fireblock.setFlammable(Blocks.f_50480_, 5, 20);
        fireblock.setFlammable(Blocks.f_50481_, 5, 20);
        fireblock.setFlammable(Blocks.f_50482_, 5, 20);
        fireblock.setFlammable(Blocks.f_271219_, 5, 20);
        fireblock.setFlammable(Blocks.f_50483_, 5, 20);
        fireblock.setFlammable(Blocks.f_220852_, 5, 20);
        fireblock.setFlammable(Blocks.f_244641_, 5, 20);
        fireblock.setFlammable(Blocks.f_50086_, 5, 20);
        fireblock.setFlammable(Blocks.f_50270_, 5, 20);
        fireblock.setFlammable(Blocks.f_50269_, 5, 20);
        fireblock.setFlammable(Blocks.f_50271_, 5, 20);
        fireblock.setFlammable(Blocks.f_50372_, 5, 20);
        fireblock.setFlammable(Blocks.f_271206_, 5, 20);
        fireblock.setFlammable(Blocks.f_50373_, 5, 20);
        fireblock.setFlammable(Blocks.f_220848_, 5, 20);
        fireblock.setFlammable(Blocks.f_243755_, 5, 20);
        fireblock.setFlammable(Blocks.f_244193_, 5, 20);
        fireblock.setFlammable(Blocks.f_49999_, 5, 5);
        fireblock.setFlammable(Blocks.f_50000_, 5, 5);
        fireblock.setFlammable(Blocks.f_50001_, 5, 5);
        fireblock.setFlammable(Blocks.f_50002_, 5, 5);
        fireblock.setFlammable(Blocks.f_50003_, 5, 5);
        fireblock.setFlammable(Blocks.f_271170_, 5, 5);
        fireblock.setFlammable(Blocks.f_50004_, 5, 5);
        fireblock.setFlammable(Blocks.f_220832_, 5, 5);
        fireblock.setFlammable(Blocks.f_256831_, 5, 5);
        fireblock.setFlammable(Blocks.f_50010_, 5, 5);
        fireblock.setFlammable(Blocks.f_50005_, 5, 5);
        fireblock.setFlammable(Blocks.f_50006_, 5, 5);
        fireblock.setFlammable(Blocks.f_50007_, 5, 5);
        fireblock.setFlammable(Blocks.f_50008_, 5, 5);
        fireblock.setFlammable(Blocks.f_271326_, 5, 5);
        fireblock.setFlammable(Blocks.f_50009_, 5, 5);
        fireblock.setFlammable(Blocks.f_220835_, 5, 5);
        fireblock.setFlammable(Blocks.f_256740_, 5, 5);
        fireblock.setFlammable(Blocks.f_50044_, 5, 5);
        fireblock.setFlammable(Blocks.f_50045_, 5, 5);
        fireblock.setFlammable(Blocks.f_50046_, 5, 5);
        fireblock.setFlammable(Blocks.f_50047_, 5, 5);
        fireblock.setFlammable(Blocks.f_50048_, 5, 5);
        fireblock.setFlammable(Blocks.f_271145_, 5, 5);
        fireblock.setFlammable(Blocks.f_50049_, 5, 5);
        fireblock.setFlammable(Blocks.f_220837_, 5, 5);
        fireblock.setFlammable(Blocks.f_50011_, 5, 5);
        fireblock.setFlammable(Blocks.f_50012_, 5, 5);
        fireblock.setFlammable(Blocks.f_50013_, 5, 5);
        fireblock.setFlammable(Blocks.f_50014_, 5, 5);
        fireblock.setFlammable(Blocks.f_50015_, 5, 5);
        fireblock.setFlammable(Blocks.f_271348_, 5, 5);
        fireblock.setFlammable(Blocks.f_50043_, 5, 5);
        fireblock.setFlammable(Blocks.f_220836_, 5, 5);
        fireblock.setFlammable(Blocks.f_220833_, 5, 20);
        fireblock.setFlammable(Blocks.f_50050_, 30, 60);
        fireblock.setFlammable(Blocks.f_50051_, 30, 60);
        fireblock.setFlammable(Blocks.f_50052_, 30, 60);
        fireblock.setFlammable(Blocks.f_50053_, 30, 60);
        fireblock.setFlammable(Blocks.f_50054_, 30, 60);
        fireblock.setFlammable(Blocks.f_271115_, 30, 60);
        fireblock.setFlammable(Blocks.f_50055_, 30, 60);
        fireblock.setFlammable(Blocks.f_220838_, 30, 60);
        fireblock.setFlammable(Blocks.f_50078_, 30, 20);
        fireblock.setFlammable(Blocks.f_50077_, 15, 100);
        fireblock.setFlammable(Blocks.f_50034_, 60, 100);
        fireblock.setFlammable(Blocks.f_50035_, 60, 100);
        fireblock.setFlammable(Blocks.f_50036_, 60, 100);
        fireblock.setFlammable(Blocks.f_50355_, 60, 100);
        fireblock.setFlammable(Blocks.f_50356_, 60, 100);
        fireblock.setFlammable(Blocks.f_50357_, 60, 100);
        fireblock.setFlammable(Blocks.f_50358_, 60, 100);
        fireblock.setFlammable(Blocks.f_50359_, 60, 100);
        fireblock.setFlammable(Blocks.f_50360_, 60, 100);
        fireblock.setFlammable(Blocks.f_50111_, 60, 100);
        fireblock.setFlammable(Blocks.f_50112_, 60, 100);
        fireblock.setFlammable(Blocks.f_50113_, 60, 100);
        fireblock.setFlammable(Blocks.f_50114_, 60, 100);
        fireblock.setFlammable(Blocks.f_50115_, 60, 100);
        fireblock.setFlammable(Blocks.f_50116_, 60, 100);
        fireblock.setFlammable(Blocks.f_50117_, 60, 100);
        fireblock.setFlammable(Blocks.f_50118_, 60, 100);
        fireblock.setFlammable(Blocks.f_50119_, 60, 100);
        fireblock.setFlammable(Blocks.f_50120_, 60, 100);
        fireblock.setFlammable(Blocks.f_50121_, 60, 100);
        fireblock.setFlammable(Blocks.f_50071_, 60, 100);
        fireblock.setFlammable(Blocks.f_271329_, 60, 100);
        fireblock.setFlammable(Blocks.f_276668_, 60, 100);
        fireblock.setFlammable(Blocks.f_50070_, 60, 100);
        fireblock.setFlammable(Blocks.f_271445_, 60, 100);
        fireblock.setFlammable(Blocks.f_50041_, 30, 60);
        fireblock.setFlammable(Blocks.f_50042_, 30, 60);
        fireblock.setFlammable(Blocks.f_50096_, 30, 60);
        fireblock.setFlammable(Blocks.f_50097_, 30, 60);
        fireblock.setFlammable(Blocks.f_50098_, 30, 60);
        fireblock.setFlammable(Blocks.f_50099_, 30, 60);
        fireblock.setFlammable(Blocks.f_50100_, 30, 60);
        fireblock.setFlammable(Blocks.f_50101_, 30, 60);
        fireblock.setFlammable(Blocks.f_50102_, 30, 60);
        fireblock.setFlammable(Blocks.f_50103_, 30, 60);
        fireblock.setFlammable(Blocks.f_50104_, 30, 60);
        fireblock.setFlammable(Blocks.f_50105_, 30, 60);
        fireblock.setFlammable(Blocks.f_50106_, 30, 60);
        fireblock.setFlammable(Blocks.f_50107_, 30, 60);
        fireblock.setFlammable(Blocks.f_50108_, 30, 60);
        fireblock.setFlammable(Blocks.f_50109_, 30, 60);
        fireblock.setFlammable(Blocks.f_50191_, 15, 100);
        fireblock.setFlammable(Blocks.f_50353_, 5, 5);
        fireblock.setFlammable(Blocks.f_50335_, 60, 20);
        fireblock.setFlammable(Blocks.f_50716_, 15, 20);
        fireblock.setFlammable(Blocks.f_50336_, 60, 20);
        fireblock.setFlammable(Blocks.f_50337_, 60, 20);
        fireblock.setFlammable(Blocks.f_50338_, 60, 20);
        fireblock.setFlammable(Blocks.f_50339_, 60, 20);
        fireblock.setFlammable(Blocks.f_50340_, 60, 20);
        fireblock.setFlammable(Blocks.f_50341_, 60, 20);
        fireblock.setFlammable(Blocks.f_50342_, 60, 20);
        fireblock.setFlammable(Blocks.f_50343_, 60, 20);
        fireblock.setFlammable(Blocks.f_50344_, 60, 20);
        fireblock.setFlammable(Blocks.f_50345_, 60, 20);
        fireblock.setFlammable(Blocks.f_50346_, 60, 20);
        fireblock.setFlammable(Blocks.f_50347_, 60, 20);
        fireblock.setFlammable(Blocks.f_50348_, 60, 20);
        fireblock.setFlammable(Blocks.f_50349_, 60, 20);
        fireblock.setFlammable(Blocks.f_50350_, 60, 20);
        fireblock.setFlammable(Blocks.f_50351_, 60, 20);
        fireblock.setFlammable(Blocks.f_50577_, 30, 60);
        fireblock.setFlammable(Blocks.f_50571_, 60, 60);
        fireblock.setFlammable(Blocks.f_50616_, 60, 60);
        fireblock.setFlammable(Blocks.f_50624_, 30, 20);
        fireblock.setFlammable(Blocks.f_50715_, 5, 20);
        fireblock.setFlammable(Blocks.f_50685_, 60, 100);
        fireblock.setFlammable(Blocks.f_50718_, 5, 20);
        fireblock.setFlammable(Blocks.f_50717_, 30, 20);
        fireblock.setFlammable(Blocks.f_152470_, 30, 60);
        fireblock.setFlammable(Blocks.f_152471_, 30, 60);
        fireblock.setFlammable(Blocks.f_152538_, 15, 60);
        fireblock.setFlammable(Blocks.f_152539_, 15, 60);
        fireblock.setFlammable(Blocks.f_152540_, 60, 100);
        fireblock.setFlammable(Blocks.f_152541_, 30, 60);
        fireblock.setFlammable(Blocks.f_152542_, 30, 60);
        fireblock.setFlammable(Blocks.f_152545_, 60, 100);
        fireblock.setFlammable(Blocks.f_152546_, 60, 100);
        fireblock.setFlammable(Blocks.f_152547_, 60, 100);
        fireblock.setFlammable(Blocks.f_152548_, 30, 60);
        fireblock.setFlammable(Blocks.f_152475_, 15, 100);
    }
}

