/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.rezolv.obsidanum.block.custom.obsidian_door.DoorPart;
import net.rezolv.obsidanum.item.ItemsObs;
import net.rezolv.obsidanum.sound.SoundsObs;

public class ObsidianDoor
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty ALL_ACTIVE = BooleanProperty.m_61465_((String)"all_active");
    public static final EnumProperty<DoorPart> PART = EnumProperty.m_61587_((String)"part", DoorPart.class);
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);

    public ObsidianDoor(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ALL_ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)DoorPart.BC)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, ACTIVE, ALL_ACTIVE, PART});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.f_46443_ && state.m_61143_(PART) == DoorPart.BC) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            this.createDoorStructure(level, pos, facing);
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return Shapes.m_83040_();
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return switch (facing) {
            case Direction.NORTH -> Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
            case Direction.SOUTH -> Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
            case Direction.EAST -> Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
            case Direction.WEST -> Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
            default -> SHAPE;
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return switch (facing) {
            case Direction.NORTH -> Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
            case Direction.SOUTH -> Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
            case Direction.EAST -> Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
            case Direction.WEST -> Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
            default -> SHAPE;
        };
    }

    private void createDoorStructure(Level level, BlockPos basePos, Direction facing) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = 0; dy < 3; ++dy) {
                DoorPart part;
                BlockPos placePos = basePos.m_5484_(facing.m_122427_(), dx).m_6630_(dy);
                if (!level.m_8055_(placePos).m_60795_() || (part = this.determinePart(dx, dy)) == DoorPart.BC) continue;
                level.m_7731_(placePos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(PART, (Comparable)((Object)part)), 3);
            }
        }
    }

    private DoorPart determinePart(int dx, int dy) {
        return switch (dy) {
            case 0 -> {
                switch (dx) {
                    case -1: {
                        yield DoorPart.BL;
                    }
                    case 0: {
                        yield DoorPart.BC;
                    }
                    case 1: {
                        yield DoorPart.BR;
                    }
                }
                yield DoorPart.BC;
            }
            case 1 -> {
                switch (dx) {
                    case -1: {
                        yield DoorPart.CL;
                    }
                    case 0: {
                        yield DoorPart.C;
                    }
                    case 1: {
                        yield DoorPart.CR;
                    }
                }
                yield DoorPart.C;
            }
            case 2 -> {
                switch (dx) {
                    case -1: {
                        yield DoorPart.TL;
                    }
                    case 0: {
                        yield DoorPart.TC;
                    }
                    case 1: {
                        yield DoorPart.TR;
                    }
                }
                yield DoorPart.TC;
            }
            default -> DoorPart.BC;
        };
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockPos basePos;
        DoorPart part = (DoorPart)((Object)state.m_61143_(PART));
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (!(player.m_21120_(hand).m_41720_() != ItemsObs.OBSIDIAN_KEY.get() || part != DoorPart.C && part != DoorPart.CL && part != DoorPart.CR || ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue())) {
            player.m_21120_(hand).m_41774_(1);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
            world.m_5594_(null, pos, SoundEvents.f_11859_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.checkAndUpdateAllActive(world, pos, facing);
            return InteractionResult.SUCCESS;
        }
        if (!world.m_5776_() && this.checkCenterPartsActive(world, basePos = this.findBaseFromAnyPart(pos, facing, part), facing)) {
            boolean newOpenState = (Boolean)state.m_61143_((Property)OPEN) == false;
            this.updateAllParts(world, basePos, facing, newOpenState);
            SoundEvent sound = newOpenState ? (SoundEvent)SoundsObs.OPEN_OBSIDIAN_DOOR.get() : (SoundEvent)SoundsObs.CLOSE_OBSIDIAN_DOOR.get();
            world.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    private void checkAndUpdateAllActive(Level level, BlockPos pos, Direction facing) {
        BlockPos basePos = this.findBaseFromAnyPart(pos, facing, (DoorPart)((Object)level.m_8055_(pos).m_61143_(PART)));
        BlockPos cPos = basePos.m_6630_(1);
        BlockPos clPos = cPos.m_121945_(facing.m_122428_());
        BlockPos crPos = cPos.m_121945_(facing.m_122427_());
        boolean allActive = this.isPartActive(level, cPos, facing) && this.isPartActive(level, clPos, facing) && this.isPartActive(level, crPos, facing);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = 0; dy < 3; ++dy) {
                BlockPos partPos = basePos.m_5484_(facing.m_122427_(), dx).m_6630_(dy);
                BlockState partState = level.m_8055_(partPos);
                if (partState.m_60734_() != this) continue;
                level.m_7731_(partPos, (BlockState)partState.m_61124_((Property)ALL_ACTIVE, (Comparable)Boolean.valueOf(allActive)), 3);
            }
        }
    }

    private BlockPos findBaseFromAnyPart(BlockPos anyPartPos, Direction facing, DoorPart part) {
        int dx = switch (part) {
            default -> throw new IncompatibleClassChangeError();
            case DoorPart.BL, DoorPart.CL, DoorPart.TL -> -1;
            case DoorPart.BC, DoorPart.C, DoorPart.TC -> 0;
            case DoorPart.BR, DoorPart.CR, DoorPart.TR -> 1;
        };
        int dy = switch (part) {
            default -> throw new IncompatibleClassChangeError();
            case DoorPart.BL, DoorPart.BC, DoorPart.BR -> 0;
            case DoorPart.CL, DoorPart.C, DoorPart.CR -> 1;
            case DoorPart.TL, DoorPart.TC, DoorPart.TR -> 2;
        };
        return anyPartPos.m_5484_(facing.m_122427_(), -dx).m_6625_(dy);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.f_46443_ && state.m_60734_() != newState.m_60734_()) {
            if (state.m_61143_(PART) != DoorPart.BC) {
                BlockPos basePos = this.findBaseFromAnyPart(pos, (Direction)state.m_61143_((Property)FACING), (DoorPart)((Object)state.m_61143_(PART)));
                BlockState baseState = level.m_8055_(basePos);
                if (baseState.m_60734_() == this) {
                    this.breakDoorStructure(level, basePos, (Direction)state.m_61143_((Property)FACING));
                }
            } else {
                this.breakDoorStructure(level, pos, (Direction)state.m_61143_((Property)FACING));
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    private void breakDoorStructure(Level level, BlockPos basePos, Direction facing) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = 0; dy < 3; ++dy) {
                BlockPos partPos = basePos.m_5484_(facing.m_122427_(), dx).m_6630_(dy);
                BlockState partState = level.m_8055_(partPos);
                if (partState.m_60734_() != this) continue;
                level.m_46961_(partPos, true);
            }
        }
    }

    private boolean checkCenterPartsActive(Level level, BlockPos basePos, Direction facing) {
        BlockPos cPos = basePos.m_6630_(1);
        BlockPos clPos = cPos.m_121945_(facing.m_122428_());
        BlockPos crPos = cPos.m_121945_(facing.m_122427_());
        return this.isPartActive(level, cPos, facing) && this.isPartActive(level, clPos, facing) && this.isPartActive(level, crPos, facing);
    }

    private boolean isPartActive(Level level, BlockPos pos, Direction facing) {
        BlockState state = level.m_8055_(pos);
        return state.m_60734_() == this && (Boolean)state.m_61143_((Property)ACTIVE) != false && state.m_61143_((Property)FACING) == facing;
    }

    private void updateAllParts(Level level, BlockPos basePos, Direction facing, boolean open) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = 0; dy < 3; ++dy) {
                BlockPos partPos = basePos.m_5484_(facing.m_122427_(), dx).m_6630_(dy);
                BlockState partState = level.m_8055_(partPos);
                if (partState.m_60734_() != this) continue;
                level.m_7731_(partPos, (BlockState)partState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
    }
}

