/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.block.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.rezolv.obsidanum.block.BlocksObs;
import net.rezolv.obsidanum.block.custom.InvisiblePartDrum;
import net.rezolv.obsidanum.entity.ModEntities;
import net.rezolv.obsidanum.entity.mutated_gart.MutatedGart;

public class RitualDrum
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty USES = IntegerProperty.m_61631_((String)"uses", (int)0, (int)2);

    public RitualDrum(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)USES, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83144_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, USES});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.m_5776_()) {
            int currentUses = (Integer)state.m_61143_((Property)USES);
            if (currentUses < 2) {
                switch (currentUses) {
                    case 0: {
                        this.playBeeSound(level, pos, SoundEvents.f_11691_);
                        player.m_213846_((Component)Component.m_237115_((String)"message.obsidanum.drum_first"));
                        break;
                    }
                    case 1: {
                        this.playBeeSound(level, pos, SoundEvents.f_11690_);
                        player.m_213846_((Component)Component.m_237115_((String)"message.obsidanum.drum_second"));
                    }
                }
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)USES, (Comparable)Integer.valueOf(currentUses + 1)), 3);
            } else {
                Direction holeFacing;
                this.playBeeSound(level, pos, SoundEvents.f_11692_);
                player.m_213846_((Component)Component.m_237115_((String)"message.obsidanum.drum_final"));
                BlockPos spawnPos = null;
                float yRot = player.m_146908_();
                BlockPos holePos = this.findNearestObsidianHole(level, pos, 50);
                if (holePos != null && (spawnPos = this.findSpawnOppositeHole(level, holePos, holeFacing = (Direction)level.m_8055_(holePos).m_61143_((Property)FACING))) != null) {
                    yRot = holeFacing.m_122424_().m_122435_();
                }
                if (spawnPos == null) {
                    spawnPos = this.findValidSpawnPosition(level, pos, 20);
                }
                if (spawnPos != null) {
                    MutatedGart boss = new MutatedGart((EntityType<? extends Monster>)((EntityType)ModEntities.MUTATED_GART.get()), level);
                    boss.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, yRot, 0.0f);
                    level.m_7967_((Entity)boss);
                }
                level.m_46961_(pos, true);
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private BlockPos findSpawnOppositeHole(Level level, BlockPos holePos, Direction holeFacing) {
        BlockPos spawnCandidate = holePos.m_5484_(holeFacing.m_122424_(), 3);
        BlockPos surfacePos = this.findSurfaceAt(level, spawnCandidate);
        if (surfacePos != null && this.isValidSpawnArea(level, surfacePos)) {
            return surfacePos;
        }
        return null;
    }

    private BlockPos findNearestObsidianHole(Level level, BlockPos center, int radius) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BlockPos closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double distance;
                    mutablePos.m_122178_(center.m_123341_() + x, center.m_123342_() + y, center.m_123343_() + z);
                    if (level.m_8055_((BlockPos)mutablePos).m_60734_() != BlocksObs.OBSIDIAN_HOLE_5.get() || !((distance = center.m_123331_((Vec3i)mutablePos)) < closestDistance)) continue;
                    closest = mutablePos.m_7949_();
                    closestDistance = distance;
                }
            }
        }
        return closest;
    }

    private void playBeeSound(Level level, BlockPos pos, SoundEvent sound) {
        level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
    }

    private BlockPos findValidSpawnPosition(Level level, BlockPos center, int attempts) {
        Random random = new Random();
        int searchRadius = 20;
        for (int i = 0; i < attempts; ++i) {
            BlockPos checkPos;
            BlockPos surfacePos;
            int xOffset = random.nextInt(searchRadius * 2) - searchRadius;
            int zOffset = random.nextInt(searchRadius * 2) - searchRadius;
            if (Math.abs(xOffset) < 2 && Math.abs(zOffset) < 2 || (surfacePos = this.findSurfaceAt(level, checkPos = center.m_7918_(xOffset, 0, zOffset))) == null || !this.isValidSpawnArea(level, surfacePos)) continue;
            return surfacePos;
        }
        return null;
    }

    private BlockPos findSurfaceAt(Level level, BlockPos pos) {
        for (int y = pos.m_123342_(); y >= pos.m_123342_() - 3; --y) {
            BlockPos checkPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            if (!this.isSolidSurface(level, checkPos.m_7495_()) || !this.hasEnoughAir(level, checkPos)) continue;
            return checkPos;
        }
        return null;
    }

    private boolean isSolidSurface(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_280296_();
    }

    private boolean hasEnoughAir(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7494_()).m_60795_() && level.m_8055_(pos.m_6630_(2)).m_60795_();
    }

    private boolean isValidSpawnArea(Level level, BlockPos pos) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = 0; y <= 1; ++y) {
                    BlockPos check = pos.m_7918_(x, y, z);
                    if (Math.abs(x) < 2 && Math.abs(z) < 2 && y < 2 || !level.m_8055_(check).m_280296_()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!worldIn.m_5776_()) {
            worldIn.m_7731_(pos.m_122012_(), (BlockState)((Block)BlocksObs.INVISIBLE_PART_DRUM.get()).m_49966_().m_61124_((Property)InvisiblePartDrum.FACING, (Comparable)Direction.NORTH), 3);
            worldIn.m_7731_(pos.m_122019_(), (BlockState)((Block)BlocksObs.INVISIBLE_PART_DRUM.get()).m_49966_().m_61124_((Property)InvisiblePartDrum.FACING, (Comparable)Direction.SOUTH), 3);
            worldIn.m_7731_(pos.m_122029_(), (BlockState)((Block)BlocksObs.INVISIBLE_PART_DRUM.get()).m_49966_().m_61124_((Property)InvisiblePartDrum.FACING, (Comparable)Direction.EAST), 3);
            worldIn.m_7731_(pos.m_122024_(), (BlockState)((Block)BlocksObs.INVISIBLE_PART_DRUM.get()).m_49966_().m_61124_((Property)InvisiblePartDrum.FACING, (Comparable)Direction.WEST), 3);
            worldIn.m_7731_(pos.m_7494_(), (BlockState)((Block)BlocksObs.INVISIBLE_PART_DRUM.get()).m_49966_().m_61124_((Property)InvisiblePartDrum.FACING, (Comparable)Direction.UP), 3);
        }
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.m_5776_()) {
            this.removePart(worldIn, pos.m_122012_());
            this.removePart(worldIn, pos.m_122019_());
            this.removePart(worldIn, pos.m_122029_());
            this.removePart(worldIn, pos.m_122024_());
            this.removePart(worldIn, pos.m_7494_());
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    private void removePart(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof InvisiblePartDrum) {
            world.m_7471_(pos, false);
        }
    }
}

