/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.block.entity;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.rezolv.obsidanum.block.entity.ModBlockEntities;
import net.rezolv.obsidanum.gui.forge_crucible.recipes_render.ForgeCrucibleGuiMenu;
import org.jetbrains.annotations.Nullable;

public class ForgeCrucibleEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    public final ItemStackHandler itemHandler = new ItemStackHandler(12){

        protected void onContentsChanged(int slot) {
            ForgeCrucibleEntity.this.m_6596_();
            if (!ForgeCrucibleEntity.this.f_58857_.m_5776_()) {
                ForgeCrucibleEntity.this.f_58857_.m_7260_(ForgeCrucibleEntity.this.m_58899_(), ForgeCrucibleEntity.this.m_58900_(), ForgeCrucibleEntity.this.m_58900_(), 3);
            }
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final LazyOptional<? extends IItemHandler>[] handlers = new LazyOptional[Direction.values().length];
    public List<ItemStack> depositedItems = new ArrayList<ItemStack>();
    public CompoundTag receivedScrollData = new CompoundTag();

    public boolean isIngredientSatisfied(int index) {
        if (!this.receivedScrollData.m_128425_("Ingredients", 9)) {
            return false;
        }
        ListTag ingredientsTag = this.receivedScrollData.m_128437_("Ingredients", 10);
        if (index < 0 || index >= ingredientsTag.size()) {
            return false;
        }
        CompoundTag ingredientTag = ingredientsTag.m_128728_(index);
        int requiredCount = ingredientTag.m_128451_("count");
        if (ingredientTag.m_128441_("item")) {
            ItemStack required = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ingredientTag.m_128461_("item"))));
            int actualCount = this.getAmountOfItem(required);
            return actualCount >= requiredCount;
        }
        if (ingredientTag.m_128441_("tag")) {
            String tagId = ingredientTag.m_128461_("tag");
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(tagId));
            int totalCount = 0;
            for (ItemStack stack : this.depositedItems) {
                if (!stack.m_204117_(tagKey)) continue;
                totalCount += stack.m_41613_();
            }
            return totalCount >= requiredCount;
        }
        return false;
    }

    public void receiveScrollData(CompoundTag data) {
        this.receivedScrollData = data.m_6426_();
        if (!data.m_128441_("Ingredients") || data.m_128437_("Ingredients", 10).isEmpty()) {
            for (int i = 0; i < 6; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5, stack.m_41777_());
                itemEntity.m_32060_();
                this.f_58857_.m_7967_((Entity)itemEntity);
                this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
            }
        }
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void clearCrucibleData() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            ArrayList<ItemStack> itemsToDrop = new ArrayList<ItemStack>();
            for (int i = 0; i < 6; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                itemsToDrop.add(stack.m_41777_());
                this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
            }
            for (ItemStack stack : itemsToDrop) {
                ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5, stack);
                itemEntity.m_32060_();
                this.f_58857_.m_7967_((Entity)itemEntity);
            }
        }
        this.receivedScrollData = new CompoundTag();
        this.depositedItems.clear();
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int m_6893_() {
        return 256;
    }

    public CompoundTag getReceivedData() {
        return this.receivedScrollData.m_6426_();
    }

    public void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("CrucibleData", (Tag)this.receivedScrollData);
        pTag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        ListTag depositedList = new ListTag();
        for (ItemStack stack : this.depositedItems) {
            depositedList.add((Object)stack.m_41739_(new CompoundTag()));
        }
        pTag.m_128365_("DepositedItems", (Tag)depositedList);
    }

    protected Component m_6820_() {
        return null;
    }

    public AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new ForgeCrucibleGuiMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(this.f_58858_));
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("CrucibleData")) {
            this.receivedScrollData = pTag.m_128469_("CrucibleData");
        }
        if (pTag.m_128441_("Inventory")) {
            this.itemHandler.deserializeNBT(pTag.m_128469_("Inventory"));
        }
        this.depositedItems.clear();
        if (pTag.m_128441_("DepositedItems")) {
            ListTag depositedList = pTag.m_128437_("DepositedItems", 10);
            for (int i = 0; i < depositedList.size(); ++i) {
                this.depositedItems.add(ItemStack.m_41712_((CompoundTag)depositedList.m_128728_(i)));
            }
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        tag.m_128365_("CrucibleData", (Tag)this.receivedScrollData);
        ListTag depositedList = new ListTag();
        for (ItemStack stack : this.depositedItems) {
            CompoundTag itemTag = new CompoundTag();
            stack.m_41739_(itemTag);
            depositedList.add((Object)itemTag);
        }
        tag.m_128365_("DepositedItems", (Tag)depositedList);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
        this.depositedItems.clear();
        ListTag depositedList = tag.m_128437_("DepositedItems", 10);
        for (int i = 0; i < depositedList.size(); ++i) {
            this.depositedItems.add(ItemStack.m_41712_((CompoundTag)depositedList.m_128728_(i)));
        }
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public ForgeCrucibleEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FORGE_CRUCIBLE.get(), pPos, pBlockState);
        Arrays.fill(this.handlers, LazyOptional.empty());
        for (Direction dir : Direction.values()) {
            this.handlers[dir.ordinal()] = LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, dir));
        }
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox();
    }

    public int[] m_7071_(Direction side) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return true;
    }

    public boolean m_7157_(int i, ItemStack itemStack, Direction direction) {
        return true;
    }

    public int getAmountOfItem(ItemStack requiredStack) {
        int count = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)requiredStack)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public int m_6643_() {
        return this.itemHandler.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.itemHandler.extractItem(slot, amount, false);
    }

    protected NonNullList<ItemStack> m_7086_() {
        NonNullList items = NonNullList.m_122780_((int)this.itemHandler.getSlots(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        return items;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_7651_() {
        super.m_7651_();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    protected void m_6520_(NonNullList<ItemStack> stacks) {
        int slotsToCopy = Math.min(stacks.size(), this.itemHandler.getSlots());
        for (int i = 0; i < slotsToCopy; ++i) {
            this.itemHandler.setStackInSlot(i, (ItemStack)stacks.get(i));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlers[facing.ordinal()].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void m_6211_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }
}

