/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rezolv.obsidanum.block.entity.ModBlockEntities;

public class PranaCrystallEntity
extends BlockEntity {
    private final float rotSpeed;
    private final RandomSource randomSource;
    private final int lights;
    private final float rotOffset;
    private final Vec3 randomOffset;

    public PranaCrystallEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.PRANA_CRYSTALL.get(), pPos, pBlockState);
        this.randomSource = RandomSource.m_216335_((long)pPos.m_121878_());
        this.rotSpeed = (float)((double)(this.randomSource.m_188501_() * 0.5f + 1.0f) * this.randomSource.m_188583_());
        this.lights = this.randomSource.m_188503_(5) + 4;
        this.rotOffset = this.randomSource.m_188501_() * 360.0f;
        this.randomOffset = new Vec3((double)(this.randomSource.m_188501_() - 0.5f), (double)(this.randomSource.m_188501_() - 0.5f), (double)(this.randomSource.m_188501_() - 0.5f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return new AABB(pos.m_7918_(-4, -4, -4), pos.m_7918_(5, 5, 5));
    }

    public RandomSource getRandom() {
        return this.randomSource;
    }

    public int getLights() {
        return this.lights;
    }

    public float getRotOffset() {
        return this.rotOffset;
    }

    public float getRotSpeed() {
        return this.rotSpeed;
    }

    public Vec3 getRandomOffset() {
        return this.randomOffset;
    }

    public float calculateShineScale(Vec3 from) {
        double maxDist = 200.0;
        double dist = Math.min(from.m_82554_(Vec3.m_82512_((Vec3i)this.m_58899_())), maxDist);
        float f = (float)Math.pow(Math.sin(dist / maxDist * Math.PI), 0.5);
        return f * 3.0f;
    }
}

