/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import net.rezolv.obsidanum.block.entity.PranaCrystallEntity;
import net.rezolv.obsidanum.block.entity.renderer.ACRenderTypes;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class PranaCrystallRenderer<T extends PranaCrystallEntity>
implements BlockEntityRenderer<T> {
    private static final Map<BlockPos, PranaCrystallEntity> allOnScreen = new HashMap<BlockPos, PranaCrystallEntity>();
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private static final int SHINE_R = 69;
    private static final int SHINE_G = 206;
    private static final int SHINE_B = 162;
    private static final int SHINE_CENTER_R = 42;
    private static final int SHINE_CENTER_G = 255;
    private static final int SHINE_CENTER_B = 140;

    public PranaCrystallRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static void renderEntireBatch(LevelRenderer levelRenderer, PoseStack poseStack, int renderTick, Camera camera, float partialTick) {
        if (!allOnScreen.isEmpty()) {
            ArrayList<BlockPos> sortedPoses = new ArrayList<BlockPos>(allOnScreen.keySet());
            sortedPoses.sort((blockPos1, blockPos2) -> PranaCrystallRenderer.sortBlockPos(camera, blockPos1, blockPos2));
            poseStack.m_85836_();
            Vec3 cameraPos = camera.m_90583_();
            poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            for (BlockPos pos : sortedPoses) {
                Vec3 blockAt = Vec3.m_82512_((Vec3i)pos);
                poseStack.m_85836_();
                poseStack.m_85837_(blockAt.f_82479_, blockAt.f_82480_, blockAt.f_82481_);
                PranaCrystallRenderer.renderAt(allOnScreen.get(pos), partialTick, poseStack, (MultiBufferSource)bufferSource);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
        allOnScreen.clear();
    }

    private static int sortBlockPos(Camera camera, BlockPos blockPos1, BlockPos blockPos2) {
        double d1 = camera.m_90583_().m_82554_(Vec3.m_82512_((Vec3i)blockPos1));
        double d2 = camera.m_90583_().m_82554_(Vec3.m_82512_((Vec3i)blockPos2));
        return Double.compare(d2, d1);
    }

    public void render(T pranaCrystall, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (!pranaCrystall.m_58901_()) {
            allOnScreen.put(pranaCrystall.m_58899_(), (PranaCrystallEntity)((Object)pranaCrystall));
        } else {
            allOnScreen.remove(pranaCrystall.m_58899_());
        }
    }

    private static void renderAt(PranaCrystallEntity pranaCrystall, float partialTicks, PoseStack poseStack, MultiBufferSource buffer) {
        float scale = 1.0f;
        float time = 0.0f;
        if (Minecraft.m_91087_().m_91288_() != null) {
            scale = pranaCrystall.calculateShineScale(Minecraft.m_91087_().m_91288_().m_20318_(partialTicks));
            time = (float)Minecraft.m_91087_().m_91288_().f_19797_ + partialTicks;
        }
        if (scale > 0.0f) {
            Quaternionf cameraOrientation = Minecraft.m_91087_().m_91290_().m_253208_();
            float rotationTime = time * pranaCrystall.getRotSpeed() * 0.3f;
            float waveTime = time * 0.1f;
            poseStack.m_85836_();
            poseStack.m_252781_(cameraOrientation);
            VertexConsumer vertexConsumer = buffer.m_6299_(ACRenderTypes.getAmbersolShine());
            int lights = pranaCrystall.getLights();
            poseStack.m_252781_(Axis.f_252393_.m_252977_(pranaCrystall.getRotOffset()));
            for (int i = 0; i < lights; ++i) {
                float length = (float)(3.0 + Math.sin(waveTime + (float)(i * 2))) * scale;
                float width = (float)(1.0 - (double)0.2f * Math.abs(Math.cos((double)waveTime - (double)i * Math.PI * 0.5))) * scale;
                int alpha = 255;
                float u = 0.0f;
                float v = 0.0f;
                poseStack.m_85836_();
                poseStack.m_252781_(Axis.f_252393_.m_252977_(rotationTime - (float)i / (float)lights * 360.0f));
                PoseStack.Pose pose = poseStack.m_85850_();
                Matrix4f poseMatrix = pose.m_252922_();
                Matrix3f normalMatrix = pose.m_252943_();
                PranaCrystallRenderer.renderShineOrigin(vertexConsumer, poseMatrix, normalMatrix, alpha, u, v);
                PranaCrystallRenderer.renderShineLeftCorner(vertexConsumer, poseMatrix, normalMatrix, length, width, u, v);
                PranaCrystallRenderer.renderShineRightCorner(vertexConsumer, poseMatrix, normalMatrix, length, width, u, v);
                PranaCrystallRenderer.renderShineLeftCorner(vertexConsumer, poseMatrix, normalMatrix, length, width, u, v);
                poseStack.m_85849_();
            }
            PoseStack.Pose pose = poseStack.m_85850_();
            Matrix4f poseMatrix = pose.m_252922_();
            Matrix3f normalMatrix = pose.m_252943_();
            VertexConsumer lines = buffer.m_6299_(RenderType.m_110504_());
            poseStack.m_85849_();
        }
    }

    private static void renderShineOrigin(VertexConsumer vertexConsumer, Matrix4f poseMatrix, Matrix3f normalMatrix, int alpha, float u, float v) {
        vertexConsumer.m_252986_(poseMatrix, 0.0f, 0.0f, 0.0f).m_6122_(42, 255, 140, 230).m_7421_(u + 0.5f, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void renderShineLeftCorner(VertexConsumer vertexConsumer, Matrix4f poseMatrix, Matrix3f normalMatrix, float length, float width, float u, float v) {
        vertexConsumer.m_252986_(poseMatrix, -HALF_SQRT_3 * width, length, 0.0f).m_6122_(69, 206, 162, 0).m_7421_(u, v + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(normalMatrix, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void renderShineRightCorner(VertexConsumer vertexConsumer, Matrix4f poseMatrix, Matrix3f normalMatrix, float length, float width, float u, float v) {
        vertexConsumer.m_252986_(poseMatrix, HALF_SQRT_3 * width, length, 0.0f).m_6122_(69, 206, 162, 0).m_7421_(u + 1.0f, v + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(normalMatrix, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    public int m_142163_() {
        return 256;
    }
}

