/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.block.forge_crucible.neigbor_changed;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.rezolv.obsidanum.block.custom.ForgeCrucible;
import net.rezolv.obsidanum.block.custom.RightForgeScroll;
import net.rezolv.obsidanum.block.entity.ForgeCrucibleEntity;
import net.rezolv.obsidanum.block.entity.RightForgeScrollEntity;
import net.rezolv.obsidanum.block.enum_blocks.ScrollType;

public class AddTagsForgeCrucible {
    public static void handleNeighborUpdate(BlockState state, Level level, BlockPos pos, BlockPos fromPos) {
        BlockPos expectedRightPos;
        Direction facing = (Direction)state.m_61143_((Property)ForgeCrucible.FACING);
        switch (facing) {
            case NORTH: {
                BlockPos blockPos = pos.m_122024_();
                break;
            }
            case SOUTH: {
                BlockPos blockPos = pos.m_122029_();
                break;
            }
            case EAST: {
                BlockPos blockPos = pos.m_122012_();
                break;
            }
            case WEST: {
                BlockPos blockPos = pos.m_122019_();
                break;
            }
            default: {
                BlockPos blockPos = expectedRightPos = null;
            }
        }
        if (expectedRightPos != null && expectedRightPos.equals((Object)fromPos)) {
            BlockState rightState = level.m_8055_(expectedRightPos);
            BlockEntity be = level.m_7702_(pos);
            if (rightState.m_60734_() instanceof RightForgeScroll && rightState.m_61138_(RightForgeScroll.TYPE_SCROLL) && be instanceof ForgeCrucibleEntity) {
                ForgeCrucibleEntity crucible = (ForgeCrucibleEntity)be;
                ScrollType scrollType = (ScrollType)((Object)rightState.m_61143_(RightForgeScroll.TYPE_SCROLL));
                if (scrollType == ScrollType.NONE) {
                    Player player = level.m_5788_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 10.0, null);
                    if (player != null) {
                        crucible.clearCrucibleData();
                    }
                    return;
                }
                BlockEntity rightBe = level.m_7702_(expectedRightPos);
                if (rightBe instanceof RightForgeScrollEntity) {
                    RightForgeScrollEntity scrollEntity = (RightForgeScrollEntity)rightBe;
                    CompoundTag scrollNBT = scrollEntity.getScrollNBT();
                    CompoundTag dataToSend = new CompoundTag();
                    dataToSend.m_128359_("TypeScroll", scrollType.name());
                    if (scrollNBT.m_128425_("Ingredients", 9)) {
                        dataToSend.m_128365_("Ingredients", (Tag)scrollNBT.m_128437_("Ingredients", 10));
                    }
                    if (scrollNBT.m_128425_("RecipeResult", 9)) {
                        dataToSend.m_128365_("RecipeResult", (Tag)scrollNBT.m_128437_("RecipeResult", 10));
                    }
                    if (scrollNBT.m_128425_("RecipesPlans", 8)) {
                        dataToSend.m_128359_("RecipesPlans", scrollNBT.m_128461_("RecipesPlans"));
                    }
                    if (scrollNBT.m_128425_("BonusOutputs", 9)) {
                        ListTag bonusOutputs = scrollNBT.m_128437_("BonusOutputs", 10);
                        dataToSend.m_128365_("BonusOutputs", (Tag)bonusOutputs);
                        ListTag processedBonuses = new ListTag();
                        for (Tag bonusTag : bonusOutputs) {
                            int max;
                            if (!(bonusTag instanceof CompoundTag)) continue;
                            CompoundTag bonusCompound = (CompoundTag)bonusTag;
                            CompoundTag processed = new CompoundTag();
                            if (bonusCompound.m_128425_("Item", 10)) {
                                processed.m_128365_("Item", (Tag)bonusCompound.m_128469_("Item"));
                            }
                            float chance = bonusCompound.m_128425_("Chance", 5) ? bonusCompound.m_128457_("Chance") : 1.0f;
                            processed.m_128350_("Chance", chance);
                            int min = bonusCompound.m_128425_("Min", 3) ? bonusCompound.m_128451_("Min") : 1;
                            int n = max = bonusCompound.m_128425_("Max", 3) ? bonusCompound.m_128451_("Max") : min;
                            if (max < min) {
                                max = min;
                            }
                            processed.m_128405_("Min", min);
                            processed.m_128405_("Max", max);
                            processedBonuses.add((Object)processed);
                        }
                        dataToSend.m_128365_("ProcessedBonuses", (Tag)processedBonuses);
                    }
                    crucible.receiveScrollData(dataToSend);
                    crucible.m_6596_();
                    level.m_7260_(pos, state, state, 3);
                }
            }
        }
    }
}

