/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.block.forge_crucible.neigbor_changed;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import net.rezolv.obsidanum.Obsidanum;
import net.rezolv.obsidanum.block.custom.ForgeCrucible;
import net.rezolv.obsidanum.block.custom.LeftCornerLevel;
import net.rezolv.obsidanum.block.entity.ForgeCrucibleEntity;

public class LeftCornerCompleteRecipe {
    public static void handleNeighborUpdate(BlockState state, Level level, BlockPos pos, BlockPos fromPos) {
        Direction facing = (Direction)state.m_61143_((Property)ForgeCrucible.FACING);
        BlockPos expectedLeftPos = LeftCornerCompleteRecipe.getLeftPos(pos, facing);
        if (expectedLeftPos != null && expectedLeftPos.equals((Object)fromPos)) {
            ForgeCrucibleEntity crucible;
            BlockState leftBlockState = level.m_8055_(expectedLeftPos);
            BlockEntity crucibleEntity = level.m_7702_(pos);
            if (leftBlockState.m_60734_() instanceof LeftCornerLevel && ((Boolean)leftBlockState.m_61143_((Property)LeftCornerLevel.IS_PRESSED)).booleanValue() && crucibleEntity instanceof ForgeCrucibleEntity && LeftCornerCompleteRecipe.checkAllIngredientsWithCount(crucible = (ForgeCrucibleEntity)crucibleEntity)) {
                LeftCornerCompleteRecipe.createCraftingResult(crucible);
            }
        }
    }

    private static BlockPos getLeftPos(BlockPos pos, Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> pos.m_122029_();
            case Direction.SOUTH -> pos.m_122024_();
            case Direction.EAST -> pos.m_122019_();
            case Direction.WEST -> pos.m_122012_();
            default -> null;
        };
    }

    private static boolean checkAllIngredientsWithCount(ForgeCrucibleEntity crucible) {
        CompoundTag data = crucible.getReceivedData();
        if (!data.m_128425_("Ingredients", 9)) {
            return false;
        }
        ListTag ingredients = data.m_128437_("Ingredients", 10);
        for (int i = 0; i < ingredients.size(); ++i) {
            CompoundTag ingredient = ingredients.m_128728_(i);
            ItemStack slotStack = crucible.itemHandler.getStackInSlot(i);
            try {
                int requiredCount;
                JsonObject json = JsonParser.parseString((String)ingredient.m_128461_("IngredientJson")).getAsJsonObject();
                int n = requiredCount = json.has("count") ? json.get("count").getAsInt() : 1;
                if (slotStack.m_41613_() < requiredCount) {
                    return false;
                }
                if (LeftCornerCompleteRecipe.matchesIngredient(slotStack, json)) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private static boolean matchesIngredient(ItemStack stack, JsonObject json) {
        if (stack.m_41619_()) {
            return false;
        }
        if (json.has("item")) {
            ResourceLocation itemId = new ResourceLocation(json.get("item").getAsString());
            return ForgeRegistries.ITEMS.getValue(itemId) == stack.m_41720_();
        }
        if (json.has("tag")) {
            ResourceLocation tagId = new ResourceLocation(json.get("tag").getAsString());
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId);
            return stack.m_204117_(tag);
        }
        return false;
    }

    private static void createCraftingResult(ForgeCrucibleEntity crucible) {
        if (!LeftCornerCompleteRecipe.checkAllIngredientsWithCount(crucible)) {
            return;
        }
        CompoundTag data = crucible.getReceivedData();
        if (!data.m_128425_("RecipeResult", 9)) {
            return;
        }
        ListTag resultList = data.m_128437_("RecipeResult", 10);
        if (resultList.isEmpty()) {
            return;
        }
        ItemStack resultStack = ItemStack.m_41712_((CompoundTag)resultList.m_128728_(0));
        int resultCount = resultStack.m_41613_();
        ItemStack currentResult = crucible.itemHandler.getStackInSlot(6);
        if (!currentResult.m_41619_()) {
            if (!ItemStack.m_150942_((ItemStack)currentResult, (ItemStack)resultStack)) {
                return;
            }
            if (currentResult.m_41613_() + resultCount > currentResult.m_41741_()) {
                return;
            }
        }
        ListTag ingredients = data.m_128437_("Ingredients", 10);
        for (int i = 0; i < ingredients.size(); ++i) {
            CompoundTag ingredient = ingredients.m_128728_(i);
            try {
                JsonObject json = JsonParser.parseString((String)ingredient.m_128461_("IngredientJson")).getAsJsonObject();
                int requiredCount = json.has("count") ? json.get("count").getAsInt() : 1;
                crucible.itemHandler.extractItem(i, requiredCount, false);
                continue;
            }
            catch (Exception e) {
                Obsidanum.LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u0438 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432 \u0438\u0437 \u0441\u043b\u043e\u0442\u0430 {}: {}", (Object)i, (Object)e.getMessage());
            }
        }
        if (currentResult.m_41619_()) {
            crucible.itemHandler.setStackInSlot(6, resultStack.m_41777_());
        } else {
            currentResult.m_41769_(resultCount);
            crucible.itemHandler.setStackInSlot(6, currentResult);
        }
        if (data.m_128425_("BonusOutputs", 9)) {
            ListTag bonusOutputs = data.m_128437_("BonusOutputs", 10);
            Random random = new Random();
            ArrayList<ItemStack> bonusesToAdd = new ArrayList<ItemStack>();
            for (int i = 0; i < bonusOutputs.size(); ++i) {
                CompoundTag bonusTag = bonusOutputs.m_128728_(i);
                if (!bonusTag.m_128425_("Item", 10) || !bonusTag.m_128425_("Chance", 5) || !(random.nextFloat() <= bonusTag.m_128457_("Chance"))) continue;
                ItemStack bonusStack = ItemStack.m_41712_((CompoundTag)bonusTag.m_128469_("Item"));
                int min = bonusTag.m_128441_("Min") ? bonusTag.m_128451_("Min") : 1;
                int max = bonusTag.m_128441_("Max") ? bonusTag.m_128451_("Max") : min;
                int count = min;
                if (max > min) {
                    count = min + random.nextInt(max - min + 1);
                }
                if (count <= 0) continue;
                ItemStack stackToAdd = bonusStack.m_41777_();
                stackToAdd.m_41764_(count);
                bonusesToAdd.add(stackToAdd);
            }
            block4: for (ItemStack bonusStack : bonusesToAdd) {
                ItemStack slotStack;
                int slot;
                boolean added = false;
                for (slot = 7; slot <= 11; ++slot) {
                    int canAdd;
                    slotStack = crucible.itemHandler.getStackInSlot(slot);
                    if (slotStack.m_41619_() || !ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)bonusStack) || (canAdd = Math.min(bonusStack.m_41613_(), slotStack.m_41741_() - slotStack.m_41613_())) <= 0) continue;
                    slotStack.m_41769_(canAdd);
                    bonusStack.m_41774_(canAdd);
                    crucible.itemHandler.setStackInSlot(slot, slotStack);
                    if (!bonusStack.m_41619_()) continue;
                    added = true;
                    break;
                }
                if (added || bonusStack.m_41619_()) continue;
                for (slot = 7; slot <= 11; ++slot) {
                    slotStack = crucible.itemHandler.getStackInSlot(slot);
                    if (!slotStack.m_41619_()) continue;
                    crucible.itemHandler.setStackInSlot(slot, bonusStack.m_41777_());
                    added = true;
                    continue block4;
                }
            }
        }
        crucible.m_58904_().m_7260_(crucible.m_58899_(), crucible.m_58900_(), crucible.m_58900_(), 3);
        crucible.m_6596_();
    }
}

